/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.logging;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonObject;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.Address;
import org.swisspush.gateleen.core.util.JsonObjectUtils;

public class RequestLogger {
    public static final String OK = "ok";
    public static final String ERROR = "error";
    public static final String MESSAGE = "message";
    public static final String STATUS = "status";
    public static final String REQUEST_URI = "request_uri";
    public static final String REQUEST_METHOD = "request_method";
    public static final String REQUEST_HEADERS = "request_headers";
    public static final String RESPONSE_HEADERS = "response_headers";
    public static final String REQUEST_STATUS = "request_status";
    public static final String BODY = "body";

    private RequestLogger() {
    }

    public static void logRequest(EventBus eventBus, HttpServerRequest request, int status, Buffer data) {
        RequestLogger.logRequest(eventBus, request, status, data, request.response().headers());
    }

    public static void logRequest(EventBus eventBus, HttpServerRequest request, int status, Buffer data, MultiMap responseHeaders) {
        Logger log = RequestLoggerFactory.getLogger(RequestLogger.class, request);
        log.info("Notify logging to eventually log the payload and headers of request to uri {}", (Object)request.uri());
        JsonObject logEntry = new JsonObject();
        logEntry.put(REQUEST_URI, (Object)request.uri());
        logEntry.put(REQUEST_METHOD, (Object)request.method().name());
        logEntry.put(REQUEST_HEADERS, (Object)JsonObjectUtils.multiMapToJsonObject(request.headers()));
        logEntry.put(RESPONSE_HEADERS, (Object)JsonObjectUtils.multiMapToJsonObject(responseHeaders));
        logEntry.put(REQUEST_STATUS, (Object)status);
        logEntry.put(BODY, (Object)data.toString());
        eventBus.request(Address.requestLoggingConsumerAddress(), (Object)logEntry, reply -> {
            if (reply.failed()) {
                log.warn("Failed to log the payload and headers. Cause: {}", (Object)reply.cause().getMessage());
            } else if (ERROR.equals(((JsonObject)((Message)reply.result()).body()).getString(STATUS))) {
                log.warn("Failed to log the payload and headers. Cause: {}", (Object)((JsonObject)((Message)reply.result()).body()).getString(MESSAGE));
            }
        });
    }
}

