/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Arrays;
import org.swisspush.gateleen.core.json.JsonMultiMap;

public class HttpRequest {
    private HttpMethod method;
    private String uri;
    private byte[] payload;
    private MultiMap headers;

    public HttpRequest(HttpMethod method, String uri, MultiMap headers, byte[] payload) {
        this.method = method;
        this.uri = uri;
        this.headers = headers;
        this.payload = payload == null ? new byte[0] : Arrays.copyOf(payload, payload.length);
    }

    public HttpRequest(JsonObject object) {
        this.method = HttpMethod.valueOf((String)object.getString("method"));
        this.uri = object.getString("uri");
        if (this.method == null || this.uri == null) {
            throw new IllegalArgumentException("Request fields 'uri' and 'method' must be set");
        }
        switch (this.method.name()) {
            case "GET": 
            case "HEAD": 
            case "PUT": 
            case "POST": 
            case "DELETE": 
            case "OPTIONS": 
            case "PATCH": {
                break;
            }
            default: {
                throw new IllegalArgumentException("Request method must be one of GET, HEAD, PUT, POST, DELETE, OPTIONS or PATCH");
            }
        }
        JsonArray headersArray = object.getJsonArray("headers");
        if (headersArray != null) {
            this.headers = JsonMultiMap.fromJson(headersArray);
        }
        this.payload = object.getBinary("payload");
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.put("method", (Object)this.method.name());
        object.put("uri", (Object)this.uri);
        if (this.headers != null) {
            object.put("headers", (Object)JsonMultiMap.toJson(this.headers));
        }
        object.put("payload", (Object)this.payload);
        return object;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public String getUri() {
        return this.uri;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public MultiMap getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultiMap headers) {
        this.headers = headers;
    }
}

