/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import com.google.common.base.Joiner;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.StatusCode;

public final class ExpansionDeltaUtil {
    private static final String SLASH = "/";
    private static Logger log = LoggerFactory.getLogger(ExpansionDeltaUtil.class);

    private ExpansionDeltaUtil() {
    }

    public static String mapToDelimetedString(MultiMap map, String delim) {
        return Joiner.on((String)delim).withKeyValueSeparator("=").join((Iterable)map);
    }

    public static String removeFromEndOfString(String source, String stringToRemove) {
        if (stringToRemove == null) {
            return source;
        }
        String result = source;
        if (source != null && source.endsWith(stringToRemove)) {
            result = source.substring(0, source.length() - 1);
        }
        return result;
    }

    public static String extractCollectionFromPath(String path) {
        String extractedCollectionName = null;
        String pathModified = ExpansionDeltaUtil.removeFromEndOfString(path, SLASH);
        String[] pathSegments = pathModified.split(SLASH);
        if (pathSegments.length > 0) {
            extractedCollectionName = pathSegments[pathSegments.length - 1];
        }
        return extractedCollectionName;
    }

    public static List<String> extractCollectionResourceNames(JsonArray collectionArray) throws ResourceCollectionException {
        ArrayList<String> collectionResourceNames = new ArrayList<String>();
        for (Object colEntry : collectionArray) {
            if (!(colEntry instanceof String)) {
                throw new ResourceCollectionException("the backend doesn't seem to support delta-handling on this resource", StatusCode.BAD_REQUEST);
            }
            collectionResourceNames.add((String)colEntry);
        }
        return collectionResourceNames;
    }

    public static String constructRequestUri(String path, MultiMap params, List<String> paramsToRemove, String subResource, SlashHandling slashHandling) {
        Object result = path;
        if (paramsToRemove != null) {
            for (String paramToRemove : paramsToRemove) {
                params.remove(paramToRemove);
            }
        }
        boolean pathEndsWithSlash = ((String)result).endsWith(SLASH);
        if (subResource != null) {
            result = pathEndsWithSlash ? (String)result + subResource : (String)result + SLASH + subResource;
        }
        if (slashHandling.equals((Object)SlashHandling.END_WITH_SLASH)) {
            if (!pathEndsWithSlash) {
                result = (String)result + SLASH;
            }
        } else if (slashHandling.equals((Object)SlashHandling.END_WITHOUT_SLASH)) {
            result = ExpansionDeltaUtil.removeFromEndOfString((String)result, SLASH);
        }
        if (!params.isEmpty()) {
            result = (String)result + "?" + ExpansionDeltaUtil.mapToDelimetedString(params, "&");
        }
        return result;
    }

    public static Handler<Throwable> createRequestExceptionHandler(HttpServerRequest request, String uri, Class<?> caller) {
        return exception -> {
            log.trace("end response with content");
            HttpServerResponse rsp = request.response();
            if (exception instanceof TimeoutException) {
                ExpansionDeltaUtil.error("Timeout", request, uri, caller);
                rsp.setStatusCode(StatusCode.TIMEOUT.getStatusCode());
                rsp.setStatusMessage(StatusCode.TIMEOUT.getStatusMessage());
                try {
                    rsp.end(rsp.getStatusMessage());
                }
                catch (IllegalStateException ex) {
                    log.debug("ignore because maybe already closed", (Throwable)ex);
                }
            } else {
                ExpansionDeltaUtil.error(exception.getMessage(), request, uri, caller);
                rsp.setStatusCode(StatusCode.SERVICE_UNAVAILABLE.getStatusCode());
                rsp.setStatusMessage(StatusCode.SERVICE_UNAVAILABLE.getStatusMessage());
                try {
                    rsp.end(rsp.getStatusMessage());
                }
                catch (IllegalStateException ex) {
                    log.debug("ignore because maybe already closed", (Throwable)ex);
                }
            }
        };
    }

    public static Handler<Throwable> createResponseExceptionHandler(HttpServerRequest request, String uri, Class<?> caller) {
        return exception -> {
            ExpansionDeltaUtil.error("Problem with backend: " + exception.getMessage(), request, uri, caller);
            HttpServerResponse rsp = request.response();
            rsp.setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            rsp.setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
            try {
                rsp.end(rsp.getStatusMessage());
            }
            catch (IllegalStateException ex) {
                log.debug("ignore because maybe already closed", (Throwable)ex);
            }
        };
    }

    public static CollectionResourceContainer verifyCollectionResponse(HttpServerRequest request, Buffer data, Set<String> originalParams) throws ResourceCollectionException {
        ExpansionDeltaUtil.checkResponse(request);
        String targetPath = request.path();
        return ExpansionDeltaUtil.verifyCollectionResponse(targetPath, data, originalParams);
    }

    private static void error(String message, HttpServerRequest request, String uri, Class<?> caller) {
        RequestLoggerFactory.getLogger(caller, request).error(uri + " " + message);
    }

    private static void checkResponse(HttpServerRequest request) throws ResourceCollectionException {
        StatusCode statusCode = StatusCode.fromCode(request.response().getStatusCode());
        if (statusCode != null && statusCode != StatusCode.OK && statusCode != StatusCode.FOUND) {
            throw new ResourceCollectionException(request.response().getStatusMessage(), statusCode);
        }
    }

    public static CollectionResourceContainer verifyCollectionResponse(String targetPath, Buffer data, Set<String> originalParams) throws ResourceCollectionException {
        JsonObject obj;
        String collectionName = ExpansionDeltaUtil.extractCollectionFromPath(targetPath);
        if (collectionName == null) {
            throw new ResourceCollectionException("No collection name found in path " + targetPath, StatusCode.BAD_REQUEST);
        }
        if (data.length() == 0) {
            String params = "''";
            if (originalParams != null) {
                params = originalParams.toString();
            }
            throw new ResourceCollectionException("Request did not return data. Invalid usage of params " + params + " ?", StatusCode.BAD_REQUEST);
        }
        String dataAsString = data.toString(StandardCharsets.UTF_8);
        try {
            obj = new JsonObject(dataAsString);
        }
        catch (DecodeException e) {
            int MAX_CHARS_TO_REPORT = 65536;
            StringBuilder msg = new StringBuilder(4096);
            msg.append("Failed to decode JSON");
            if (65536 < dataAsString.length()) {
                msg.append(". First 65536 chars were");
            }
            msg.append(":\n\n");
            msg.append(dataAsString, 0, Math.min(65536, dataAsString.length())).append("\n");
            throw new ResourceCollectionException(msg.toString(), StatusCode.BAD_GATEWAY, e);
        }
        JsonArray collectionEntries = obj.getJsonArray(collectionName);
        if (collectionEntries == null) {
            throw new ResourceCollectionException("Collection with name '" + collectionName + "' not found in result of request " + targetPath, StatusCode.BAD_REQUEST);
        }
        return new CollectionResourceContainer(collectionName, ExpansionDeltaUtil.extractCollectionResourceNames(collectionEntries));
    }

    public static class CollectionResourceContainer {
        private final String collectionName;
        private final List<String> resourceNames;

        public CollectionResourceContainer(String collectionName, List<String> resourceNames) {
            this.collectionName = collectionName;
            this.resourceNames = resourceNames;
        }

        public String getCollectionName() {
            return this.collectionName;
        }

        public List<String> getResourceNames() {
            return this.resourceNames;
        }
    }

    public static enum SlashHandling {
        END_WITH_SLASH,
        END_WITHOUT_SLASH,
        KEEP;

    }
}

