/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.MultiMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.HttpRequestHeader;

public class HttpHeaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(HttpHeaderUtil.class);

    public static <T extends MultiMap> T removeNonForwardHeaders(T headers) {
        String CONNECTION = HttpRequestHeader.CONNECTION.getName();
        headers.getAll(CONNECTION).forEach(arg_0 -> headers.remove(arg_0));
        headers.remove(CONNECTION);
        return headers;
    }

    @Nullable
    public static <T extends MultiMap> String getHeaderValue(@Nonnull T headers, @Nonnull String headerKey) {
        for (Map.Entry entry : headers.entries()) {
            if (!((String)entry.getKey()).equalsIgnoreCase(headerKey)) continue;
            String value = (String)entry.getValue();
            if (value != null) {
                return value.trim();
            }
            return null;
        }
        return null;
    }

    public static <T extends MultiMap> boolean hasMatchingHeader(@Nonnull T headers, @Nonnull Pattern headersPattern) {
        for (Map.Entry entry : headers) {
            String header = (String)entry.getKey() + ": " + (String)entry.getValue();
            if (!headersPattern.matcher(header).matches()) continue;
            return true;
        }
        return false;
    }

    public static void mergeHeaders(@Nonnull MultiMap destination, @Nonnull MultiMap source, @Nullable String context) {
        source.forEach(sourceHeader -> {
            if (destination.contains((String)sourceHeader.getKey())) {
                String sourceValue;
                String destinationValue = destination.get((String)sourceHeader.getKey());
                if (!destinationValue.equals(sourceValue = source.get((String)sourceHeader.getKey()))) {
                    LOG.error("{}} values do not match {} != {} for request {}", new Object[]{sourceHeader.getKey(), destinationValue, sourceValue, context});
                }
                destination.remove((String)sourceHeader.getKey());
            }
        });
        destination.addAll(source);
    }
}

