/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;

public final class RedisUtils {
    public static final String REPLY_STATUS = "status";
    public static final String REPLY_MESSAGE = "message";
    public static final String REPLY_VALUE = "value";
    public static final String STATUS_OK = "ok";

    private RedisUtils() {
    }

    public static List<String> toPayload(Object ... parameters) {
        ArrayList<String> result = new ArrayList<String>(parameters.length);
        for (Object param : parameters) {
            if (param instanceof JsonArray) {
                param = ((JsonArray)param).getList();
            }
            if (param instanceof JsonObject) {
                param = ((JsonObject)param).getMap();
            }
            if (param instanceof Collection) {
                ((Collection)param).stream().filter(Objects::nonNull).forEach(o -> result.add(o.toString()));
                continue;
            }
            if (param instanceof Map) {
                for (Map.Entry pair : ((Map)param).entrySet()) {
                    result.add(pair.getKey().toString());
                    result.add(pair.getValue().toString());
                }
                continue;
            }
            if (param instanceof Stream) {
                ((Stream)param).forEach(e -> {
                    if (e instanceof Object[]) {
                        Collections.addAll(result, (String[])e);
                    } else {
                        result.add(e.toString());
                    }
                });
                continue;
            }
            if (param == null) continue;
            result.add(param.toString());
        }
        return result;
    }
}

