/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.swisspush.gateleen.core.util.Unit;

public final class Result<TOk, TErr> {
    private static Result UNIT_ERROR = new Result<Object, Unit>(null, Unit.get());
    private static Result UNIT_OK = new Result<Unit, Object>(Unit.get(), null);
    @Nullable
    private final TOk okValue;
    @Nullable
    private final TErr errValue;

    private Result(@Nullable TOk okValue, @Nullable TErr errValue) {
        if (okValue != null && errValue != null) {
            throw new IllegalStateException("A result cannot be ok and error at the same time");
        }
        this.okValue = okValue;
        this.errValue = errValue;
    }

    public static <TOk, TErr> Result<TOk, TErr> ok(TOk value) {
        if (value == Unit.get()) {
            return UNIT_OK;
        }
        return new Result<TOk, Object>(Objects.requireNonNull(value, "You tried to construct a OK result with null value. Hint: Use Unit."), null);
    }

    public static <TOk, TErr> Result<TOk, TErr> err(TErr value) {
        if (value == Unit.get()) {
            return UNIT_ERROR;
        }
        return new Result<Object, TErr>(null, Objects.requireNonNull(value, "You tried to construct an ERROR result with null value. Hint: Use Unit."));
    }

    public boolean isOk() {
        return this.okValue != null;
    }

    public TOk ok() throws IllegalStateException {
        TOk localOk = this.okValue;
        if (localOk == null) {
            throw new IllegalStateException("Cannot call this method for results in error state");
        }
        return localOk;
    }

    public Optional<TOk> okOptional() {
        return Optional.ofNullable(this.okValue);
    }

    public boolean isErr() {
        return !this.isOk();
    }

    public TErr err() throws IllegalStateException {
        TErr localError = this.errValue;
        if (localError == null) {
            throw new IllegalStateException("Cannot call this method for results in ok state");
        }
        return localError;
    }

    public <R> R handle(RetHandler<TOk, TErr, R> handler) {
        if (this.isOk()) {
            return handler.onOk(this.ok());
        }
        return handler.onErr(this.err());
    }

    public void handle(Handler<TOk, TErr> handler) {
        if (this.isOk()) {
            handler.onOk(this.ok());
        } else {
            handler.onErr(this.err());
        }
    }

    public void ifOk(Consumer<TOk> okHandler) {
        if (this.isOk()) {
            okHandler.accept(this.ok());
        }
    }

    public <T> Result<T, TErr> mapOk(Function<TOk, T> mapFunction) {
        if (this.isOk()) {
            return Result.ok(mapFunction.apply(this.ok()));
        }
        return Result.err(this.err());
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        if (this.okValue != null ? !this.okValue.equals(result.okValue) : result.okValue != null) {
            return false;
        }
        return this.errValue != null ? this.errValue.equals(result.errValue) : result.errValue == null;
    }

    public int hashCode() {
        int result = this.okValue != null ? this.okValue.hashCode() : 0;
        result = 31 * result + (this.errValue != null ? this.errValue.hashCode() : 0);
        return result;
    }

    public String toString() {
        if (this.isOk()) {
            return "ResultOk{" + String.valueOf(this.okValue) + "}";
        }
        return "ResultErr{" + String.valueOf(this.errValue) + "}";
    }

    public static interface Handler<TOk, TErr> {
        public void onOk(TOk var1);

        public void onErr(TErr var1);
    }

    public static interface RetHandler<TOk, TErr, R> {
        public R onOk(TOk var1);

        public R onErr(TErr var1);
    }
}

