/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.configuration;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.ValidationMessage;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.IOException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.json.JsonUtil;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.core.validation.ValidationStatus;

class ConfigurationResourceValidator {
    private static final String SCHEMA_DECLARATION = "http://json-schema.org/draft-04/schema#";
    private static final Logger log = LoggerFactory.getLogger(ConfigurationResourceValidator.class);
    private final Vertx vertx;

    public ConfigurationResourceValidator(Vertx vertx) {
        this.vertx = vertx;
    }

    public void validateConfigurationResource(Buffer configurationResource, String resourceSchema, Handler<AsyncResult<ValidationResult>> resultHandler) {
        this.vertx.executeBlocking(future -> {
            block11: {
                JsonObject schemaObject;
                if (!JsonUtil.isValidJson(configurationResource)) {
                    String message = "Unable to parse json";
                    log.warn(message);
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                    return;
                }
                if (StringUtils.isEmpty(resourceSchema)) {
                    log.info("validated positive since no schema was provided");
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_POSITIV));
                    return;
                }
                try {
                    schemaObject = new JsonObject(resourceSchema);
                }
                catch (DecodeException ex) {
                    String message = "Unable to parse json schema";
                    log.warn(message);
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                    return;
                }
                if (SCHEMA_DECLARATION.equals(schemaObject.getString("$schema"))) {
                    JsonSchema schema;
                    try {
                        schema = JsonSchemaFactory.getInstance().getSchema(resourceSchema);
                    }
                    catch (Exception e) {
                        String message = "Cannot load schema";
                        log.warn(message, (Throwable)e);
                        future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                        return;
                    }
                    try {
                        JsonNode jsonNode = new ObjectMapper().readTree(configurationResource.toString());
                        Set valMsgs = schema.validate(jsonNode);
                        if (valMsgs.isEmpty()) {
                            log.info("validated positive");
                            future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_POSITIV));
                            break block11;
                        }
                        JsonArray validationDetails = this.extractMessagesAsJson(valMsgs);
                        future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, "Validation failed", validationDetails));
                    }
                    catch (IOException e) {
                        String message = "Cannot read JSON";
                        log.warn("{}", (Object)message, (Object)e);
                        future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                    }
                } else {
                    String message = "Invalid schema: Expected property '$schema' with content 'http://json-schema.org/draft-04/schema#'";
                    log.warn("{}", (Object)message);
                    future.complete((Object)new ValidationResult(ValidationStatus.VALIDATED_NEGATIV, message));
                }
            }
        }, resultHandler);
    }

    private JsonArray extractMessagesAsJson(Set<ValidationMessage> valMsgs) {
        JsonArray resultArray = new JsonArray();
        for (ValidationMessage msg : valMsgs) {
            log.warn("{}", (Object)msg);
            resultArray.add((Object)JsonObject.mapFrom((Object)msg));
        }
        return resultArray;
    }
}

