/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.http;

import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpServerRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerWrapper;

public final class RequestLoggerFactory {
    private RequestLoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz, HttpServerRequest request) {
        return RequestLoggerFactory.getLogger(clazz, request.headers());
    }

    public static Logger getLogger(Class<?> clazz, MultiMap headers) {
        Object uid = null;
        if (headers != null) {
            String rid = headers.get("x-request-id");
            if (rid != null) {
                uid = rid;
            }
            if ((rid = headers.get("x-rp-unique_id")) != null) {
                uid = uid != null ? (String)uid + " " + rid : rid;
            }
        }
        if (uid != null) {
            return new RequestLoggerWrapper(LoggerFactory.getLogger(clazz), (String)uid);
        }
        return LoggerFactory.getLogger(clazz);
    }
}

