/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.util;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lock.Lock;

public class LockUtil {
    private LockUtil() {
    }

    public static Future<Boolean> acquireLock(Lock lockImpl, String lock, String token, long lockExpiryMs, Logger log) {
        Promise promise = Promise.promise();
        if (lockImpl == null) {
            log.info("No lock implementation defined, going to pretend like we got the lock");
            promise.complete((Object)Boolean.TRUE);
            return promise.future();
        }
        log.debug("Trying to acquire lock '{}' with token '{}' and expiry {}ms", new Object[]{lock, token, lockExpiryMs});
        lockImpl.acquireLock(lock, token, lockExpiryMs).onComplete(lockEvent -> {
            if (lockEvent.succeeded()) {
                if (((Boolean)lockEvent.result()).booleanValue()) {
                    log.debug("Acquired lock '{}' with token '{}'", (Object)lock, (Object)token);
                    promise.complete((Object)Boolean.TRUE);
                } else {
                    promise.complete((Object)Boolean.FALSE);
                }
            } else {
                promise.fail(lockEvent.cause());
            }
        });
        return promise.future();
    }

    public static void releaseLock(Lock lockImpl, String lock, String token, Logger log) {
        if (lockImpl == null) {
            log.info("No lock implementation defined, going to pretend like we released the lock");
            return;
        }
        log.debug("Trying to release lock '{}' with token '{}'", (Object)lock, (Object)token);
        lockImpl.releaseLock(lock, token).onComplete(releaseEvent -> {
            if (releaseEvent.succeeded()) {
                if (((Boolean)releaseEvent.result()).booleanValue()) {
                    log.debug("Released lock '{}' with token '{}'", (Object)lock, (Object)token);
                }
            } else {
                log.error("Could not release lock '{}'.", (Object)lock, (Object)new Exception("stacktrace", releaseEvent.cause()));
            }
        });
    }
}

