/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.core.lock.lua;

import io.vertx.core.Promise;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.core.redis.RedisProvider;

public class ReleaseLockRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Promise<Boolean> promise;
    private RedisProvider redisProvider;
    private Logger log;

    public ReleaseLockRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisProvider redisProvider, Logger log, Promise<Boolean> promise) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisProvider = redisProvider;
        this.log = log;
        this.promise = promise;
    }

    @Override
    public void exec(int executionCounter) {
        ArrayList<String> args = new ArrayList<String>();
        args.add(this.luaScriptState.getSha());
        args.add(String.valueOf(this.keys.size()));
        args.addAll(this.keys);
        args.addAll(this.arguments);
        this.redisProvider.redis().onComplete(redisEv -> {
            if (redisEv.failed()) {
                this.promise.fail((Throwable)new Exception("redisProvider.redis()", redisEv.cause()));
                return;
            }
            RedisAPI redisAPI = (RedisAPI)redisEv.result();
            redisAPI.evalsha(args, event -> {
                if (event.succeeded()) {
                    Long unlocked = ((Response)event.result()).toLong();
                    this.promise.complete((Object)(unlocked > 0L ? 1 : 0));
                } else {
                    Throwable ex = event.cause();
                    String message = ex.getMessage();
                    if (message != null && message.startsWith("NOSCRIPT")) {
                        this.log.warn("ReleaseLockRedisCommand script couldn't be found, reload it", (Throwable)new Exception("stacktrace", ex));
                        this.log.warn("amount the script got loaded: {}", (Object)executionCounter);
                        if (executionCounter > 10) {
                            this.promise.fail((Throwable)new Exception("amount the script got loaded is higher than 10, we abort"));
                        } else {
                            this.luaScriptState.loadLuaScript(new ReleaseLockRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisProvider, this.log, this.promise), executionCounter);
                        }
                    } else {
                        this.promise.fail((Throwable)new Exception("ReleaseLockRedisCommand request failed", ex));
                    }
                }
            });
        });
    }
}

