/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delegate;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.monitoring.MonitoringHandler;

public class Delegate {
    private static final Logger LOG = LoggerFactory.getLogger(Delegate.class);
    private static final String HEADERS = "headers";
    private static final String PAYLOAD = "payload";
    private static final String URI = "uri";
    private static final String METHOD = "method";
    private static final int FIRST = 0;
    private static final int STATUS_CODE_2XX = 2;
    private final String name;
    private final HttpClient selfClient;
    private final MonitoringHandler monitoringHandler;
    private final Pattern pattern;
    private final Set<HttpMethod> methods;
    private final List<JsonObject> requests;

    public Delegate(MonitoringHandler monitoringHandler, HttpClient selfClient, String name, Pattern pattern, Set<HttpMethod> methods, List<JsonObject> requests) {
        this.monitoringHandler = monitoringHandler;
        this.selfClient = selfClient;
        this.name = name;
        this.pattern = pattern;
        this.methods = methods;
        this.requests = requests;
    }

    public String getName() {
        return this.name;
    }

    public void handle(HttpServerRequest request) {
        Matcher matcher;
        if (this.methods.contains(request.method()) && (matcher = this.pattern.matcher(request.uri())).matches()) {
            Handler<HttpClientResponse> handler = this.installDoneHandler(request);
            JsonObject firstRequest = this.requests.get(0);
            this.createRequest(request.uri(), firstRequest, handler);
            return;
        }
        request.response().end();
    }

    private void createRequest(String uri, JsonObject requestObject, Handler<HttpClientResponse> doneHandler) {
        String payloadStr;
        Matcher matcher = this.pattern.matcher(uri);
        String requestUri = matcher.replaceAll(requestObject.getString(URI));
        try {
            payloadStr = requestObject.getString(PAYLOAD);
        }
        catch (ClassCastException e) {
            payloadStr = requestObject.getJsonObject(PAYLOAD).encode();
        }
        if (payloadStr != null) {
            payloadStr = matcher.replaceAll(payloadStr);
        }
        CaseInsensitiveHeaders headers = new CaseInsensitiveHeaders();
        JsonArray headersArray = requestObject.getJsonArray(HEADERS);
        if (headersArray != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request headers:");
            }
            headersArray.forEach(arg_0 -> Delegate.lambda$createRequest$0((MultiMap)headers, arg_0));
        }
        HttpClientRequest delegateRequest = this.selfClient.request(HttpMethod.valueOf((String)requestObject.getString(METHOD)), requestUri, doneHandler);
        delegateRequest.headers().setAll((MultiMap)headers);
        delegateRequest.exceptionHandler(exception -> LOG.warn("Delegate request {} failed: {}", (Object)requestUri, (Object)exception.getMessage()));
        delegateRequest.setTimeout(120000L);
        if (payloadStr != null) {
            delegateRequest.end(Buffer.buffer((String)payloadStr));
        } else {
            delegateRequest.end();
        }
    }

    private Handler<HttpClientResponse> installDoneHandler(final HttpServerRequest request) {
        return new Handler<HttpClientResponse>(){
            private AtomicInteger currentIndex = new AtomicInteger(0);

            public void handle(HttpClientResponse response) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Done handler - handle");
                }
                if (response.statusCode() / 100 == 2) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Done handler - OK");
                    }
                    if (this.currentIndex.incrementAndGet() < Delegate.this.requests.size()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Done handler - calling next {}", (Object)this.currentIndex.get());
                        }
                        JsonObject delegateRequest = (JsonObject)Delegate.this.requests.get(this.currentIndex.get());
                        Delegate.this.createRequest(request.uri(), delegateRequest, (Handler<HttpClientResponse>)this);
                    } else {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Done handler - not 2XX, create response [{}]", (Object)response.statusCode());
                        }
                        Delegate.this.createResponse(request, response);
                    }
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Done handler - not 200/202, create response [{}]", (Object)response.statusCode());
                    }
                    Delegate.this.createResponse(request, response);
                }
            }
        };
    }

    private void createResponse(HttpServerRequest request, HttpClientResponse response) {
        request.response().setStatusCode(response.statusCode());
        request.response().setStatusMessage(response.statusMessage());
        request.response().setChunked(true);
        request.response().headers().addAll(response.headers());
        request.response().headers().remove("Content-Length");
        response.handler(data -> request.response().write(data));
        response.endHandler(v -> request.response().end());
    }

    private static /* synthetic */ void lambda$createRequest$0(MultiMap headers, Object header) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(" > Key [{}], Value [{}]", (Object)((JsonArray)header).getString(0), (Object)((JsonArray)header).getString(1));
        }
        headers.add(((JsonArray)header).getString(0), ((JsonArray)header).getString(1));
    }
}

