/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delegate;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.delegate.Delegate;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class DelegateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateFactory.class);
    private static final String REQUESTS = "requests";
    private static final String METHODS = "methods";
    private static final String PATTERN = "pattern";
    private final MonitoringHandler monitoringHandler;
    private final HttpClient selfClient;
    private final Map<String, Object> properties;
    private final String delegatesSchema;

    public DelegateFactory(MonitoringHandler monitoringHandler, HttpClient selfClient, Map<String, Object> properties, String delegatesSchema) {
        this.monitoringHandler = monitoringHandler;
        this.selfClient = selfClient;
        this.properties = properties;
        this.delegatesSchema = delegatesSchema;
    }

    public Delegate parseDelegate(String delegateName, Buffer buffer) throws ValidationException {
        String configString;
        try {
            configString = StringUtils.replaceWildcardConfigs((String)buffer.toString("UTF-8"), this.properties);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
        ValidationResult validationResult = Validator.validateStatic((Buffer)Buffer.buffer((String)configString), (String)this.delegatesSchema, (Logger)LOG);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        return this.createDelegate(delegateName, configString);
    }

    private Delegate createDelegate(String delegateName, String configString) throws ValidationException {
        Pattern pattern;
        JsonObject delegateObject = new JsonObject(configString);
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        delegateObject.getJsonArray(METHODS).forEach(method -> methods.add(HttpMethod.valueOf((String)((String)method))));
        try {
            pattern = Pattern.compile(delegateObject.getString(PATTERN));
        }
        catch (Exception e) {
            throw new ValidationException("Could not parse pattern [" + delegateObject.getString(PATTERN) + "] of  delegate " + delegateName, (Throwable)e);
        }
        ArrayList<JsonObject> requests = new ArrayList<JsonObject>();
        for (int i = 0; i < delegateObject.getJsonArray(REQUESTS).size(); ++i) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("request of [{}] #: {}", (Object)delegateName, (Object)i);
            }
            requests.add((JsonObject)delegateObject.getJsonArray(REQUESTS).getValue(i));
        }
        return new Delegate(this.monitoringHandler, this.selfClient, delegateName, pattern, methods, requests);
    }
}

