/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delegate;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;

public class DelegateClientRequestCreator {
    private final HttpClient selfClient;

    public DelegateClientRequestCreator(HttpClient selfClient) {
        this.selfClient = selfClient;
    }

    public HttpClientRequest createClientRequest(HttpMethod method, String requestURI, VertxHttpHeaders headers, long timeoutMs, Handler<HttpClientResponse> responseHandler, Handler<Throwable> exceptionHandler) {
        HttpClientRequest delegateRequest = this.selfClient.request(method, requestURI, responseHandler);
        delegateRequest.headers().setAll((MultiMap)headers);
        delegateRequest.exceptionHandler(exceptionHandler);
        delegateRequest.setTimeout(timeoutMs);
        return delegateRequest;
    }
}

