/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delegate;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HeaderFunction;
import org.swisspush.gateleen.core.http.HeaderFunctions;
import org.swisspush.gateleen.core.json.transform.JoltSpec;
import org.swisspush.gateleen.core.json.transform.JoltSpecBuilder;
import org.swisspush.gateleen.core.json.transform.JoltSpecException;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.delegate.Delegate;
import org.swisspush.gateleen.delegate.DelegateClientRequestCreator;
import org.swisspush.gateleen.delegate.DelegateRequest;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class DelegateFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DelegateFactory.class);
    private static final String REQUESTS = "requests";
    private static final String METHODS = "methods";
    private static final String PATTERN = "pattern";
    private static final String DYNAMIC_HEADERS = "dynamicHeaders";
    private static final String TRANSFORM = "transform";
    private static final String TRANSFORM_WITH_METADATA = "transformWithMetadata";
    private final DelegateClientRequestCreator clientRequestCreator;
    private final Map<String, Object> properties;
    private final String delegatesSchema;

    public DelegateFactory(DelegateClientRequestCreator clientRequestCreator, Map<String, Object> properties, String delegatesSchema) {
        this.clientRequestCreator = clientRequestCreator;
        this.properties = properties;
        this.delegatesSchema = delegatesSchema;
    }

    public Delegate parseDelegate(String delegateName, Buffer buffer) throws ValidationException {
        String configString;
        try {
            configString = StringUtils.replaceWildcardConfigs((String)buffer.toString("UTF-8"), this.properties);
        }
        catch (Exception e) {
            throw new ValidationException((Throwable)e);
        }
        ValidationResult validationResult = Validator.validateStatic((Buffer)Buffer.buffer((String)configString), (String)this.delegatesSchema, (Logger)LOG);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        return this.createDelegate(delegateName, configString);
    }

    private Delegate createDelegate(String delegateName, String configString) throws ValidationException {
        Pattern pattern;
        JsonObject delegateObject = new JsonObject(configString);
        HashSet<HttpMethod> methods = new HashSet<HttpMethod>();
        delegateObject.getJsonArray(METHODS).forEach(method -> methods.add(HttpMethod.valueOf((String)((String)method))));
        try {
            pattern = Pattern.compile(delegateObject.getString(PATTERN));
        }
        catch (Exception e) {
            throw new ValidationException("Could not parse pattern [" + delegateObject.getString(PATTERN) + "] of delegate " + delegateName, (Throwable)e);
        }
        ArrayList<DelegateRequest> requests = new ArrayList<DelegateRequest>();
        for (int i = 0; i < delegateObject.getJsonArray(REQUESTS).size(); ++i) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("request of [{}] #: {}", (Object)delegateName, (Object)i);
            }
            JsonObject requestJsonObject = (JsonObject)delegateObject.getJsonArray(REQUESTS).getValue(i);
            JoltSpec joltSpec = this.parsePayloadTransformSpec(requestJsonObject, delegateName);
            JsonArray headerFunctionsArray = requestJsonObject.getJsonArray(DYNAMIC_HEADERS);
            HeaderFunction headerFunction = headerFunctionsArray != null ? HeaderFunctions.parseFromJson((JsonArray)headerFunctionsArray) : HeaderFunctions.DO_NOTHING;
            requests.add(new DelegateRequest(requestJsonObject, joltSpec, headerFunction));
        }
        return new Delegate(this.clientRequestCreator, delegateName, pattern, methods, requests);
    }

    private JoltSpec parsePayloadTransformSpec(JsonObject requestJsonObject, String delegateName) throws ValidationException {
        JsonArray transformArray = requestJsonObject.getJsonArray(TRANSFORM);
        if (transformArray != null) {
            return this.buildTransformSpec(delegateName, transformArray, false);
        }
        JsonArray transformWithMetadataArray = requestJsonObject.getJsonArray(TRANSFORM_WITH_METADATA);
        if (transformWithMetadataArray != null) {
            return this.buildTransformSpec(delegateName, transformWithMetadataArray, true);
        }
        return null;
    }

    private JoltSpec buildTransformSpec(String delegateName, JsonArray transformSpecArray, boolean withMetadata) throws ValidationException {
        try {
            return JoltSpecBuilder.buildSpec((String)transformSpecArray.encode(), (boolean)withMetadata);
        }
        catch (JoltSpecException e) {
            String jsonOp = withMetadata ? TRANSFORM_WITH_METADATA : TRANSFORM;
            throw new ValidationException("Could not parse json " + jsonOp + " specification of delegate " + delegateName, (Throwable)e);
        }
    }
}

