/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delegate;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.ClientRequestCreator;
import org.swisspush.gateleen.core.http.HeaderFunctions;
import org.swisspush.gateleen.core.json.transform.JoltSpec;
import org.swisspush.gateleen.core.json.transform.JoltTransformer;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.delegate.DelegateRequest;
import org.swisspush.gateleen.delegate.TransformPayloadInputBuilder;

public class Delegate {
    private static final Logger LOG = LoggerFactory.getLogger(Delegate.class);
    private static final String HEADERS = "headers";
    private static final String PAYLOAD = "payload";
    private static final String URI = "uri";
    private static final String METHOD = "method";
    private static final int FIRST = 0;
    private static final int STATUS_CODE_2XX = 2;
    private final String name;
    private final ClientRequestCreator clientRequestCreator;
    private final Pattern pattern;
    private final Set<HttpMethod> methods;
    private final List<DelegateRequest> requests;
    private boolean delegateContainsJoltSpecRequest = false;

    public Delegate(ClientRequestCreator clientRequestCreator, String name, Pattern pattern, Set<HttpMethod> methods, List<DelegateRequest> requests) {
        this.clientRequestCreator = clientRequestCreator;
        this.name = name;
        this.pattern = pattern;
        this.methods = methods;
        this.requests = requests;
        this.delegateContainsJoltSpecRequest = this.doesDelegateContainJoltSpecRequest();
    }

    public String getName() {
        return this.name;
    }

    List<DelegateRequest> getDelegateRequests() {
        return this.requests;
    }

    public void handle(HttpServerRequest request) {
        Matcher matcher;
        if (this.methods.contains(request.method()) && (matcher = this.pattern.matcher(request.uri())).matches()) {
            this.extractDelegateExecutionRequestJsonPayload(request).setHandler(payload -> {
                if (payload.failed()) {
                    String message = "Unable to parse payload of delegate execution request. When a delegate definition with a 'transformation' spec is defined, a valid json payload is required!";
                    LOG.warn(message);
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                    request.response().end(message);
                    return;
                }
                DelegateRequest firstDelegateRequest = this.requests.get(0);
                Handler<HttpClientResponse> handler = this.installDoneHandler(request, (String)payload.result());
                this.createRequest(request, (String)payload.result(), firstDelegateRequest, handler);
            });
            return;
        }
        request.response().end();
    }

    private void createRequest(HttpServerRequest originalRequest, String delegateExecutionRequestJsonPayload, DelegateRequest requestContainer, Handler<HttpClientResponse> doneHandler) {
        Matcher matcher = this.pattern.matcher(originalRequest.uri());
        this.generatePayload(delegateExecutionRequestJsonPayload, originalRequest.headers(), requestContainer, matcher).setHandler(payloadBuffer -> {
            if (payloadBuffer.failed()) {
                String message = "Unable to generate delegate request payload. Cause: " + payloadBuffer.cause().getClass().getName();
                LOG.warn(message);
                originalRequest.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                originalRequest.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
                originalRequest.response().end(message);
                return;
            }
            JsonObject requestObject = requestContainer.getRequest();
            String requestUri = matcher.replaceAll(requestObject.getString(URI));
            VertxHttpHeaders headers = this.createRequestHeaders(requestContainer, originalRequest.headers());
            HttpClientRequest delegateRequest = this.clientRequestCreator.createClientRequest(HttpMethod.valueOf((String)requestObject.getString(METHOD)), requestUri, (MultiMap)headers, 120000L, doneHandler, exception -> LOG.warn("Delegate request {} failed: {}", (Object)requestUri, (Object)exception.getMessage()));
            Buffer buf = (Buffer)payloadBuffer.result();
            if (buf != null) {
                delegateRequest.putHeader(HttpHeaders.CONTENT_LENGTH, (CharSequence)String.valueOf(buf.length()));
                delegateRequest.end(buf);
            } else {
                delegateRequest.end();
            }
        });
    }

    private VertxHttpHeaders createRequestHeaders(DelegateRequest requestContainer, MultiMap originalRequestHeaders) {
        VertxHttpHeaders headers = new VertxHttpHeaders();
        JsonArray headersArray = requestContainer.getRequest().getJsonArray(HEADERS);
        if (headersArray != null) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("Request headers:");
            }
            headersArray.forEach(header -> {
                if (LOG.isTraceEnabled()) {
                    LOG.trace(" > Key [{}], Value [{}]", (Object)((JsonArray)header).getString(0), (Object)((JsonArray)header).getString(1));
                }
                headers.add(((JsonArray)header).getString(0), ((JsonArray)header).getString(1));
            });
            return headers;
        }
        if (requestContainer.getHeaderFunction() != HeaderFunctions.DO_NOTHING) {
            headers.addAll(originalRequestHeaders);
            HeaderFunctions.EvalScope evalScope = requestContainer.getHeaderFunction().apply((MultiMap)headers);
            if (evalScope.getErrorMessage() != null) {
                LOG.warn("problem applying header manipulator chain {} in delegate {}", (Object)evalScope.getErrorMessage(), (Object)this.getName());
            }
        }
        return headers;
    }

    private Future<String> extractDelegateExecutionRequestJsonPayload(HttpServerRequest request) {
        Future future = Future.future();
        if (this.delegateContainsJoltSpecRequest) {
            request.bodyHandler(bodyHandler -> {
                try {
                    future.complete((Object)bodyHandler.toJsonObject().encode());
                }
                catch (Exception ex) {
                    future.fail((Throwable)ex);
                }
            });
        } else {
            future.complete(null);
        }
        return future;
    }

    private Future<Buffer> generatePayload(String delegateExecutionRequestJsonPayload, MultiMap headers, DelegateRequest requestContainer, Matcher matcher) {
        Future future;
        block9: {
            future = Future.future();
            if (requestContainer.getJoltSpec() != null) {
                try {
                    if (delegateExecutionRequestJsonPayload != null) {
                        String transformInput = TransformPayloadInputBuilder.build(requestContainer.getJoltSpec(), delegateExecutionRequestJsonPayload, headers, matcher);
                        LOG.debug("Jolt transformation input: {}", (Object)transformInput);
                        JoltTransformer.transform((String)transformInput, (JoltSpec)requestContainer.getJoltSpec()).setHandler(transformed -> {
                            if (transformed.failed()) {
                                future.fail(transformed.cause());
                            } else {
                                JsonObject transformedJsonObject = (JsonObject)transformed.result();
                                try {
                                    String transformedOutput = transformedJsonObject.encode();
                                    LOG.debug("Jolt transformation output: {}", (Object)transformedOutput);
                                    future.complete((Object)Buffer.buffer((String)transformedOutput));
                                }
                                catch (Exception ex) {
                                    future.fail((Throwable)ex);
                                }
                            }
                        });
                        break block9;
                    }
                    future.fail("nothing to transform");
                }
                catch (Exception ex) {
                    future.fail((Throwable)ex);
                }
            } else {
                String payloadStr;
                JsonObject requestObject = requestContainer.getRequest();
                try {
                    payloadStr = requestObject.getString(PAYLOAD);
                }
                catch (ClassCastException e) {
                    payloadStr = requestObject.getJsonObject(PAYLOAD).encode();
                }
                if (payloadStr != null) {
                    payloadStr = matcher.replaceAll(payloadStr);
                    future.complete((Object)Buffer.buffer((String)payloadStr));
                } else {
                    future.complete(null);
                }
            }
        }
        return future;
    }

    private Handler<HttpClientResponse> installDoneHandler(final HttpServerRequest request, final String delegateExecutionRequestJsonPayload) {
        return new Handler<HttpClientResponse>(){
            private AtomicInteger currentIndex = new AtomicInteger(0);

            public void handle(HttpClientResponse response) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Done handler - handle");
                }
                if (response.statusCode() / 100 == 2) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Done handler - OK");
                    }
                    if (this.currentIndex.incrementAndGet() < Delegate.this.requests.size()) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Done handler - calling next {}", (Object)this.currentIndex.get());
                        }
                        DelegateRequest delegateRequest = Delegate.this.requests.get(this.currentIndex.get());
                        Delegate.this.createRequest(request, delegateExecutionRequestJsonPayload, delegateRequest, this);
                    } else {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("Done handler - not 2XX, create response [{}]", (Object)response.statusCode());
                        }
                        Delegate.this.createResponse(request, response);
                    }
                } else {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("Done handler - not 200/202, create response [{}]", (Object)response.statusCode());
                    }
                    Delegate.this.createResponse(request, response);
                }
            }
        };
    }

    private void createResponse(HttpServerRequest request, HttpClientResponse response) {
        HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)response);
        response.handler(data -> request.response().write(data));
        response.endHandler(v -> request.response().end());
    }

    private boolean doesDelegateContainJoltSpecRequest() {
        if (this.requests == null || this.requests.isEmpty()) {
            return false;
        }
        for (DelegateRequest request : this.requests) {
            if (request.getJoltSpec() == null) continue;
            return true;
        }
        return false;
    }
}

