/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delegate;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.refresh.Refreshable;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.delegate.Delegate;
import org.swisspush.gateleen.delegate.DelegateClientRequestCreator;
import org.swisspush.gateleen.delegate.DelegateFactory;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.validation.ValidationException;

public class DelegateHandler
implements Refreshable,
LoggableResource {
    private static final String DEFINITION_RESOURCE = "definition";
    private static final String EXECUTION_RESOURCE = "execution";
    private static final String SAVE_DELEGATE_ADDRESS = "gateleen.delegate-insert";
    private static final String REMOVE_DELEGATE_ADDRESS = "gateleen.delegate-remove";
    private static final Logger LOG = LoggerFactory.getLogger(DelegateHandler.class);
    private static final int NAME_GROUP_INDEX = 1;
    private static final int MESSAGE_NAME = 0;
    private static final int MESSAGE_URL = 1;
    private final Vertx vertx;
    private final ResourceStorage delegateStorage;
    private final String delegatesUri;
    private final DelegateFactory delegateFactory;
    private final Pattern delegateNamePattern;
    private final Map<String, Delegate> delegateMap;
    private final Handler<Void> doneHandler;
    private boolean initialized;
    private boolean logDelegateChanges = false;

    public DelegateHandler(Vertx vertx, HttpClient selfClient, ResourceStorage delegateStorage, MonitoringHandler monitoringHandler, String delegatesUri, Map<String, Object> properties, Handler<Void> doneHandler) {
        this.vertx = vertx;
        this.delegateStorage = delegateStorage;
        this.delegatesUri = delegatesUri;
        this.doneHandler = doneHandler;
        String delegatesSchema = ResourcesUtils.loadResource((String)"gateleen_delegate_schema_delegates", (boolean)true);
        this.delegateFactory = new DelegateFactory(new DelegateClientRequestCreator(selfClient), properties, delegatesSchema);
        this.delegateNamePattern = Pattern.compile(delegatesUri + "([^/]+)(/definition|/execution.*|/?)");
        this.delegateMap = new HashMap<String, Delegate>();
        this.initialized = false;
    }

    public void init() {
        if (!this.initialized) {
            final ArrayList<Consumer<Handler>> initMethods = new ArrayList<Consumer<Handler>>();
            initMethods.add(this::registerDelegateRegistrationHandler);
            initMethods.add(this::loadStoredDelegates);
            Handler<Void> readyHandler = new Handler<Void>(){
                private AtomicInteger readyCounter;
                {
                    this.readyCounter = new AtomicInteger(initMethods.size());
                }

                public void handle(Void aVoid) {
                    if (this.readyCounter.decrementAndGet() == 0) {
                        DelegateHandler.this.initialized = true;
                        LOG.info("DelegateHandler is ready!");
                        if (DelegateHandler.this.doneHandler != null) {
                            DelegateHandler.this.doneHandler.handle(null);
                        }
                    }
                }
            };
            initMethods.forEach(arg_0 -> DelegateHandler.lambda$init$0((Handler)readyHandler, arg_0));
        }
    }

    private void loadStoredDelegates(Handler<Void> readyHandler) {
        this.delegateStorage.get(this.delegatesUri, buffer -> {
            this.delegateMap.clear();
            if (buffer != null) {
                JsonObject listOfDelegates = new JsonObject(buffer.toString());
                JsonArray delegateNames = listOfDelegates.getJsonArray("delegates");
                Iterator keys = delegateNames.getList().iterator();
                AtomicInteger storedDelegateCount = new AtomicInteger(delegateNames.getList().size());
                while (keys.hasNext()) {
                    String key = ((String)keys.next()).replace("/", "");
                    this.delegateStorage.get(this.delegatesUri + key + "/definition", delegateBody -> {
                        if (delegateBody != null) {
                            LOG.info("Loading delegate: {}", (Object)key);
                            this.registerDelegate((Buffer)delegateBody, key);
                        } else {
                            LOG.warn("Could not get URL '{}/definition'.", (Object)(this.delegatesUri + key));
                        }
                        if (storedDelegateCount.decrementAndGet() == 0 && readyHandler != null) {
                            readyHandler.handle(null);
                        }
                    });
                }
            } else {
                LOG.debug("No delegates previously stored");
                if (readyHandler != null) {
                    readyHandler.handle(null);
                }
            }
        });
    }

    private void registerDelegateRegistrationHandler(Handler<Void> readyHandler) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("registerDelegateRegistrationHandler");
        }
        this.vertx.eventBus().consumer(SAVE_DELEGATE_ADDRESS, delegateEvent -> {
            String[] messages = ((String)delegateEvent.body()).split(";");
            if (messages != null) {
                this.delegateStorage.get(messages[1], buffer -> {
                    if (buffer != null) {
                        this.registerDelegate((Buffer)buffer, messages[0]);
                    } else {
                        LOG.warn("Could not get URL '{}' (getting delegate).", (Object)messages[1]);
                    }
                });
            } else {
                LOG.warn("Could not get Delegate, empty delegateEvent.");
            }
        });
        this.vertx.eventBus().consumer(REMOVE_DELEGATE_ADDRESS, delegateName -> this.unregisterDelegate((String)delegateName.body()));
        readyHandler.handle(null);
    }

    private void unregisterDelegate(String delegateName) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("unregisterDelegate: {}", (Object)delegateName);
        }
        this.delegateMap.remove(delegateName);
    }

    private void registerDelegate(Buffer buffer, String delegateName) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("registerDelegate: {}", (Object)delegateName);
        }
        try {
            Delegate delegate = this.delegateFactory.parseDelegate(delegateName, buffer);
            this.delegateMap.put(delegateName, delegate);
        }
        catch (ValidationException validationException) {
            LOG.error("Could not parse delegate: {}", (Object)validationException.toString());
        }
    }

    private void handleDelegateRegistration(HttpServerRequest request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("handleDelegateRegistration: {}", (Object)request.uri());
        }
        request.bodyHandler(buffer -> {
            String delegateName = this.getDelegateName(request.uri());
            try {
                this.delegateFactory.parseDelegate(delegateName, (Buffer)buffer);
            }
            catch (ValidationException validationException) {
                LOG.warn("Could not parse delegate {}: {}", (Object)delegateName, (Object)validationException.toString());
                request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + validationException.getMessage());
                if (validationException.getValidationDetails() != null) {
                    request.response().headers().add("Content-Type", "application/json");
                    request.response().end(validationException.getValidationDetails().encode());
                } else {
                    request.response().end(validationException.getMessage());
                }
                return;
            }
            this.delegateStorage.put(request.uri(), request.headers(), buffer, status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    if (this.logDelegateChanges) {
                        RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                    }
                    this.vertx.eventBus().publish(SAVE_DELEGATE_ADDRESS, (Object)(delegateName + ";" + request.uri()));
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        });
    }

    private void handleDelegateUnregistration(HttpServerRequest request) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("handleDelegateUnregistration: {}", (Object)request.uri());
        }
        String delegateName = this.getDelegateName(request.uri());
        this.delegateStorage.delete(this.delegatesUri + delegateName, status -> {
            this.vertx.eventBus().publish(REMOVE_DELEGATE_ADDRESS, (Object)delegateName);
            request.response().end();
        });
    }

    protected String getDelegateName(String uri) {
        Matcher nameMatcher = this.delegateNamePattern.matcher(uri);
        if (nameMatcher.matches()) {
            return nameMatcher.group(1);
        }
        return null;
    }

    public boolean handle(HttpServerRequest request) {
        String delegateName = this.getDelegateName(request.uri());
        if (delegateName != null) {
            if (request.method() == HttpMethod.PUT && request.uri().endsWith(DEFINITION_RESOURCE)) {
                LOG.debug("registering delegate={}", (Object)delegateName);
                this.handleDelegateRegistration(request);
                return true;
            }
            if (this.delegateMap.containsKey(delegateName)) {
                if (request.uri().contains(EXECUTION_RESOURCE)) {
                    LOG.debug("executing delegate={}", (Object)delegateName);
                    this.handleDelegateExecution(request);
                    return true;
                }
                if (request.method() == HttpMethod.DELETE) {
                    LOG.debug("unregister delegate={}", (Object)delegateName);
                    this.handleDelegateUnregistration(request);
                    return true;
                }
            } else {
                LOG.warn("No delegate with the name [{}] registered. DelegateHandler will not process the given request!", (Object)delegateName);
            }
        }
        return false;
    }

    private void handleDelegateExecution(HttpServerRequest request) {
        String delegateName = this.getDelegateName(request.uri());
        Delegate delegate = this.delegateMap.get(delegateName);
        delegate.handle(request);
    }

    public void refresh() {
        this.loadStoredDelegates(null);
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logDelegateChanges = resourceLoggingEnabled;
    }

    private static /* synthetic */ void lambda$init$0(Handler readyHandler, Consumer handlerConsumer) {
        handlerConsumer.accept(readyHandler);
    }
}

