/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delegate;

import com.google.common.base.Joiner;
import io.vertx.core.MultiMap;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.swisspush.gateleen.core.json.transform.JoltSpec;

class TransformPayloadInputBuilder {
    private static final String HEADERS = "headers";
    private static final String PAYLOAD = "payload";
    private static final String URL_PARTS = "urlParts";

    TransformPayloadInputBuilder() {
    }

    public static String build(JoltSpec joltSpec, String delegateExecutionRequestJsonPayload, MultiMap headers, Matcher matcher) {
        if (joltSpec.isWithMetadata()) {
            JsonObject withMetadata = new JsonObject();
            withMetadata.put(URL_PARTS, TransformPayloadInputBuilder.buildUrlParts(matcher));
            withMetadata.put(HEADERS, TransformPayloadInputBuilder.buildHeaders(headers));
            withMetadata.put(PAYLOAD, new JsonObject(delegateExecutionRequestJsonPayload));
            return withMetadata.encode();
        }
        return delegateExecutionRequestJsonPayload;
    }

    private static JsonArray buildUrlParts(Matcher matcher) {
        int groupCount = matcher.groupCount();
        JsonArray arr = new JsonArray();
        for (int i = 0; i <= groupCount; ++i) {
            arr.add("$" + i);
        }
        String encoded = matcher.replaceAll(arr.encode());
        return new JsonArray(encoded);
    }

    private static JsonObject buildHeaders(MultiMap headers) {
        JsonObject headerObject = new JsonObject();
        for (Map.Entry header : headers) {
            List all = headers.getAll((String)header.getKey());
            headerObject.put((String)header.getKey(), Joiner.on((String)",").join((Iterable)all));
        }
        return headerObject;
    }
}

