/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delta;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.routing.Router;

public class DeltaHandler {
    private static final String DELTA_PARAM = "delta";
    private static final String DELTA_HEADER = "x-delta";
    private static final String IF_NONE_MATCH_HEADER = "if-none-match";
    private static final String DELTA_BACKEND_HEADER = "x-delta-backend";
    private static final String EXPIRE_AFTER_HEADER = "X-Expire-After";
    private static final long DEFAULT_EXPIRE = 1728000L;
    private static final String SLASH = "/";
    private static final int TIMEOUT = 120000;
    private static final String SEQUENCE_KEY = "delta:sequence";
    private static final String RESOURCE_KEY_PREFIX = "delta:resources";
    private static final String ETAG_KEY_PREFIX = "delta:etags";
    private HttpClient httpClient;
    private RedisClient redisClient;

    public DeltaHandler(RedisClient redisClient, HttpClient httpClient) {
        this.redisClient = redisClient;
        this.httpClient = httpClient;
    }

    public boolean isDeltaRequest(HttpServerRequest request) {
        return this.isDeltaGETRequest(request) || this.isDeltaPUTRequest(request);
    }

    private boolean isDeltaPUTRequest(HttpServerRequest request) {
        if (HttpMethod.PUT == request.method() && request.headers().contains(DELTA_HEADER)) {
            return "auto".equalsIgnoreCase(request.headers().get(DELTA_HEADER));
        }
        return false;
    }

    private boolean isDeltaGETRequest(HttpServerRequest request) {
        if (HttpMethod.GET == request.method() && request.params().contains(DELTA_PARAM) && !request.headers().contains(DELTA_BACKEND_HEADER)) {
            return true;
        }
        if (request.headers().contains(DELTA_BACKEND_HEADER)) {
            request.headers().remove(DELTA_BACKEND_HEADER);
        }
        return false;
    }

    public void handle(HttpServerRequest request, Router router) {
        String updateId;
        Logger log = RequestLoggerFactory.getLogger(DeltaHandler.class, (HttpServerRequest)request);
        if (this.isDeltaPUTRequest(request)) {
            this.handleResourcePUT(request, router, log);
        }
        if (this.isDeltaGETRequest(request) && (updateId = this.extractStringDeltaParameter(request, log)) != null) {
            this.handleCollectionGET(request, updateId, log);
        }
    }

    private void handleResourcePUT(HttpServerRequest request, Router router, Logger log) {
        request.pause();
        this.handleDeltaEtag(request, log, (Handler<Boolean>)((Handler)updateDelta -> {
            if (updateDelta.booleanValue()) {
                this.redisClient.incr(SEQUENCE_KEY, reply -> {
                    if (reply.failed()) {
                        log.error("incr command for redisKey delta:sequence failed with cause: " + this.logCause((AsyncResult)reply));
                        this.handleError(request, "error incrementing/accessing sequence for update-id");
                        return;
                    }
                    String resourceKey = this.getResourceKey(request.path(), false);
                    long expireAfter = this.getExpireAfterValue(request, log);
                    long updateId = (Long)reply.result();
                    this.redisClient.setex(resourceKey, expireAfter, String.valueOf(updateId), event -> {
                        if (event.failed()) {
                            log.error("setex command for redisKey " + resourceKey + " failed with cause: " + this.logCause((AsyncResult)event));
                            this.handleError(request, "error saving delta information");
                            request.resume();
                        } else {
                            request.resume();
                            router.route(request);
                        }
                    });
                });
            } else {
                log.debug("skip updating delta, resume request");
                request.resume();
                router.route(request);
            }
        }));
    }

    private void handleDeltaEtag(HttpServerRequest request, Logger log, Handler<Boolean> callback) {
        if (!request.headers().contains(IF_NONE_MATCH_HEADER)) {
            callback.handle((Object)Boolean.TRUE);
            return;
        }
        String requestEtag = request.headers().get(IF_NONE_MATCH_HEADER);
        String etagResourceKey = this.getResourceKey(request.path(), true);
        this.redisClient.get(etagResourceKey, event -> {
            if (event.failed()) {
                log.error("get command for redisKey " + etagResourceKey + " failed with cause: " + this.logCause((AsyncResult)event));
                callback.handle((Object)Boolean.TRUE);
                return;
            }
            String etagFromStorage = (String)event.result();
            if (StringUtils.isEmpty((CharSequence)etagFromStorage)) {
                this.saveOrUpdateDeltaEtag(etagResourceKey, request, log, (Handler<Boolean>)((Handler)aBoolean -> callback.handle((Object)Boolean.TRUE)));
            } else if (etagFromStorage.equals(requestEtag)) {
                callback.handle((Object)Boolean.FALSE);
            } else {
                this.saveOrUpdateDeltaEtag(etagResourceKey, request, log, (Handler<Boolean>)((Handler)aBoolean -> callback.handle((Object)Boolean.TRUE)));
            }
        });
    }

    private void saveOrUpdateDeltaEtag(String etagResourceKey, HttpServerRequest request, Logger log, Handler<Boolean> updateCallback) {
        String requestEtag = request.headers().get(IF_NONE_MATCH_HEADER);
        long expireAfter = this.getExpireAfterValue(request, log);
        this.redisClient.setex(etagResourceKey, expireAfter, requestEtag, event -> {
            if (event.failed()) {
                log.error("setex command for redisKey " + etagResourceKey + " failed with cause: " + this.logCause((AsyncResult)event));
            }
            updateCallback.handle((Object)Boolean.TRUE);
        });
    }

    private String extractStringDeltaParameter(HttpServerRequest request, Logger log) {
        String updateIdValue = request.params().get(DELTA_PARAM);
        if (updateIdValue == null) {
            this.respondInvalidDeltaParameter(updateIdValue, request, log);
            return null;
        }
        return updateIdValue;
    }

    private Integer extractNumberDeltaParameter(String deltaStringId, HttpServerRequest request, Logger log) {
        Object updateIdValue = null;
        try {
            return Integer.parseInt(deltaStringId);
        }
        catch (Exception exception) {
            this.respondInvalidDeltaParameter(deltaStringId, request, log);
            return null;
        }
    }

    private void respondInvalidDeltaParameter(String deltaStringId, HttpServerRequest request, Logger log) {
        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage("Invalid delta parameter");
        request.response().end(request.response().getStatusMessage());
        log.error("Bad Request: " + request.response().getStatusMessage() + " '" + deltaStringId + "'");
    }

    private DeltaResourcesContainer getDeltaResourceNames(List<String> subResourceNames, JsonArray storageUpdateIds, int updateId) {
        ArrayList<String> deltaResourceNames = new ArrayList<String>();
        int maxUpdateId = 0;
        for (int i = 0; i < storageUpdateIds.size(); ++i) {
            try {
                Integer storedUpdateId = Integer.parseInt(storageUpdateIds.getString(i));
                if (storedUpdateId > updateId) {
                    deltaResourceNames.add(subResourceNames.get(i));
                }
                if (storedUpdateId <= maxUpdateId) continue;
                maxUpdateId = storedUpdateId;
                continue;
            }
            catch (NumberFormatException ex) {
                deltaResourceNames.add(subResourceNames.get(i));
            }
        }
        return new DeltaResourcesContainer(maxUpdateId, deltaResourceNames);
    }

    private void handleCollectionGET(HttpServerRequest request, String updateId, Logger log) {
        request.pause();
        String targetUri = ExpansionDeltaUtil.constructRequestUri((String)request.path(), (MultiMap)request.params(), null, null, (ExpansionDeltaUtil.SlashHandling)ExpansionDeltaUtil.SlashHandling.KEEP);
        log.debug("constructed uri for request: " + targetUri);
        HttpClientRequest cReq = this.httpClient.request(HttpMethod.GET, targetUri, cRes -> {
            request.response().setStatusCode(cRes.statusCode());
            request.response().setStatusMessage(cRes.statusMessage());
            request.response().headers().addAll(cRes.headers());
            request.response().headers().remove("Content-Length");
            request.response().setChunked(true);
            if (cRes.headers().contains(DELTA_HEADER)) {
                cRes.handler(data -> request.response().write(data));
                cRes.endHandler(v -> request.response().end());
            } else {
                cRes.bodyHandler(data -> {
                    try {
                        Set originalParams = null;
                        if (request.params() != null) {
                            originalParams = request.params().names();
                        }
                        ExpansionDeltaUtil.CollectionResourceContainer dataContainer = ExpansionDeltaUtil.verifyCollectionResponse((HttpServerRequest)request, (Buffer)data, (Set)originalParams);
                        List subResourceNames = dataContainer.getResourceNames();
                        List<String> deltaResourceKeys = this.buildDeltaResourceKeys(request.path(), subResourceNames);
                        int updateIdNumber = this.extractNumberDeltaParameter(updateId, request, log);
                        if (log.isTraceEnabled()) {
                            log.trace("DeltaHandler: deltaResourceKeys for targetUri (" + targetUri + "): " + deltaResourceKeys.toString());
                        }
                        if (deltaResourceKeys.size() > 0) {
                            if (log.isTraceEnabled()) {
                                log.trace("DeltaHandler: targetUri (" + targetUri + ") using mget command.");
                            }
                            this.redisClient.mgetMany(deltaResourceKeys, event -> {
                                if (event.failed()) {
                                    log.error("mget command failed with cuase: " + this.logCause((AsyncResult)event));
                                    this.handleError(request, "error reading delta information");
                                    return;
                                }
                                JsonArray mgetValues = (JsonArray)event.result();
                                DeltaResourcesContainer deltaResourcesContainer = this.getDeltaResourceNames(subResourceNames, mgetValues, updateIdNumber);
                                JsonObject result = this.buildResultJsonObject(deltaResourcesContainer.getResourceNames(), dataContainer.getCollectionName());
                                request.response().putHeader(DELTA_HEADER, "" + deltaResourcesContainer.getMaxUpdateId());
                                request.response().end(result.toString());
                            });
                        } else {
                            if (log.isTraceEnabled()) {
                                log.trace("DeltaHandler: targetUri (" + targetUri + ") NOT using database");
                            }
                            request.response().putHeader(DELTA_HEADER, "" + updateIdNumber);
                            request.response().end(data);
                        }
                    }
                    catch (ResourceCollectionException exception) {
                        request.response().setStatusCode(exception.getStatusCode().getStatusCode());
                        request.response().setStatusMessage(exception.getStatusCode().getStatusMessage());
                        request.response().end(exception.getMessage());
                    }
                });
            }
            cRes.exceptionHandler(ExpansionDeltaUtil.createResponseExceptionHandler((HttpServerRequest)request, (String)targetUri, DeltaHandler.class));
        });
        cReq.setTimeout(120000L);
        cReq.headers().setAll(request.headers());
        cReq.headers().set(DELTA_BACKEND_HEADER, "");
        cReq.headers().set("Accept", "application/json");
        cReq.setChunked(true);
        request.handler(arg_0 -> ((HttpClientRequest)cReq).write(arg_0));
        request.endHandler(v -> {
            cReq.end();
            log.debug("Request done. Request : " + cReq);
        });
        cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)targetUri, DeltaHandler.class));
        request.resume();
    }

    private List<String> buildDeltaResourceKeys(String requestPath, List<String> subResourceNames) {
        ArrayList<String> storageResourceKeys = new ArrayList<String>();
        String resourceKeyPrefix = this.getResourceKey(requestPath, false);
        for (String entry : subResourceNames) {
            storageResourceKeys.add(resourceKeyPrefix + ":" + entry);
        }
        return storageResourceKeys;
    }

    private JsonObject buildResultJsonObject(List<String> subResourceNames, String collectionName) {
        JsonArray arr = new JsonArray();
        subResourceNames.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
        JsonObject result = new JsonObject();
        result.put(collectionName, arr);
        return result;
    }

    private void handleError(HttpServerRequest request, String errorMessage) {
        request.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        request.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
        request.response().end(errorMessage);
    }

    private String getResourceKey(String path, boolean useEtagPrefix) {
        ArrayList pathSegments = Lists.newArrayList((Iterable)Splitter.on((String)SLASH).omitEmptyStrings().split((CharSequence)path));
        if (useEtagPrefix) {
            pathSegments.add(0, ETAG_KEY_PREFIX);
        } else {
            pathSegments.add(0, RESOURCE_KEY_PREFIX);
        }
        return Joiner.on((String)":").skipNulls().join((Iterable)pathSegments);
    }

    private long getExpireAfterValue(HttpServerRequest request, Logger log) {
        long value = 1728000L;
        MultiMap requestHeaders = request.headers();
        String expireAfterHeaderValue = requestHeaders.get(EXPIRE_AFTER_HEADER);
        if (expireAfterHeaderValue == null) {
            log.debug("Setting Expire-After value to a default of 1728000 seconds since header X-Expire-After not defined");
            return value;
        }
        try {
            value = Long.parseLong(expireAfterHeaderValue);
            if (value < 0L) {
                log.warn("Setting Expire-After value to a default of 1728000, since defined value for header X-Expire-After is a negative number: " + expireAfterHeaderValue);
                value = 1728000L;
            } else {
                log.debug("Setting Expire-After value to " + value + " seconds as defined in header " + EXPIRE_AFTER_HEADER);
            }
        }
        catch (Exception e) {
            log.warn("Setting Expire-After value to a default of 1728000, since defined value for header X-Expire-After is not a number: " + expireAfterHeaderValue);
        }
        return value;
    }

    private String logCause(AsyncResult result) {
        if (result.cause() != null) {
            return result.cause().getMessage();
        }
        return null;
    }

    private class DeltaResourcesContainer {
        private final int maxUpdateId;
        private final List<String> resourceNames;

        public DeltaResourcesContainer(int maxUpdateId, List<String> resourceNames) {
            this.maxUpdateId = maxUpdateId;
            this.resourceNames = resourceNames;
        }

        public int getMaxUpdateId() {
            return this.maxUpdateId;
        }

        public List<String> getResourceNames() {
            return this.resourceNames;
        }
    }
}

