/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delta;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.RedisClient;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.routing.Router;

public class DeltaHandler {
    private static final String DELTA_PARAM = "delta";
    private static final String LIMIT_PARAM = "limit";
    private static final String OFFSET_PARAM = "offset";
    private static final String DELTA_HEADER = "x-delta";
    private static final String IF_NONE_MATCH_HEADER = "if-none-match";
    private static final String DELTA_BACKEND_HEADER = "x-delta-backend";
    private static final String EXPIRE_AFTER_HEADER = "X-Expire-After";
    private static final String SLASH = "/";
    private static final int TIMEOUT = 120000;
    private static final String SEQUENCE_KEY = "delta:sequence";
    private static final String RESOURCE_KEY_PREFIX = "delta:resources";
    private static final String ETAG_KEY_PREFIX = "delta:etags";
    private HttpClient httpClient;
    private RedisClient redisClient;
    private boolean rejectLimitOffsetRequests;

    public DeltaHandler(RedisClient redisClient, HttpClient httpClient) {
        this(redisClient, httpClient, false);
    }

    public DeltaHandler(RedisClient redisClient, HttpClient httpClient, boolean rejectLimitOffsetRequests) {
        this.redisClient = redisClient;
        this.httpClient = httpClient;
        this.rejectLimitOffsetRequests = rejectLimitOffsetRequests;
    }

    public boolean isDeltaRequest(HttpServerRequest request) {
        return this.isDeltaGETRequest(request) || this.isDeltaPUTRequest(request);
    }

    private boolean isDeltaPUTRequest(HttpServerRequest request) {
        if (HttpMethod.PUT == request.method() && request.headers().contains(DELTA_HEADER)) {
            return "auto".equalsIgnoreCase(request.headers().get(DELTA_HEADER));
        }
        return false;
    }

    private boolean isDeltaGETRequest(HttpServerRequest request) {
        if (HttpMethod.GET == request.method() && request.params().contains(DELTA_PARAM) && !request.headers().contains(DELTA_BACKEND_HEADER)) {
            return true;
        }
        if (request.headers().contains(DELTA_BACKEND_HEADER)) {
            request.headers().remove(DELTA_BACKEND_HEADER);
        }
        return false;
    }

    public void handle(HttpServerRequest request, Router router) {
        String updateId;
        Logger log = RequestLoggerFactory.getLogger(DeltaHandler.class, (HttpServerRequest)request);
        if (this.isDeltaPUTRequest(request)) {
            this.handleResourcePUT(request, router, log);
        }
        if (this.isDeltaGETRequest(request) && (updateId = this.extractStringDeltaParameter(request, log)) != null) {
            if (this.rejectLimitOffsetRequests(request)) {
                this.respondLimitOffsetParameterForbidden(request, log);
            } else {
                this.handleCollectionGET(request, updateId, log);
            }
        }
    }

    private void handleResourcePUT(HttpServerRequest request, Router router, Logger log) {
        request.pause();
        this.handleDeltaEtag(request, log, (Handler<Boolean>)((Handler)updateDelta -> {
            if (updateDelta.booleanValue()) {
                this.redisClient.incr(SEQUENCE_KEY, reply -> {
                    if (reply.failed()) {
                        log.error("incr command for redisKey {} failed with cause: {}", (Object)SEQUENCE_KEY, (Object)this.logCause((AsyncResult)reply));
                        this.handleError(request, "error incrementing/accessing sequence for update-id");
                        return;
                    }
                    String resourceKey = this.getResourceKey(request.path(), false);
                    Long expireAfter = this.getExpireAfterValue(request, log);
                    String updateId = ((Long)reply.result()).toString();
                    this.saveDelta(resourceKey, updateId, expireAfter, (Handler<AsyncResult<Object>>)((Handler)event -> {
                        if (event.failed()) {
                            log.error("setex command for redisKey {} failed with cause: {}", (Object)resourceKey, (Object)this.logCause((AsyncResult)event));
                            this.handleError(request, "error saving delta information");
                            request.resume();
                        } else {
                            request.resume();
                            router.route(request);
                        }
                    }));
                });
            } else {
                log.debug("skip updating delta, resume request");
                request.resume();
                router.route(request);
            }
        }));
    }

    private void handleDeltaEtag(HttpServerRequest request, Logger log, Handler<Boolean> callback) {
        if (!request.headers().contains(IF_NONE_MATCH_HEADER)) {
            callback.handle((Object)Boolean.TRUE);
            return;
        }
        String requestEtag = request.headers().get(IF_NONE_MATCH_HEADER);
        String etagResourceKey = this.getResourceKey(request.path(), true);
        this.redisClient.get(etagResourceKey, event -> {
            if (event.failed()) {
                log.error("get command for redisKey {} failed with cause: {}", (Object)etagResourceKey, (Object)this.logCause((AsyncResult)event));
                callback.handle((Object)Boolean.TRUE);
                return;
            }
            String etagFromStorage = (String)event.result();
            if (StringUtils.isEmpty((CharSequence)etagFromStorage)) {
                this.saveOrUpdateDeltaEtag(etagResourceKey, request, log, (Handler<Boolean>)((Handler)aBoolean -> callback.handle((Object)Boolean.TRUE)));
            } else if (etagFromStorage.equals(requestEtag)) {
                callback.handle((Object)Boolean.FALSE);
            } else {
                this.saveOrUpdateDeltaEtag(etagResourceKey, request, log, (Handler<Boolean>)((Handler)aBoolean -> callback.handle((Object)Boolean.TRUE)));
            }
        });
    }

    private void saveOrUpdateDeltaEtag(String etagResourceKey, HttpServerRequest request, Logger log, Handler<Boolean> updateCallback) {
        String requestEtag = request.headers().get(IF_NONE_MATCH_HEADER);
        Long expireAfter = this.getExpireAfterValue(request, log);
        this.saveDelta(etagResourceKey, requestEtag, expireAfter, (Handler<AsyncResult<Object>>)((Handler)event -> {
            if (event.failed()) {
                log.error("setex command for redisKey {} failed with cause: {}", (Object)etagResourceKey, (Object)this.logCause((AsyncResult)event));
            }
            updateCallback.handle((Object)Boolean.TRUE);
        }));
    }

    private void saveDelta(String deltaKey, String deltaValue, Long expireAfter, Handler<AsyncResult<Object>> handler) {
        if (expireAfter == null) {
            this.redisClient.set(deltaKey, deltaValue, handler);
        } else {
            this.redisClient.setex(deltaKey, expireAfter.longValue(), deltaValue, handler);
        }
    }

    private String extractStringDeltaParameter(HttpServerRequest request, Logger log) {
        String updateIdValue = request.params().get(DELTA_PARAM);
        if (updateIdValue == null) {
            this.respondInvalidDeltaParameter(updateIdValue, request, log);
            return null;
        }
        return updateIdValue;
    }

    private Long extractNumberDeltaParameter(String deltaStringId, HttpServerRequest request, Logger log) {
        try {
            return Long.parseLong(deltaStringId);
        }
        catch (Exception exception) {
            this.respondInvalidDeltaParameter(deltaStringId, request, log);
            return null;
        }
    }

    private void respondLimitOffsetParameterForbidden(HttpServerRequest request, Logger log) {
        String errorMsg = "limit/offset parameter not allowed for delta requests";
        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
        request.response().end(errorMsg);
        log.warn(errorMsg);
    }

    private void respondInvalidDeltaParameter(String deltaStringId, HttpServerRequest request, Logger log) {
        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage("Invalid delta parameter");
        request.response().end(request.response().getStatusMessage());
        log.error("Bad Request: {} '{}'", (Object)request.response().getStatusMessage(), (Object)deltaStringId);
    }

    private DeltaResourcesContainer getDeltaResourceNames(List<String> subResourceNames, JsonArray storageUpdateIds, long updateId) {
        ArrayList<String> deltaResourceNames = new ArrayList<String>();
        long maxUpdateId = 0L;
        for (int i = 0; i < storageUpdateIds.size(); ++i) {
            try {
                Long storedUpdateId = Long.parseLong(storageUpdateIds.getString(i));
                if (storedUpdateId > updateId) {
                    deltaResourceNames.add(subResourceNames.get(i));
                }
                if (storedUpdateId <= maxUpdateId) continue;
                maxUpdateId = storedUpdateId;
                continue;
            }
            catch (NumberFormatException ex) {
                deltaResourceNames.add(subResourceNames.get(i));
            }
        }
        return new DeltaResourcesContainer(maxUpdateId, deltaResourceNames);
    }

    private void handleCollectionGET(HttpServerRequest request, String updateId, Logger log) {
        request.pause();
        HttpMethod method = HttpMethod.GET;
        String targetUri = ExpansionDeltaUtil.constructRequestUri((String)request.path(), (MultiMap)request.params(), null, null, (ExpansionDeltaUtil.SlashHandling)ExpansionDeltaUtil.SlashHandling.KEEP);
        log.debug("constructed uri for request: {}", (Object)targetUri);
        HttpClientRequest cReq = this.httpClient.request(method, targetUri, cRes -> {
            HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)cRes);
            if (cRes.headers().contains(DELTA_HEADER)) {
                cRes.handler(data -> request.response().write(data));
                cRes.endHandler(v -> request.response().end());
            } else {
                cRes.bodyHandler(data -> {
                    try {
                        Set originalParams = null;
                        if (request.params() != null) {
                            originalParams = request.params().names();
                        }
                        ExpansionDeltaUtil.CollectionResourceContainer dataContainer = ExpansionDeltaUtil.verifyCollectionResponse((HttpServerRequest)request, (Buffer)data, (Set)originalParams);
                        List subResourceNames = dataContainer.getResourceNames();
                        List<String> deltaResourceKeys = this.buildDeltaResourceKeys(request.path(), subResourceNames);
                        long updateIdNumber = this.extractNumberDeltaParameter(updateId, request, log);
                        if (log.isTraceEnabled()) {
                            log.trace("DeltaHandler: deltaResourceKeys for targetUri ({}): {}", (Object)targetUri, (Object)deltaResourceKeys.toString());
                        }
                        if (deltaResourceKeys.size() > 0) {
                            if (log.isTraceEnabled()) {
                                log.trace("DeltaHandler: targetUri ({}) using mget command.", (Object)targetUri);
                            }
                            this.redisClient.mgetMany(deltaResourceKeys, event -> {
                                if (event.failed()) {
                                    log.error("mget command failed with cuase: {}", (Object)this.logCause((AsyncResult)event));
                                    this.handleError(request, "error reading delta information");
                                    return;
                                }
                                JsonArray mgetValues = (JsonArray)event.result();
                                DeltaResourcesContainer deltaResourcesContainer = this.getDeltaResourceNames(subResourceNames, mgetValues, updateIdNumber);
                                JsonObject result = this.buildResultJsonObject(deltaResourcesContainer.getResourceNames(), dataContainer.getCollectionName());
                                request.response().putHeader(DELTA_HEADER, "" + deltaResourcesContainer.getMaxUpdateId());
                                request.response().end(result.toString());
                            });
                        } else {
                            if (log.isTraceEnabled()) {
                                log.trace("DeltaHandler: targetUri ({}) NOT using database", (Object)targetUri);
                            }
                            request.response().putHeader(DELTA_HEADER, "" + updateIdNumber);
                            request.response().end(data);
                        }
                    }
                    catch (ResourceCollectionException exception) {
                        HttpServerResponse response = request.response();
                        if (StatusCode.NOT_FOUND.equals((Object)exception.getStatusCode())) {
                            log.info("Failed to handle get for collection because collection could not be found");
                        } else {
                            log.error("Failed to handle get for collection", (Throwable)exception);
                        }
                        response.setStatusCode(exception.getStatusCode().getStatusCode());
                        response.setStatusMessage(exception.getStatusCode().getStatusMessage());
                        response.putHeader("Content-Type", "text/plain");
                        if (StatusCode.BAD_GATEWAY.equals((Object)exception.getStatusCode())) {
                            response.write("Failed to handle upstream response for \"" + method.name() + " " + targetUri + "\".\nCAUSED BY: ");
                        }
                        response.end(exception.getMessage());
                    }
                });
            }
            cRes.exceptionHandler(ExpansionDeltaUtil.createResponseExceptionHandler((HttpServerRequest)request, (String)targetUri, DeltaHandler.class));
        });
        cReq.setTimeout(120000L);
        cReq.headers().setAll(request.headers());
        cReq.headers().set(DELTA_BACKEND_HEADER, "");
        cReq.headers().set("Accept", "application/json");
        cReq.setChunked(true);
        request.handler(arg_0 -> ((HttpClientRequest)cReq).write(arg_0));
        request.endHandler(v -> {
            cReq.end();
            log.debug("Request done. Request : {}", (Object)cReq);
        });
        cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)targetUri, DeltaHandler.class));
        request.resume();
    }

    private List<String> buildDeltaResourceKeys(String requestPath, List<String> subResourceNames) {
        ArrayList<String> storageResourceKeys = new ArrayList<String>();
        String resourceKeyPrefix = this.getResourceKey(requestPath, false);
        for (String entry : subResourceNames) {
            storageResourceKeys.add(resourceKeyPrefix + ":" + entry);
        }
        return storageResourceKeys;
    }

    private JsonObject buildResultJsonObject(List<String> subResourceNames, String collectionName) {
        JsonArray arr = new JsonArray();
        subResourceNames.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
        JsonObject result = new JsonObject();
        result.put(collectionName, arr);
        return result;
    }

    private boolean rejectLimitOffsetRequests(HttpServerRequest request) {
        if (!this.rejectLimitOffsetRequests) {
            return false;
        }
        return request.params().contains(LIMIT_PARAM) || request.params().contains(OFFSET_PARAM);
    }

    private void handleError(HttpServerRequest request, String errorMessage) {
        request.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        request.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
        request.response().end(errorMessage);
    }

    private String getResourceKey(String path, boolean useEtagPrefix) {
        ArrayList pathSegments = Lists.newArrayList((Iterable)Splitter.on((String)SLASH).omitEmptyStrings().split((CharSequence)path));
        if (useEtagPrefix) {
            pathSegments.add(0, ETAG_KEY_PREFIX);
        } else {
            pathSegments.add(0, RESOURCE_KEY_PREFIX);
        }
        return Joiner.on((String)":").skipNulls().join((Iterable)pathSegments);
    }

    private Long getExpireAfterValue(HttpServerRequest request, Logger log) {
        MultiMap requestHeaders = request.headers();
        String expireAfterHeaderValue = requestHeaders.get(EXPIRE_AFTER_HEADER);
        if (expireAfterHeaderValue == null) {
            log.debug("Setting NO expiry on delta key because header {} not defined", (Object)EXPIRE_AFTER_HEADER);
            return null;
        }
        try {
            long value = Long.parseLong(expireAfterHeaderValue);
            if (value < 0L) {
                log.warn("Setting NO expiry on delta key because because defined value for header {} is a negative number: {}", (Object)EXPIRE_AFTER_HEADER, (Object)expireAfterHeaderValue);
                return null;
            }
            log.debug("Setting expiry on delta key to {} seconds as defined in header {}", (Object)value, (Object)EXPIRE_AFTER_HEADER);
            return value;
        }
        catch (Exception e) {
            log.warn("Setting NO expiry on delta key because header {} is not a number: {}", (Object)EXPIRE_AFTER_HEADER, (Object)expireAfterHeaderValue);
            return null;
        }
    }

    private String logCause(AsyncResult result) {
        if (result.cause() != null) {
            return result.cause().getMessage();
        }
        return null;
    }

    private class DeltaResourcesContainer {
        private final long maxUpdateId;
        private final List<String> resourceNames;

        public DeltaResourcesContainer(long maxUpdateId, List<String> resourceNames) {
            this.maxUpdateId = maxUpdateId;
            this.resourceNames = resourceNames;
        }

        public long getMaxUpdateId() {
            return this.maxUpdateId;
        }

        public List<String> getResourceNames() {
            return this.resourceNames;
        }
    }
}

