/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.delta;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.redis.client.Response;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.redis.RedisByNameProvider;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.FailedAsyncResult;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.logging.LogAppenderRepository;
import org.swisspush.gateleen.logging.LoggingHandler;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.routing.Router;
import org.swisspush.gateleen.routing.Rule;
import org.swisspush.gateleen.routing.RuleFeatures;
import org.swisspush.gateleen.routing.RuleFeaturesProvider;
import org.swisspush.gateleen.routing.RuleProvider;

public class DeltaHandler
implements RuleProvider.RuleChangesObserver {
    private final Logger log = LoggerFactory.getLogger(DeltaHandler.class);
    private static final String DELTA_PARAM = "delta";
    private static final String LIMIT_PARAM = "limit";
    private static final String OFFSET_PARAM = "offset";
    private static final String DELTA_HEADER = "x-delta";
    private static final String IF_NONE_MATCH_HEADER = "if-none-match";
    private static final String DELTA_BACKEND_HEADER = "x-delta-backend";
    private static final String EXPIRE_AFTER_HEADER = "X-Expire-After";
    private static final String SLASH = "/";
    private static final int TIMEOUT = 120000;
    private static final String SEQUENCE_KEY = "delta:sequence";
    private static final String RESOURCE_KEY_PREFIX = "delta:resources";
    private static final String ETAG_KEY_PREFIX = "delta:etags";
    private final HttpClient httpClient;
    private final RedisByNameProvider redisProvider;
    private final boolean rejectLimitOffsetRequests;
    private final RuleProvider ruleProvider;
    private List<Pair<Pattern, Rule>> storageRules = new ArrayList<Pair<Pattern, Rule>>();
    private final Vertx vertx;
    private final LoggingResourceManager loggingResourceManager;
    private final LogAppenderRepository logAppenderRepository;
    private RuleFeaturesProvider ruleFeaturesProvider = new RuleFeaturesProvider(new ArrayList());

    public DeltaHandler(Vertx vertx, RedisByNameProvider redisProvider, HttpClient httpClient, RuleProvider ruleProvider, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository) {
        this(vertx, redisProvider, httpClient, ruleProvider, loggingResourceManager, logAppenderRepository, false);
    }

    public DeltaHandler(Vertx vertx, RedisByNameProvider redisProvider, HttpClient httpClient, RuleProvider ruleProvider, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, boolean rejectLimitOffsetRequests) {
        this.vertx = vertx;
        this.redisProvider = redisProvider;
        this.httpClient = httpClient;
        this.rejectLimitOffsetRequests = rejectLimitOffsetRequests;
        this.ruleProvider = ruleProvider;
        this.loggingResourceManager = loggingResourceManager;
        this.logAppenderRepository = logAppenderRepository;
        this.ruleProvider.registerObserver((RuleProvider.RuleChangesObserver)this);
    }

    public void rulesChanged(List<Rule> rules) {
        this.log.info("Update deltaOnBackend information from changed routing rules");
        this.ruleFeaturesProvider = new RuleFeaturesProvider(rules);
        this.updateStorageRules(rules);
    }

    public boolean isDeltaRequest(HttpServerRequest request) {
        return this.isDeltaGETRequest(request) || this.isDeltaPUTRequest(request);
    }

    private boolean isDeltaPUTRequest(HttpServerRequest request) {
        if (HttpMethod.PUT == request.method() && request.headers().contains(DELTA_HEADER)) {
            return "auto".equalsIgnoreCase(request.headers().get(DELTA_HEADER));
        }
        return false;
    }

    private boolean isDeltaGETRequest(HttpServerRequest request) {
        if (HttpMethod.GET == request.method() && request.params().contains(DELTA_PARAM) && !request.headers().contains(DELTA_BACKEND_HEADER) && !this.isBackendDelta(request.uri())) {
            return true;
        }
        if (request.headers().contains(DELTA_BACKEND_HEADER)) {
            request.headers().remove(DELTA_BACKEND_HEADER);
        }
        return false;
    }

    private boolean isBackendDelta(String uri) {
        return this.ruleFeaturesProvider.isFeatureRequest(RuleFeatures.Feature.DELTA_ON_BACKEND, uri);
    }

    @Nullable
    private String getStorageName(HttpServerRequest request) {
        for (Pair<Pattern, Rule> rulePair : this.storageRules) {
            if (!((Pattern)rulePair.getLeft()).matcher(request.uri()).matches()) continue;
            return ((Rule)rulePair.getRight()).getStorage();
        }
        this.log.warn("No storage rule found for uri {}. This should not happen!", (Object)request.uri());
        return null;
    }

    public void handle(HttpServerRequest request, Router router) {
        String updateId;
        Logger log = RequestLoggerFactory.getLogger(DeltaHandler.class, (HttpServerRequest)request);
        String storageName = this.getStorageName(request);
        if (this.isDeltaPUTRequest(request)) {
            this.handleResourcePUT(request, storageName, router, log);
        }
        if (this.isDeltaGETRequest(request) && (updateId = this.extractStringDeltaParameter(request, log)) != null) {
            if (this.rejectLimitOffsetRequests(request)) {
                this.respondLimitOffsetParameterForbidden(request, log);
            } else {
                this.handleCollectionGET(request, storageName, updateId, log);
            }
        }
    }

    private void handleResourcePUT(HttpServerRequest request, @Nullable String storageName, Router router, Logger log) {
        request.pause();
        this.handleDeltaEtag(request, storageName, log, (Handler<Boolean>)((Handler)updateDelta -> {
            if (updateDelta.booleanValue()) {
                this.redisProvider.redis(storageName).onSuccess(redisAPI -> redisAPI.incr(SEQUENCE_KEY, reply -> {
                    if (reply.failed()) {
                        log.error("incr command for redisKey {} failed with cause: {}", (Object)SEQUENCE_KEY, (Object)this.logCause((AsyncResult)reply));
                        this.handleError(request, "error incrementing/accessing sequence for update-id");
                        return;
                    }
                    String resourceKey = this.getResourceKey(request.path(), false);
                    Long expireAfter = this.getExpireAfterValue(request, log);
                    String updateId = String.valueOf(reply.result());
                    this.saveDelta(resourceKey, storageName, updateId, expireAfter, (Handler<AsyncResult<Object>>)((Handler)event -> {
                        if (event.failed()) {
                            log.error("set command for redisKey {} failed with cause: {}", (Object)resourceKey, (Object)this.logCause((AsyncResult)event));
                            this.handleError(request, "error saving delta information");
                            request.resume();
                        } else {
                            request.resume();
                            router.route(request);
                        }
                    }));
                })).onFailure(throwable -> {
                    log.error("Redis: handleResourcePUT failed", throwable);
                    this.handleError(request, "handleResourcePUT: error incrementing/accessing sequence for update-id ");
                });
            } else {
                log.debug("skip updating delta, resume request");
                request.resume();
                router.route(request);
            }
        }));
    }

    private void handleDeltaEtag(HttpServerRequest request, @Nullable String storageName, Logger log, Handler<Boolean> callback) {
        if (!request.headers().contains(IF_NONE_MATCH_HEADER)) {
            callback.handle((Object)Boolean.TRUE);
            return;
        }
        String requestEtag = request.headers().get(IF_NONE_MATCH_HEADER);
        String etagResourceKey = this.getResourceKey(request.path(), true);
        this.redisProvider.redis(storageName).onSuccess(redisAPI -> redisAPI.get(etagResourceKey, event -> {
            if (event.failed()) {
                log.error("get command for redisKey {} failed with cause: {}", (Object)etagResourceKey, (Object)this.logCause((AsyncResult)event));
                callback.handle((Object)Boolean.TRUE);
                return;
            }
            String etagFromStorage = Objects.toString(event.result(), "");
            if (StringUtils.isEmpty((CharSequence)etagFromStorage)) {
                this.saveOrUpdateDeltaEtag(etagResourceKey, request, storageName, log, (Handler<Boolean>)((Handler)aBoolean -> callback.handle((Object)Boolean.TRUE)));
            } else if (etagFromStorage.equals(requestEtag)) {
                callback.handle((Object)Boolean.FALSE);
            } else {
                this.saveOrUpdateDeltaEtag(etagResourceKey, request, storageName, log, (Handler<Boolean>)((Handler)aBoolean -> callback.handle((Object)Boolean.TRUE)));
            }
        })).onFailure(throwable -> {
            log.error("Redis: handleDeltaEtag failed for redisKey {}", (Object)etagResourceKey, throwable);
            callback.handle((Object)Boolean.TRUE);
        });
    }

    private void saveOrUpdateDeltaEtag(String etagResourceKey, HttpServerRequest request, @Nullable String storageName, Logger log, Handler<Boolean> updateCallback) {
        String requestEtag = request.headers().get(IF_NONE_MATCH_HEADER);
        Long expireAfter = this.getExpireAfterValue(request, log);
        this.saveDelta(etagResourceKey, storageName, requestEtag, expireAfter, (Handler<AsyncResult<Object>>)((Handler)event -> {
            if (event.failed()) {
                log.error("set command for redisKey {} failed with cause: {}", (Object)etagResourceKey, (Object)this.logCause((AsyncResult)event));
            }
            updateCallback.handle((Object)Boolean.TRUE);
        }));
    }

    private void saveDelta(String deltaKey, @Nullable String storageName, String deltaValue, Long expireAfter, Handler<AsyncResult<Object>> handler) {
        this.redisProvider.redis(storageName).onSuccess(redisAPI -> {
            ArrayList<String> options = new ArrayList<String>(List.of(deltaKey, deltaValue));
            if (expireAfter != null) {
                options.addAll(List.of("EX", expireAfter.toString()));
            }
            redisAPI.set(options, handler);
        }).onFailure(throwable -> handler.handle((Object)new FailedAsyncResult(throwable)));
    }

    private String extractStringDeltaParameter(HttpServerRequest request, Logger log) {
        String updateIdValue = request.params().get(DELTA_PARAM);
        if (updateIdValue == null) {
            this.respondInvalidDeltaParameter(updateIdValue, request, log);
            return null;
        }
        return updateIdValue;
    }

    private Long extractNumberDeltaParameter(String deltaStringId, HttpServerRequest request, Logger log) {
        try {
            return Long.parseLong(deltaStringId);
        }
        catch (Exception exception) {
            this.respondInvalidDeltaParameter(deltaStringId, request, log);
            return null;
        }
    }

    private void respondLimitOffsetParameterForbidden(HttpServerRequest request, Logger log) {
        String errorMsg = "limit/offset parameter not allowed for delta requests";
        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
        request.response().end(errorMsg);
        log.warn(errorMsg);
    }

    private void respondInvalidDeltaParameter(String deltaStringId, HttpServerRequest request, Logger log) {
        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage("Invalid delta parameter");
        request.response().end(request.response().getStatusMessage());
        log.error("Bad Request: {} '{}'", (Object)request.response().getStatusMessage(), (Object)deltaStringId);
    }

    private DeltaResourcesContainer getDeltaResourceNames(List<String> subResourceNames, Response storageUpdateIds, long updateId) {
        ArrayList<String> deltaResourceNames = new ArrayList<String>();
        long maxUpdateId = 0L;
        for (int i = 0; i < storageUpdateIds.size(); ++i) {
            try {
                Long storedUpdateId = Long.parseLong(storageUpdateIds.get(i) != null ? storageUpdateIds.get(i).toString() : null);
                if (storedUpdateId > updateId) {
                    deltaResourceNames.add(subResourceNames.get(i));
                }
                if (storedUpdateId <= maxUpdateId) continue;
                maxUpdateId = storedUpdateId;
                continue;
            }
            catch (NumberFormatException ex) {
                deltaResourceNames.add(subResourceNames.get(i));
            }
        }
        return new DeltaResourcesContainer(maxUpdateId, deltaResourceNames);
    }

    private void handleCollectionGET(HttpServerRequest request, @Nullable String storageName, String updateId, Logger log) {
        request.pause();
        LoggingHandler loggingHandler = new LoggingHandler(this.loggingResourceManager, this.logAppenderRepository, request, this.vertx.eventBus());
        loggingHandler.request(request.headers());
        HttpMethod method = HttpMethod.GET;
        String targetUri = ExpansionDeltaUtil.constructRequestUri((String)request.path(), (MultiMap)request.params(), null, null, (ExpansionDeltaUtil.SlashHandling)ExpansionDeltaUtil.SlashHandling.KEEP);
        log.debug("constructed uri for request: {}", (Object)targetUri);
        this.httpClient.request(method, targetUri).onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                log.warn("Failed request to {}: {}", (Object)targetUri, (Object)asyncResult.cause());
                return;
            }
            HttpClientRequest cReq = (HttpClientRequest)asyncResult.result();
            cReq.idleTimeout(120000L);
            cReq.headers().setAll(request.headers());
            cReq.headers().set(DELTA_BACKEND_HEADER, "");
            cReq.headers().set("x-skip-request-log", "true");
            cReq.headers().set("Accept", "application/json");
            cReq.setChunked(true);
            request.handler(arg_0 -> ((HttpClientRequest)cReq).write(arg_0));
            request.endHandler(v -> {
                cReq.send(asyncResult1 -> {
                    HttpClientResponse cRes = (HttpClientResponse)asyncResult1.result();
                    HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)cRes);
                    loggingHandler.setResponse(cRes);
                    if (cRes.headers().contains(DELTA_HEADER)) {
                        cRes.handler(data -> request.response().write(data));
                        cRes.endHandler(v1 -> request.response().end());
                    } else {
                        cRes.bodyHandler(data -> {
                            try {
                                Set originalParams = null;
                                if (request.params() != null) {
                                    originalParams = request.params().names();
                                }
                                ExpansionDeltaUtil.CollectionResourceContainer dataContainer = ExpansionDeltaUtil.verifyCollectionResponse((HttpServerRequest)request, (Buffer)data, (Set)originalParams);
                                List subResourceNames = dataContainer.getResourceNames();
                                List<String> deltaResourceKeys = this.buildDeltaResourceKeys(request.path(), subResourceNames);
                                long updateIdNumber = this.extractNumberDeltaParameter(updateId, request, log);
                                if (log.isTraceEnabled()) {
                                    log.trace("DeltaHandler: deltaResourceKeys for targetUri ({}): {}", (Object)targetUri, deltaResourceKeys);
                                }
                                if (!deltaResourceKeys.isEmpty()) {
                                    if (log.isTraceEnabled()) {
                                        log.trace("DeltaHandler: targetUri ({}) using mget command.", (Object)targetUri);
                                    }
                                    this.redisProvider.redis(storageName).onSuccess(redisAPI -> redisAPI.mget(deltaResourceKeys, event -> {
                                        if (event.failed()) {
                                            log.error("mget command failed with cause: {}", (Object)this.logCause((AsyncResult)event));
                                            this.handleError(request, "error reading delta information");
                                            return;
                                        }
                                        Response mgetValues = (Response)event.result();
                                        DeltaResourcesContainer deltaResourcesContainer = this.getDeltaResourceNames(subResourceNames, mgetValues, updateIdNumber);
                                        JsonObject result = this.buildResultJsonObject(deltaResourcesContainer.getResourceNames(), dataContainer.getCollectionName());
                                        String responseBody = result.toString();
                                        request.response().putHeader(DELTA_HEADER, "" + deltaResourcesContainer.getMaxUpdateId());
                                        loggingHandler.appendResponsePayload(Buffer.buffer((String)responseBody));
                                        loggingHandler.log();
                                        request.response().end(responseBody);
                                    })).onFailure(event -> {
                                        log.error("Redis: handleCollectionGET failed", event);
                                        this.handleError(request, "error reading delta information");
                                    });
                                } else {
                                    if (log.isTraceEnabled()) {
                                        log.trace("DeltaHandler: targetUri ({}) NOT using database", (Object)targetUri);
                                    }
                                    request.response().putHeader(DELTA_HEADER, "" + updateIdNumber);
                                    request.response().end(data);
                                }
                            }
                            catch (ResourceCollectionException exception) {
                                HttpServerResponse response = request.response();
                                if (StatusCode.NOT_FOUND.equals((Object)exception.getStatusCode())) {
                                    log.info("Failed to handle get for collection because collection could not be found");
                                } else {
                                    log.error("Failed to handle get for collection", (Throwable)exception);
                                }
                                response.setStatusCode(exception.getStatusCode().getStatusCode());
                                response.setStatusMessage(exception.getStatusCode().getStatusMessage());
                                response.putHeader("Content-Type", "text/plain");
                                if (StatusCode.BAD_GATEWAY.equals((Object)exception.getStatusCode())) {
                                    response.write("Failed to handle upstream response for \"" + method.name() + " " + targetUri + "\".\nCAUSED BY: ");
                                }
                                response.end(exception.getMessage());
                            }
                        });
                    }
                    cRes.exceptionHandler(ExpansionDeltaUtil.createResponseExceptionHandler((HttpServerRequest)request, (String)targetUri, DeltaHandler.class));
                });
                log.debug("Request done. Request : {}", (Object)cReq);
            });
            cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)request, (String)targetUri, DeltaHandler.class));
            request.resume();
        });
    }

    private List<String> buildDeltaResourceKeys(String requestPath, List<String> subResourceNames) {
        ArrayList<String> storageResourceKeys = new ArrayList<String>();
        String resourceKeyPrefix = this.getResourceKey(requestPath, false);
        for (String entry : subResourceNames) {
            storageResourceKeys.add(resourceKeyPrefix + ":" + entry);
        }
        return storageResourceKeys;
    }

    private JsonObject buildResultJsonObject(List<String> subResourceNames, String collectionName) {
        JsonArray arr = new JsonArray();
        subResourceNames.forEach(arg_0 -> ((JsonArray)arr).add(arg_0));
        JsonObject result = new JsonObject();
        result.put(collectionName, (Object)arr);
        return result;
    }

    private boolean rejectLimitOffsetRequests(HttpServerRequest request) {
        if (!this.rejectLimitOffsetRequests) {
            return false;
        }
        return request.params().contains(LIMIT_PARAM) || request.params().contains(OFFSET_PARAM);
    }

    private void handleError(HttpServerRequest request, String errorMessage) {
        request.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        request.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
        request.response().end(errorMessage);
    }

    private String getResourceKey(String path, boolean useEtagPrefix) {
        ArrayList pathSegments = Lists.newArrayList((Iterable)Splitter.on((String)SLASH).omitEmptyStrings().split((CharSequence)path));
        if (useEtagPrefix) {
            pathSegments.add(0, ETAG_KEY_PREFIX);
        } else {
            pathSegments.add(0, RESOURCE_KEY_PREFIX);
        }
        return Joiner.on((String)":").skipNulls().join((Iterable)pathSegments);
    }

    private Long getExpireAfterValue(HttpServerRequest request, Logger log) {
        MultiMap requestHeaders = request.headers();
        String expireAfterHeaderValue = requestHeaders.get(EXPIRE_AFTER_HEADER);
        if (expireAfterHeaderValue == null) {
            log.debug("Setting NO expiry on delta key because header {} not defined", (Object)EXPIRE_AFTER_HEADER);
            return null;
        }
        try {
            long value = Long.parseLong(expireAfterHeaderValue);
            if (value < 0L) {
                log.warn("Setting NO expiry on delta key because because defined value for header {} is a negative number: {}", (Object)EXPIRE_AFTER_HEADER, (Object)expireAfterHeaderValue);
                return null;
            }
            log.debug("Setting expiry on delta key to {} seconds as defined in header {}", (Object)value, (Object)EXPIRE_AFTER_HEADER);
            return value;
        }
        catch (Exception e) {
            log.warn("Setting NO expiry on delta key because header {} is not a number: {}", (Object)EXPIRE_AFTER_HEADER, (Object)expireAfterHeaderValue);
            return null;
        }
    }

    private void updateStorageRules(List<Rule> rules) {
        this.storageRules.clear();
        for (Rule rule : rules) {
            if (rule.getStorage() == null) continue;
            try {
                this.storageRules.add((Pair<Pattern, Rule>)Pair.of((Object)Pattern.compile(rule.getUrlPattern()), (Object)rule));
            }
            catch (PatternSyntaxException patternException) {
                this.log.warn("Rule '{}' has not a valid regex pattern. Discarding this storage rule", (Object)rule.getUrlPattern());
            }
        }
    }

    private String logCause(AsyncResult result) {
        if (result.cause() != null) {
            return result.cause().getMessage();
        }
        return null;
    }

    private static class DeltaResourcesContainer {
        private final long maxUpdateId;
        private final List<String> resourceNames;

        public DeltaResourcesContainer(long maxUpdateId, List<String> resourceNames) {
            this.maxUpdateId = maxUpdateId;
            this.resourceNames = resourceNames;
        }

        public long getMaxUpdateId() {
            return this.maxUpdateId;
        }

        public List<String> getResourceNames() {
            return this.resourceNames;
        }
    }
}

