/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.buffer.Buffer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.expansion.DeltaHandler;
import org.swisspush.gateleen.expansion.RecursiveExpansionHandler;
import org.swisspush.gateleen.expansion.ResourceNode;

public class RecursiveZipHandler
implements DeltaHandler<ResourceNode> {
    private static final int PROCESS_DONE = 0;
    private static final String HANDLER_PATH = "<HANDLER>";
    private Logger log = LoggerFactory.getLogger(RecursiveExpansionHandler.class);
    private ResourceNode seriousError;
    private String collectionName;
    private AtomicInteger processCount;
    private DeltaHandler<ResourceNode> parentHandler;
    private List<ResourceNode> nodes;
    private AtomicInteger xDeltaResponseNumber;

    public RecursiveZipHandler(List<String> subResourceNames, String collectionName, DeltaHandler<ResourceNode> parentHandler) {
        this.parentHandler = parentHandler;
        this.collectionName = collectionName;
        this.processCount = new AtomicInteger(subResourceNames.size());
        this.nodes = new ArrayList<ResourceNode>();
        this.xDeltaResponseNumber = new AtomicInteger(0);
    }

    public void handle(ResourceNode node) {
        this.processCount.decrementAndGet();
        if (node != null) {
            if (node.getObject() instanceof ResourceCollectionException && node.getNodeName().equals("a serious exception happend ")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("(serious error) handle collection '" + this.collectionName + "'.");
                }
                if (this.seriousError == null) {
                    this.seriousError = node;
                }
            } else if (node.getPath().equals(HANDLER_PATH)) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("adding collection of '" + node.getNodeName() + "' to parent '" + this.collectionName + "'.");
                }
                this.nodes.addAll((List)node.getObject());
            } else if (!node.getPath().isEmpty()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("adding resource '" + node.getNodeName() + "' to collection '" + this.collectionName + "'.");
                }
                node.setObject(((Buffer)node.getObject()).getBytes());
                this.nodes.add(node);
            }
        }
        if (this.processCount.get() == 0) {
            if (this.seriousError != null) {
                this.parentHandler.handle(this.seriousError);
            } else {
                this.parentHandler.storeXDeltaResponseHeader("" + this.xDeltaResponseNumber.get());
                this.parentHandler.handle(new ResourceNode(this.collectionName, this.nodes, "", HANDLER_PATH));
            }
        }
    }

    @Override
    public void storeXDeltaResponseHeader(String xDeltaResponseNumber) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("storeXDeltaResponseHeader > " + xDeltaResponseNumber);
        }
        if (xDeltaResponseNumber != null) {
            try {
                int tempxDeltaResponseNumber = Integer.parseInt(xDeltaResponseNumber);
                if (this.xDeltaResponseNumber.get() < tempxDeltaResponseNumber) {
                    this.xDeltaResponseNumber.set(tempxDeltaResponseNumber);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

