/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Set;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.HashCodeGenerator;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.expansion.RecursiveRootHandlerBase;
import org.swisspush.gateleen.expansion.ResourceNode;

public class RecursiveExpansionRootHandler
extends RecursiveRootHandlerBase {
    private static final String ETAG_HEADER = "Etag";
    private static final String IF_NONE_MATCH_HEADER = "if-none-match";
    private final HttpServerRequest req;
    private final Buffer data;
    private final Set<String> finalOriginalParams;

    public RecursiveExpansionRootHandler(HttpServerRequest req, Buffer data, Set<String> finalOriginalParams) {
        this.req = req;
        this.data = data;
        this.finalOriginalParams = finalOriginalParams;
    }

    public void handle(ResourceNode node) {
        if (log.isTraceEnabled()) {
            log.trace("parent handler called > " + (node != null ? node.getNodeName() : "not found"));
        }
        try {
            ExpansionDeltaUtil.CollectionResourceContainer collection = ExpansionDeltaUtil.verifyCollectionResponse((HttpServerRequest)this.req, (Buffer)this.data, this.finalOriginalParams);
            if (node.getObject() instanceof Buffer) {
                try {
                    node.setObject(new JsonObject(((Buffer)node.getObject()).toString("UTF-8")));
                }
                catch (Exception e) {
                    log.error("Error in result of sub resource '" + node.getNodeName() + "' Message: " + e.getMessage());
                    node.setObject((Object)new ResourceCollectionException(e.getMessage()));
                }
            }
            this.checkIfError(node);
            JsonObject container = new JsonObject();
            if (node.getObject() instanceof JsonObject) {
                container.put(collection.getCollectionName(), (JsonObject)node.getObject());
            } else {
                container.put(collection.getCollectionName(), (JsonArray)node.getObject());
            }
            this.buildAndSendResult(this.req, container, node.geteTag());
        }
        catch (ResourceCollectionException exception) {
            this.handleResponseError(this.req, exception);
        }
        catch (Exception exception) {
            ResponseStatusCodeLogUtil.info((HttpServerRequest)this.req, (StatusCode)StatusCode.INTERNAL_SERVER_ERROR, RecursiveExpansionRootHandler.class);
            this.req.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
            this.req.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
            this.req.response().end(exception.getMessage());
        }
    }

    private void buildAndSendResult(HttpServerRequest req, JsonObject responseObject, String collectedeTags) {
        JsonObject responseContent;
        String etagFromResources = HashCodeGenerator.createSHA256HashCode((String)collectedeTags);
        if (this.finalOriginalParams.contains("delta")) {
            req.response().headers().set("x-delta", "" + this.xDeltaResponseNumber);
        }
        if ((responseContent = this.makeCachedResponse(req, etagFromResources, responseObject)) == null) {
            if (log.isTraceEnabled()) {
                log.trace("end response without content");
            }
            req.response().end();
        } else {
            if (log.isTraceEnabled()) {
                log.trace("end response with content");
            }
            req.response().end(responseObject.toString());
        }
    }

    private JsonObject makeCachedResponse(HttpServerRequest req, String etagFromResources, JsonObject responseObject) {
        JsonObject result = responseObject;
        if (log.isTraceEnabled()) {
            log.trace("Header from request:  " + req.headers().get(IF_NONE_MATCH_HEADER));
            log.trace("Header from response: " + etagFromResources);
        }
        if (etagFromResources != null) {
            req.response().headers().add(ETAG_HEADER, etagFromResources);
            String ifNoneMatch = req.headers().get(IF_NONE_MATCH_HEADER);
            if (etagFromResources.equals(ifNoneMatch)) {
                ResponseStatusCodeLogUtil.debug((HttpServerRequest)req, (StatusCode)StatusCode.NOT_MODIFIED, RecursiveExpansionRootHandler.class);
                req.response().setStatusCode(StatusCode.NOT_MODIFIED.getStatusCode());
                req.response().setStatusMessage(StatusCode.NOT_MODIFIED.getStatusMessage());
                req.response().headers().add("Content-Length", "0");
                req.response().setChunked(false);
                result = null;
            } else {
                ResponseStatusCodeLogUtil.debug((HttpServerRequest)req, (StatusCode)StatusCode.OK, RecursiveExpansionRootHandler.class);
            }
        } else {
            ResponseStatusCodeLogUtil.debug((HttpServerRequest)req, (StatusCode)StatusCode.OK, RecursiveExpansionRootHandler.class);
        }
        return result;
    }
}

