/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import java.io.ByteArrayInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.reststorage.MimeTypeResolver;

public class ZipExtractHandler {
    private static final String ZIP_RESOURCE_FLAG = ".zip/";
    private static final int DEFAULT_TIMEOUT = 120000;
    private static final byte[] ZIP_BUFFER_SIZE = new byte[2048];
    private static final String DEFAULT_MIME_TYPE = "application/json";
    private final HttpClient selfClient;
    private final MimeTypeResolver mimeTypeResolver;

    public ZipExtractHandler(HttpClient selfClient) {
        this.selfClient = selfClient;
        this.mimeTypeResolver = new MimeTypeResolver(DEFAULT_MIME_TYPE);
    }

    public boolean handle(HttpServerRequest req) {
        if (req.method().equals((Object)HttpMethod.GET) && req.uri().contains(ZIP_RESOURCE_FLAG)) {
            int seperationIndex = req.uri().lastIndexOf(ZIP_RESOURCE_FLAG) + ZIP_RESOURCE_FLAG.length() - 1;
            String zipUrl = req.uri().substring(0, seperationIndex);
            String insidePath = req.uri().substring(seperationIndex + 1);
            this.performGETRequest(req, zipUrl, insidePath);
            return true;
        }
        return false;
    }

    protected void performGETRequest(HttpServerRequest req, String zipUrl, String insidePath) {
        Logger log = RequestLoggerFactory.getLogger(ZipExtractHandler.class, (HttpServerRequest)req);
        HttpClientRequest selfRequest = this.selfClient.get(zipUrl, response -> {
            if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                this.extractResourceFromZip(req, zipUrl, insidePath, (HttpClientResponse)response);
            } else {
                log.debug("GET of zip resource {} failed.", (Object)zipUrl);
                this.createResponse(req, response.statusCode(), response.statusMessage(), null, null);
            }
        });
        selfRequest.headers().setAll(req.headers());
        selfRequest.setTimeout(120000L);
        selfRequest.end();
    }

    private void createResponse(HttpServerRequest req, int statusCode, String statusMessage, Buffer buffer, String mimeType) {
        req.response().setStatusCode(statusCode);
        req.response().setStatusMessage(statusMessage);
        if (mimeType != null) {
            req.response().headers().add("Content-Type", mimeType);
        }
        if (buffer != null) {
            req.response().end(buffer);
        } else {
            req.response().end();
        }
    }

    private void extractResourceFromZip(HttpServerRequest req, String zipUrl, String insidePath, HttpClientResponse response) {
        Logger log = RequestLoggerFactory.getLogger(ZipExtractHandler.class, (HttpServerRequest)req);
        response.bodyHandler(buffer -> {
            try (ByteArrayInputStream bInputStream = new ByteArrayInputStream(buffer.getBytes());
                 ZipInputStream inputStream = new ZipInputStream(bInputStream);){
                ZipEntry entry;
                Buffer contentBuffer = Buffer.buffer();
                boolean foundEntry = false;
                while ((entry = inputStream.getNextEntry()) != null) {
                    if (!entry.getName().equalsIgnoreCase(insidePath)) continue;
                    int len = 0;
                    while ((len = inputStream.read(ZIP_BUFFER_SIZE)) > 0) {
                        contentBuffer.appendBytes(ZIP_BUFFER_SIZE, 0, len);
                    }
                    foundEntry = true;
                    break;
                }
                if (foundEntry) {
                    this.createResponse(req, StatusCode.OK.getStatusCode(), StatusCode.OK.getStatusMessage(), contentBuffer, this.mimeTypeResolver.resolveMimeType(insidePath));
                } else {
                    log.error("could not extract {} from {}", new Object[]{insidePath, zipUrl});
                    this.createResponse(req, StatusCode.NOT_FOUND.getStatusCode(), StatusCode.NOT_FOUND.getStatusMessage(), null, null);
                }
            }
            catch (Exception e) {
                log.error("could not extract {} from {}: {}", new Object[]{insidePath, zipUrl, e.getMessage()});
                this.createResponse(req, StatusCode.INTERNAL_SERVER_ERROR.getStatusCode(), StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage(), null, null);
            }
        });
    }
}

