/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.expansion.RecursiveExpansionRootHandler;
import org.swisspush.gateleen.expansion.RecursiveRootHandlerBase;
import org.swisspush.gateleen.expansion.ResourceNode;

public class RecursiveZipRootHandler
extends RecursiveRootHandlerBase {
    private static final int DATA_BLOCK_SIZE = 2048;
    private static final String CONTENT_TYPE_HEADER = "Content-type";
    private static final String CONTENT_TYPE_ZIP = "application/octet-stream";
    private final HttpServerRequest req;
    private final String serverRoot;
    private final Buffer data;
    private final Set<String> finalOriginalParams;

    public RecursiveZipRootHandler(HttpServerRequest req, String serverRoot, Buffer data, Set<String> finalOriginalParams) {
        this.req = req;
        this.serverRoot = serverRoot;
        this.data = data;
        this.finalOriginalParams = finalOriginalParams;
    }

    public void handle(ResourceNode node) {
        if (log.isTraceEnabled()) {
            log.trace("parent handler called");
        }
        try {
            ExpansionDeltaUtil.verifyCollectionResponse((HttpServerRequest)this.req, (Buffer)this.data, this.finalOriginalParams);
            this.checkIfError(node);
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                 ZipOutputStream zipOutputStream = new ZipOutputStream(outputStream);){
                Iterable zipableNodes = (Iterable)node.getObject();
                for (ResourceNode resourceNode : zipableNodes) {
                    if (log.isTraceEnabled()) {
                        log.trace("Create zip for: " + resourceNode.getNodeName());
                        log.trace("   >> " + resourceNode.getPath());
                    }
                    this.zipEntry(zipOutputStream, resourceNode);
                }
                zipOutputStream.finish();
                this.req.response().headers().set(CONTENT_TYPE_HEADER, CONTENT_TYPE_ZIP);
                if (this.finalOriginalParams.contains("delta")) {
                    this.req.response().headers().set("x-delta", "" + this.xDeltaResponseNumber);
                }
                ResponseStatusCodeLogUtil.debug((HttpServerRequest)this.req, (StatusCode)StatusCode.OK, RecursiveExpansionRootHandler.class);
                this.req.response().end(Buffer.buffer((byte[])outputStream.toByteArray()));
            }
            catch (Exception e) {
                log.error("Error while writing zip: " + e.getMessage(), (Throwable)e);
                this.createErrorResponse(e);
            }
        }
        catch (ResourceCollectionException exception) {
            this.handleResponseError(this.req, exception);
        }
    }

    private void zipEntry(ZipOutputStream zipOutputStream, ResourceNode resourceNode) {
        try (ByteArrayInputStream inputStream = new ByteArrayInputStream((byte[])resourceNode.getObject());){
            int byteCount;
            ZipEntry zipEntry = new ZipEntry(this.createNewZipEntryName(resourceNode.getPath()));
            zipOutputStream.putNextEntry(zipEntry);
            byte[] b = new byte[2048];
            while ((byteCount = inputStream.read(b, 0, 2048)) != -1) {
                zipOutputStream.write(b, 0, byteCount);
            }
            zipOutputStream.closeEntry();
            inputStream.close();
        }
        catch (Exception e) {
            log.error("Error while writing zip entry '" + resourceNode.getNodeName() + "'.", (Throwable)e);
        }
    }

    private void createErrorResponse(Exception exception) {
        ResponseStatusCodeLogUtil.debug((HttpServerRequest)this.req, (StatusCode)StatusCode.INTERNAL_SERVER_ERROR, RecursiveZipRootHandler.class);
        this.req.response().setStatusCode(StatusCode.INTERNAL_SERVER_ERROR.getStatusCode());
        this.req.response().setStatusMessage(StatusCode.INTERNAL_SERVER_ERROR.getStatusMessage());
        this.req.response().end(exception.getMessage());
    }

    private String createNewZipEntryName(String path) {
        return path.replace(this.serverRoot + "/", "");
    }
}

