/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.expansion.DeltaHandler;
import org.swisspush.gateleen.expansion.RecursiveHandlerFactory;
import org.swisspush.gateleen.expansion.ResourceNode;
import org.swisspush.gateleen.routing.Rule;
import org.swisspush.gateleen.routing.RuleFeatures;
import org.swisspush.gateleen.routing.RuleFeaturesProvider;
import org.swisspush.gateleen.routing.RuleProvider;

public class ExpansionHandler
implements RuleProvider.RuleChangesObserver {
    private Logger log = LoggerFactory.getLogger(ExpansionHandler.class);
    public static final String SERIOUS_EXCEPTION = "a serious exception happend ";
    public static final String EXPAND_PARAM = "expand";
    public static final String ZIP_PARAM = "zip";
    private static final int NO_PARAMETER_FOUND = -1;
    private static final int START_INDEX = 0;
    private static final int TIMEOUT = 120000;
    private static final int DECREMENT_BY_ONE = 1;
    private static final int MAX_RECURSION_LEVEL = 0;
    public static final String MAX_EXPANSION_LEVEL_SOFT_PROPERTY = "max.expansion.level.soft";
    public static final String MAX_EXPANSION_LEVEL_HARD_PROPERTY = "max.expansion.level.hard";
    public static final String MAX_SUBREQUEST_PROPERTY = "max.expansion.subrequests";
    private static final int MAX_SUBREQUEST_COUNT_DEFAULT = 20000;
    private static final String ETAG_HEADER = "Etag";
    private static final String SELF_REQUEST_HEADER = "x-self-request";
    private int maxSubRequestCount;
    private int maxExpansionLevelSoft = Integer.MAX_VALUE;
    private int maxExpansionLevelHard = Integer.MAX_VALUE;
    private HttpClient httpClient;
    private Map<String, Object> properties;
    private String serverRoot;
    private RuleProvider ruleProvider;
    private List<String> parameter_to_remove_for_all_request;
    private List<String> parameter_to_remove_after_initial_request;
    private RuleFeaturesProvider ruleFeaturesProvider = new RuleFeaturesProvider(new ArrayList());

    public ExpansionHandler(Vertx vertx, ResourceStorage storage, HttpClient httpClient, Map<String, Object> properties, String serverRoot, String rulesPath) {
        this.httpClient = httpClient;
        this.properties = properties;
        this.serverRoot = serverRoot;
        this.initParameterRemovalLists();
        this.initConfigurationValues();
        this.ruleProvider = new RuleProvider(vertx, rulesPath, storage, properties);
        this.ruleProvider.registerObserver((RuleProvider.RuleChangesObserver)this);
    }

    public void rulesChanged(List<Rule> rules) {
        this.log.info("Update expandOnBackend and storageExpand information from changed routing rules");
        this.ruleFeaturesProvider = new RuleFeaturesProvider(rules);
    }

    public int getMaxExpansionLevelSoft() {
        return this.maxExpansionLevelSoft;
    }

    public int getMaxExpansionLevelHard() {
        return this.maxExpansionLevelHard;
    }

    public int getMaxSubRequestCount() {
        return this.maxSubRequestCount;
    }

    private void initParameterRemovalLists() {
        this.parameter_to_remove_for_all_request = new ArrayList<String>();
        this.parameter_to_remove_after_initial_request = new ArrayList<String>();
        this.parameter_to_remove_for_all_request.add(EXPAND_PARAM);
        this.parameter_to_remove_after_initial_request.addAll(this.parameter_to_remove_for_all_request);
        this.parameter_to_remove_after_initial_request.add("limit");
        this.parameter_to_remove_after_initial_request.add("offset");
    }

    private void initConfigurationValues() {
        if (this.properties != null && this.properties.containsKey(MAX_SUBREQUEST_PROPERTY)) {
            try {
                this.maxSubRequestCount = Integer.parseInt((String)this.properties.get(MAX_SUBREQUEST_PROPERTY));
                this.log.info("Setting maximum allowed subrequest count to " + this.maxSubRequestCount + " from properties");
            }
            catch (Exception e) {
                this.maxSubRequestCount = 20000;
                this.log.warn("Setting maximum allowed subrequest count to a default of " + this.maxSubRequestCount + ", since defined value for " + MAX_SUBREQUEST_PROPERTY + " in properties is not a number");
            }
        } else {
            this.maxSubRequestCount = 20000;
            this.log.warn("Setting maximum allowed subrequest count to a default of " + this.maxSubRequestCount + ", since no property " + MAX_SUBREQUEST_PROPERTY + " is defined!");
        }
        if (this.properties != null && this.properties.containsKey(MAX_EXPANSION_LEVEL_SOFT_PROPERTY)) {
            try {
                this.maxExpansionLevelSoft = Integer.parseInt((String)this.properties.get(MAX_EXPANSION_LEVEL_SOFT_PROPERTY));
                this.log.info("Setting maximum expansion level soft value to " + this.maxExpansionLevelSoft + " from properties");
            }
            catch (Exception e) {
                this.log.warn("Setting maximum expansion level soft value to a default of " + this.maxExpansionLevelSoft + ", since defined value for " + MAX_EXPANSION_LEVEL_SOFT_PROPERTY + " in properties is not a number");
            }
        } else {
            this.log.info("Setting maximum expansion level soft value to a default of " + this.maxExpansionLevelSoft + ", since no property " + MAX_EXPANSION_LEVEL_SOFT_PROPERTY + " is defined!");
        }
        if (this.properties != null && this.properties.containsKey(MAX_EXPANSION_LEVEL_HARD_PROPERTY)) {
            try {
                this.maxExpansionLevelHard = Integer.parseInt((String)this.properties.get(MAX_EXPANSION_LEVEL_HARD_PROPERTY));
                this.log.info("Setting maximum expansion level hard value to " + this.maxExpansionLevelHard + " from properties");
            }
            catch (Exception e) {
                this.log.warn("Setting maximum expansion level hard value to a default of " + this.maxExpansionLevelHard + ", since defined value for " + MAX_EXPANSION_LEVEL_HARD_PROPERTY + " in properties is not a number");
            }
        } else {
            this.log.info("Setting maximum expansion level soft hard to a default of " + this.maxExpansionLevelHard + ", since no property " + MAX_EXPANSION_LEVEL_HARD_PROPERTY + " is defined!");
        }
    }

    public boolean isExpansionRequest(HttpServerRequest request) {
        return HttpMethod.GET == request.method() && request.params().contains(EXPAND_PARAM) && !this.isBackendExpand(request.uri());
    }

    protected boolean isBackendExpand(String uri) {
        return this.ruleFeaturesProvider.isFeatureRequest(RuleFeatures.Feature.EXPAND_ON_BACKEND, uri);
    }

    protected boolean isStorageExpand(String uri) {
        return this.ruleFeaturesProvider.isFeatureRequest(RuleFeatures.Feature.STORAGE_EXPAND, uri);
    }

    public boolean isZipRequest(HttpServerRequest request) {
        boolean ok = false;
        if (HttpMethod.GET == request.method() && request.params().contains(ZIP_PARAM)) {
            ok = !request.params().get(ZIP_PARAM).equalsIgnoreCase("false");
        }
        return ok && !this.isBackendExpand(request.uri());
    }

    private void handleExpansionRequest(HttpServerRequest req, RecursiveHandlerFactory.RecursiveHandlerTypes recursiveHandlerType) {
        req.pause();
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        Integer expandLevel = this.extractExpandParamValue(req, log);
        if (expandLevel == null) {
            this.respondBadRequest(req, "Expand parameter is not valid. Must be a positive number");
            return;
        }
        if (expandLevel > this.maxExpansionLevelHard) {
            String message = "Expand level '" + expandLevel + "' is greater than the maximum expand level '" + this.maxExpansionLevelHard + "'";
            log.info(message);
            this.respondBadRequest(req, message);
            return;
        }
        if (expandLevel > this.maxExpansionLevelSoft) {
            log.warn("Expand level '" + expandLevel + "' is greater than the maximum soft expand level '" + this.maxExpansionLevelSoft + "'. Using '" + this.maxExpansionLevelSoft + "' instead");
            expandLevel = this.maxExpansionLevelSoft;
        }
        if (this.isStorageExpand(req.uri()) && expandLevel > 1) {
            this.respondBadRequest(req, "Expand values higher than 1 are not supported for storageExpand requests");
            return;
        }
        Set originalParams = null;
        if (req.params() != null) {
            originalParams = req.params().names();
        }
        Set finalOriginalParams = originalParams;
        String targetUri = ExpansionDeltaUtil.constructRequestUri((String)req.path(), (MultiMap)req.params(), this.parameter_to_remove_for_all_request, null, (ExpansionDeltaUtil.SlashHandling)ExpansionDeltaUtil.SlashHandling.END_WITH_SLASH);
        log.debug("constructed uri for request: " + targetUri);
        Integer finalExpandLevel = expandLevel;
        HttpClientRequest cReq = this.httpClient.request(HttpMethod.GET, targetUri, cRes -> {
            HttpServerRequestUtil.prepareResponse((HttpServerRequest)req, (HttpClientResponse)cRes);
            if (log.isTraceEnabled()) {
                log.trace(" x-delta for " + targetUri + " is " + cRes.headers().get("x-delta"));
            }
            cRes.bodyHandler(data -> this.makeResourceSubRequest(targetUri, req, finalExpandLevel, new AtomicInteger(), recursiveHandlerType, RecursiveHandlerFactory.createRootHandler(recursiveHandlerType, req, this.serverRoot, data, finalOriginalParams), true));
            cRes.exceptionHandler(ExpansionDeltaUtil.createResponseExceptionHandler((HttpServerRequest)req, (String)targetUri, ExpansionHandler.class));
        });
        if (log.isTraceEnabled()) {
            log.trace("set cReq headers");
        }
        cReq.setTimeout(120000L);
        cReq.headers().setAll(req.headers());
        cReq.headers().set("Accept", "application/json");
        cReq.headers().set(SELF_REQUEST_HEADER, "true");
        cReq.setChunked(true);
        if (log.isTraceEnabled()) {
            log.trace("set request data handler");
        }
        req.handler(data -> {
            if (log.isTraceEnabled()) {
                log.trace("write data of the last subrequest");
            }
            cReq.write(data);
        });
        if (log.isTraceEnabled()) {
            log.trace("set request end handler");
        }
        req.endHandler(v -> {
            cReq.end();
            log.debug("Request done");
        });
        cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)req, (String)targetUri, ExpansionHandler.class));
        if (log.isTraceEnabled()) {
            log.trace("resume request");
        }
        req.resume();
    }

    private Integer extractExpandParamValue(HttpServerRequest request, Logger log) {
        String expandValue = request.params().get(EXPAND_PARAM);
        log.debug("got expand parameter value " + expandValue);
        try {
            Integer value = Integer.valueOf(expandValue);
            if (value < 0) {
                log.warn("expand parameter value '" + expandValue + "' is not a positive number");
                return null;
            }
            return value;
        }
        catch (NumberFormatException ex) {
            log.warn("expand parameter value '" + expandValue + "' is not a valid number");
            return null;
        }
    }

    public void handleExpansionRecursion(HttpServerRequest request) {
        this.removeZipParameter(request);
        this.handleExpansionRequest(request, RecursiveHandlerFactory.RecursiveHandlerTypes.EXPANSION);
    }

    public void handleZipRecursion(HttpServerRequest request) {
        RecursiveHandlerFactory.RecursiveHandlerTypes zipType = RecursiveHandlerFactory.RecursiveHandlerTypes.ZIP;
        try {
            zipType = RecursiveHandlerFactory.RecursiveHandlerTypes.valueOf(request.params().get(ZIP_PARAM).toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("currently using zip mode: " + (Object)((Object)zipType));
        }
        this.removeZipParameter(request);
        this.handleExpansionRequest(request, zipType);
    }

    private void removeZipParameter(HttpServerRequest request) {
        if (request.params().contains(ZIP_PARAM)) {
            request.params().remove(ZIP_PARAM);
        }
    }

    private void makeStorageExpandRequest(String targetUri, List subResourceNames, HttpServerRequest req, DeltaHandler<ResourceNode> handler) {
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        HttpClientRequest cReq = this.httpClient.request(HttpMethod.POST, targetUri + "?storageExpand=true", cRes -> cRes.bodyHandler(data -> {
            if (StatusCode.NOT_FOUND.getStatusCode() == cRes.statusCode()) {
                log.debug("requested resource could not be found: " + targetUri);
                handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.NOT_FOUND)));
            } else if (StatusCode.INTERNAL_SERVER_ERROR.getStatusCode() == cRes.statusCode()) {
                log.error("error in request resource : " + targetUri + " message : " + data.toString());
                handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(data.toString(), StatusCode.INTERNAL_SERVER_ERROR)));
            } else if (StatusCode.METHOD_NOT_ALLOWED.getStatusCode() == cRes.statusCode()) {
                log.error("POST requests (storageExpand) not allowed for uri: " + targetUri);
                handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.METHOD_NOT_ALLOWED)));
            } else {
                String eTag = this.geteTag(cRes.headers());
                this.handleSimpleResource(this.removeParameters(targetUri), handler, (Buffer)data, eTag);
            }
        }));
        JsonObject requestPayload = new JsonObject();
        requestPayload.put("subResources", new JsonArray(subResourceNames));
        Buffer payload = Buffer.buffer((String)requestPayload.encodePrettily());
        cReq.setTimeout(120000L);
        cReq.headers().setAll(req.headers());
        cReq.headers().set(SELF_REQUEST_HEADER, "true");
        cReq.headers().set("Content-Type", "application/json; charset=utf-8");
        cReq.headers().set("Content-Length", "" + payload.length());
        cReq.setChunked(false);
        cReq.write(payload);
        cReq.end();
    }

    private void makeResourceSubRequest(String targetUri, HttpServerRequest req, int recursionLevel, AtomicInteger subRequestCounter, RecursiveHandlerFactory.RecursiveHandlerTypes recursionHandlerType, DeltaHandler<ResourceNode> handler, boolean collection) {
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        if (subRequestCounter.get() > this.maxSubRequestCount) {
            handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException("Number of allowed sub requests exceeded. Limit is " + this.maxSubRequestCount + " requests", StatusCode.BAD_REQUEST)));
            return;
        }
        subRequestCounter.incrementAndGet();
        HttpClientRequest cReq = this.httpClient.request(HttpMethod.GET, targetUri, cRes -> {
            if (log.isTraceEnabled()) {
                log.trace(" x-delta for " + targetUri + " is " + cRes.headers().get("x-delta"));
            }
            handler.storeXDeltaResponseHeader(cRes.headers().get("x-delta"));
            cRes.bodyHandler(data -> {
                String eTag = this.geteTag(cRes.headers());
                if (StatusCode.NOT_FOUND.getStatusCode() == cRes.statusCode()) {
                    log.debug("requested resource could not be found: " + targetUri);
                    handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.NOT_FOUND)));
                } else if (StatusCode.INTERNAL_SERVER_ERROR.getStatusCode() == cRes.statusCode()) {
                    log.debug("error in request resource : " + targetUri);
                    handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.INTERNAL_SERVER_ERROR)));
                } else if (collection) {
                    try {
                        this.handleCollectionResource(this.removeParameters(targetUri), req, recursionLevel, subRequestCounter, recursionHandlerType, handler, (Buffer)data, eTag);
                    }
                    catch (ResourceCollectionException e) {
                        if (log.isTraceEnabled()) {
                            log.trace("handling collection failed with: " + e.getMessage());
                        }
                        this.handleSimpleResource(this.removeParameters(targetUri), handler, (Buffer)data, eTag);
                    }
                } else {
                    this.handleSimpleResource(this.removeParameters(targetUri), handler, (Buffer)data, eTag);
                }
            });
        });
        if (log.isTraceEnabled()) {
            log.trace("set the cReq headers for the subRequest");
        }
        cReq.setTimeout(120000L);
        cReq.headers().setAll(req.headers());
        cReq.headers().set("Accept", "application/json");
        cReq.headers().set(SELF_REQUEST_HEADER, "true");
        cReq.setChunked(true);
        cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)req, (String)targetUri, ExpansionHandler.class));
        if (log.isTraceEnabled()) {
            log.trace("end the cReq for the subRequest");
        }
        cReq.end();
    }

    private void handleSimpleResource(String targetUri, Handler<ResourceNode> handler, Buffer data, String eTag) {
        String resourceName = ExpansionDeltaUtil.extractCollectionFromPath((String)targetUri);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Simple resource: " + resourceName);
        }
        handler.handle((Object)new ResourceNode(resourceName, data, eTag, targetUri));
    }

    private String removeParameters(String targetUri) {
        int parameterIndex = targetUri.lastIndexOf(63);
        if (parameterIndex != -1) {
            return targetUri.substring(0, parameterIndex);
        }
        return targetUri;
    }

    private void respondBadRequest(HttpServerRequest request, String body) {
        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.BAD_REQUEST, ExpansionHandler.class);
        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
        request.response().end(body);
        request.resume();
    }

    private void handleCollectionResource(String targetUri, HttpServerRequest req, int recursionLevel, AtomicInteger subRequestCounter, RecursiveHandlerFactory.RecursiveHandlerTypes recursionHandlerType, DeltaHandler<ResourceNode> handler, Buffer data, String eTag) throws ResourceCollectionException {
        List subResourceNames;
        ExpansionDeltaUtil.CollectionResourceContainer collectionResourceContainer = ExpansionDeltaUtil.verifyCollectionResponse((String)targetUri, (Buffer)data, null);
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        if (log.isTraceEnabled()) {
            log.trace("Collection resource: " + collectionResourceContainer.getCollectionName());
            log.trace("actual recursion level: " + recursionLevel);
        }
        if ((subResourceNames = collectionResourceContainer.getResourceNames()).size() == 0) {
            if (log.isTraceEnabled()) {
                log.trace("No sub resource available for: " + collectionResourceContainer.getCollectionName());
            }
            ResourceNode node = new ResourceNode(collectionResourceContainer.getCollectionName(), new JsonArray(), eTag);
            handler.handle(node);
        } else {
            boolean maxRecursionLevelReached;
            boolean bl = maxRecursionLevelReached = recursionLevel == 0;
            if (!maxRecursionLevelReached) {
                if (log.isTraceEnabled()) {
                    log.trace("max. recursion reached for " + collectionResourceContainer.getCollectionName());
                }
                DeltaHandler<ResourceNode> parentHandler = RecursiveHandlerFactory.createHandler(recursionHandlerType, subResourceNames, collectionResourceContainer.getCollectionName(), eTag, handler);
                if (this.isStorageExpand(targetUri)) {
                    this.makeStorageExpandRequest(targetUri, subResourceNames, req, handler);
                } else {
                    for (String childResourceName : subResourceNames) {
                        if (log.isTraceEnabled()) {
                            log.trace("processing child resource: " + childResourceName);
                        }
                        boolean collection = this.isCollection(childResourceName);
                        String collectionURI = ExpansionDeltaUtil.constructRequestUri((String)targetUri, (MultiMap)req.params(), this.parameter_to_remove_after_initial_request, (String)childResourceName, (ExpansionDeltaUtil.SlashHandling)ExpansionDeltaUtil.SlashHandling.END_WITHOUT_SLASH);
                        this.makeResourceSubRequest(collection ? collectionURI : this.removeParameters(collectionURI), req, recursionLevel - 1, subRequestCounter, recursionHandlerType, parentHandler, collection);
                    }
                }
            } else {
                JsonArray jsonArray = new JsonArray();
                for (String childResourceName : subResourceNames) {
                    if (log.isTraceEnabled()) {
                        log.trace("(max level reached) processing child resource: " + childResourceName);
                    }
                    jsonArray.add(childResourceName);
                }
                handler.handle(new ResourceNode(collectionResourceContainer.getCollectionName(), jsonArray, eTag));
            }
        }
    }

    public boolean isCollection(String target) {
        return target.endsWith("/");
    }

    private String geteTag(MultiMap headers) {
        return headers != null && headers.contains(ETAG_HEADER) ? headers.get(ETAG_HEADER) : "";
    }
}

