/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import java.util.List;
import java.util.Set;
import org.swisspush.gateleen.expansion.DeltaHandler;
import org.swisspush.gateleen.expansion.RecursiveExpansionHandler;
import org.swisspush.gateleen.expansion.RecursiveExpansionRootHandler;
import org.swisspush.gateleen.expansion.RecursiveZipHandler;
import org.swisspush.gateleen.expansion.RecursiveZipRootHandler;
import org.swisspush.gateleen.expansion.ResourceNode;

public final class RecursiveHandlerFactory {
    private RecursiveHandlerFactory() {
    }

    public static DeltaHandler<ResourceNode> createHandler(RecursiveHandlerTypes type, List<String> subResourceNames, String collectionName, String collectioneTag, DeltaHandler<ResourceNode> parentHandler) {
        switch (type) {
            case EXPANSION: {
                return new RecursiveExpansionHandler(subResourceNames, collectionName, collectioneTag, parentHandler);
            }
            case ZIP: 
            case STORE: {
                return new RecursiveZipHandler(subResourceNames, collectionName, parentHandler);
            }
        }
        return null;
    }

    public static DeltaHandler<ResourceNode> createRootHandler(RecursiveHandlerTypes type, HttpServerRequest request, String serverRoot, Buffer data, Set<String> finalOriginalParams) {
        switch (type) {
            case EXPANSION: {
                return new RecursiveExpansionRootHandler(request, data, finalOriginalParams);
            }
            case ZIP: 
            case STORE: {
                return new RecursiveZipRootHandler(request, serverRoot, data, finalOriginalParams, type);
            }
        }
        return null;
    }

    public static enum RecursiveHandlerTypes {
        EXPANSION,
        ZIP,
        STORE;

    }
}

