/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ExpansionDeltaUtil;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.expansion.DeltaHandler;
import org.swisspush.gateleen.expansion.RecursiveHandlerFactory;
import org.swisspush.gateleen.expansion.ResourceNode;
import org.swisspush.gateleen.routing.Rule;
import org.swisspush.gateleen.routing.RuleFeatures;
import org.swisspush.gateleen.routing.RuleFeaturesProvider;
import org.swisspush.gateleen.routing.RuleProvider;

public class ExpansionHandler
implements RuleProvider.RuleChangesObserver {
    private Logger log = LoggerFactory.getLogger(ExpansionHandler.class);
    public static final String SERIOUS_EXCEPTION = "a serious exception happend ";
    public static final String EXPAND_PARAM = "expand";
    public static final String ZIP_PARAM = "zip";
    private static final int NO_PARAMETER_FOUND = -1;
    private static final int START_INDEX = 0;
    private static final int TIMEOUT = 120000;
    private static final int DECREMENT_BY_ONE = 1;
    private static final int MAX_RECURSION_LEVEL = 0;
    private static final String EXPAND_REQUEST_METRIC = "gateleen.expand.requests";
    private static final String STORAGE_EXPAND_REQUEST_METRIC = "gateleen.storage.expand.requests";
    private static final String LEVEL = "level";
    public static final String MAX_EXPANSION_LEVEL_SOFT_PROPERTY = "max.expansion.level.soft";
    public static final String MAX_EXPANSION_LEVEL_HARD_PROPERTY = "max.expansion.level.hard";
    public static final String MAX_SUBREQUEST_PROPERTY = "max.expansion.subrequests";
    private static final int MAX_SUBREQUEST_COUNT_DEFAULT = 20000;
    private static final String ETAG_HEADER = "Etag";
    private static final String SELF_REQUEST_HEADER = "x-self-request";
    private static final Handler<Buffer> DEV_NULL = buf -> {};
    private int maxSubRequestCount;
    private int maxExpansionLevelSoft = Integer.MAX_VALUE;
    private int maxExpansionLevelHard = Integer.MAX_VALUE;
    private HttpClient httpClient;
    private Map<String, Object> properties;
    private String serverRoot;
    private RuleProvider ruleProvider;
    private List<String> parameter_to_remove_for_all_request;
    private List<String> parameter_to_remove_after_initial_request;
    private RuleFeaturesProvider ruleFeaturesProvider = new RuleFeaturesProvider(new ArrayList());
    private final Map<Integer, Counter> counterMap = new HashMap<Integer, Counter>();
    private Counter storageExpandCounter;

    public ExpansionHandler(RuleProvider ruleProvider, HttpClient httpClient, Map<String, Object> properties, String serverRoot) {
        this.httpClient = httpClient;
        this.properties = properties;
        this.serverRoot = serverRoot;
        this.initParameterRemovalLists();
        this.initConfigurationValues();
        this.ruleProvider = ruleProvider;
        this.ruleProvider.registerObserver((RuleProvider.RuleChangesObserver)this);
    }

    public ExpansionHandler(Vertx vertx, ResourceStorage storage, HttpClient httpClient, Map<String, Object> properties, String serverRoot, String rulesPath) {
        this(new RuleProvider(vertx, rulesPath, storage, properties), httpClient, properties, serverRoot);
    }

    public void rulesChanged(List<Rule> rules) {
        this.log.info("Update expandOnBackend and storageExpand information from changed routing rules");
        this.ruleFeaturesProvider = new RuleFeaturesProvider(rules);
    }

    public int getMaxExpansionLevelSoft() {
        return this.maxExpansionLevelSoft;
    }

    public int getMaxExpansionLevelHard() {
        return this.maxExpansionLevelHard;
    }

    public int getMaxSubRequestCount() {
        return this.maxSubRequestCount;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.counterMap.clear();
        if (meterRegistry != null) {
            this.counterMap.put(0, Counter.builder((String)EXPAND_REQUEST_METRIC).tag(LEVEL, "0").register(meterRegistry));
            this.counterMap.put(1, Counter.builder((String)EXPAND_REQUEST_METRIC).tag(LEVEL, "1").register(meterRegistry));
            this.counterMap.put(2, Counter.builder((String)EXPAND_REQUEST_METRIC).tag(LEVEL, "2").register(meterRegistry));
            this.counterMap.put(3, Counter.builder((String)EXPAND_REQUEST_METRIC).tag(LEVEL, "3").register(meterRegistry));
            this.counterMap.put(4, Counter.builder((String)EXPAND_REQUEST_METRIC).tag(LEVEL, "4").register(meterRegistry));
            this.storageExpandCounter = Counter.builder((String)STORAGE_EXPAND_REQUEST_METRIC).register(meterRegistry);
        }
    }

    private void incrementExpandReqCount(int level) {
        Counter counter = this.counterMap.get(level);
        if (counter != null) {
            counter.increment();
        }
    }

    private void initParameterRemovalLists() {
        this.parameter_to_remove_for_all_request = new ArrayList<String>();
        this.parameter_to_remove_after_initial_request = new ArrayList<String>();
        this.parameter_to_remove_for_all_request.add(EXPAND_PARAM);
        this.parameter_to_remove_after_initial_request.addAll(this.parameter_to_remove_for_all_request);
        this.parameter_to_remove_after_initial_request.add("limit");
        this.parameter_to_remove_after_initial_request.add("offset");
    }

    private void initConfigurationValues() {
        if (this.properties != null && this.properties.containsKey(MAX_SUBREQUEST_PROPERTY)) {
            try {
                this.maxSubRequestCount = Integer.parseInt((String)this.properties.get(MAX_SUBREQUEST_PROPERTY));
                this.log.info("Setting maximum allowed subrequest count to {} from properties", (Object)this.maxSubRequestCount);
            }
            catch (Exception e) {
                this.maxSubRequestCount = 20000;
                this.log.warn("Setting maximum allowed subrequest count to a default of {}, since defined value for {} in properties is not a number", (Object)this.maxSubRequestCount, (Object)MAX_SUBREQUEST_PROPERTY);
            }
        } else {
            this.maxSubRequestCount = 20000;
            this.log.warn("Setting maximum allowed subrequest count to a default of {}, since no property {} is defined!", (Object)this.maxSubRequestCount, (Object)MAX_SUBREQUEST_PROPERTY);
        }
        if (this.properties != null && this.properties.containsKey(MAX_EXPANSION_LEVEL_SOFT_PROPERTY)) {
            try {
                this.maxExpansionLevelSoft = Integer.parseInt((String)this.properties.get(MAX_EXPANSION_LEVEL_SOFT_PROPERTY));
                this.log.info("Setting maximum expansion level soft value to {} from properties", (Object)this.maxExpansionLevelSoft);
            }
            catch (Exception e) {
                this.log.warn("Setting maximum expansion level soft value to a default of {}, since defined value for {} in properties is not a number", (Object)this.maxExpansionLevelSoft, (Object)MAX_EXPANSION_LEVEL_SOFT_PROPERTY);
            }
        } else {
            this.log.info("Setting maximum expansion level soft value to a default of {}, since no property {} is defined!", (Object)this.maxExpansionLevelSoft, (Object)MAX_EXPANSION_LEVEL_SOFT_PROPERTY);
        }
        if (this.properties != null && this.properties.containsKey(MAX_EXPANSION_LEVEL_HARD_PROPERTY)) {
            try {
                this.maxExpansionLevelHard = Integer.parseInt((String)this.properties.get(MAX_EXPANSION_LEVEL_HARD_PROPERTY));
                this.log.info("Setting maximum expansion level hard value to {} from properties", (Object)this.maxExpansionLevelHard);
            }
            catch (Exception e) {
                this.log.warn("Setting maximum expansion level hard value to a default of {}, since defined value for {} in properties is not a number", (Object)this.maxExpansionLevelHard, (Object)MAX_EXPANSION_LEVEL_HARD_PROPERTY);
            }
        } else {
            this.log.info("Setting maximum expansion level soft hard to a default of {}, since no property {} is defined!", (Object)this.maxExpansionLevelHard, (Object)MAX_EXPANSION_LEVEL_HARD_PROPERTY);
        }
    }

    public boolean isExpansionRequest(HttpServerRequest request) {
        return HttpMethod.GET == request.method() && request.params().contains(EXPAND_PARAM) && !this.isBackendExpand(request.uri());
    }

    protected boolean isBackendExpand(String uri) {
        return this.ruleFeaturesProvider.isFeatureRequest(RuleFeatures.Feature.EXPAND_ON_BACKEND, uri);
    }

    protected boolean isStorageExpand(String uri) {
        return this.ruleFeaturesProvider.isFeatureRequest(RuleFeatures.Feature.STORAGE_EXPAND, uri);
    }

    public boolean isZipRequest(HttpServerRequest request) {
        boolean ok = false;
        if (HttpMethod.GET == request.method() && request.params().contains(ZIP_PARAM)) {
            ok = !request.params().get(ZIP_PARAM).equalsIgnoreCase("false");
        }
        return ok && !this.isBackendExpand(request.uri());
    }

    private void handleExpansionRequest(HttpServerRequest req, RecursiveHandlerFactory.RecursiveHandlerTypes recursiveHandlerType) {
        req.pause();
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        Integer expandLevel = this.extractExpandParamValue(req, log);
        if (expandLevel == null) {
            this.respondBadRequest(req, "Expand parameter is not valid. Must be a positive number");
            return;
        }
        if (expandLevel > this.maxExpansionLevelHard) {
            String message = "Expand level '" + expandLevel + "' is greater than the maximum expand level '" + this.maxExpansionLevelHard + "'";
            log.info(message);
            this.respondBadRequest(req, message);
            return;
        }
        if (expandLevel > this.maxExpansionLevelSoft) {
            log.warn("Expand level '{}' is greater than the maximum soft expand level '{}'. Using '{}' instead", new Object[]{expandLevel, this.maxExpansionLevelSoft, this.maxExpansionLevelSoft});
            expandLevel = this.maxExpansionLevelSoft;
        }
        if (this.isStorageExpand(req.uri()) && expandLevel > 1) {
            this.respondBadRequest(req, "Expand values higher than 1 are not supported for storageExpand requests");
            return;
        }
        Set originalParams = null;
        if (req.params() != null) {
            originalParams = req.params().names();
        }
        Set finalOriginalParams = originalParams;
        String targetUri = ExpansionDeltaUtil.constructRequestUri((String)req.path(), (MultiMap)req.params(), this.parameter_to_remove_for_all_request, null, (ExpansionDeltaUtil.SlashHandling)ExpansionDeltaUtil.SlashHandling.END_WITH_SLASH);
        log.debug("constructed uri for request: {}", (Object)targetUri);
        Integer finalExpandLevel = expandLevel;
        this.incrementExpandReqCount(finalExpandLevel);
        this.httpClient.request(HttpMethod.GET, targetUri).onComplete(asyncReqResult -> {
            if (asyncReqResult.failed()) {
                log.warn("Failed request to {}: {}", (Object)targetUri, (Object)asyncReqResult.cause());
                return;
            }
            HttpClientRequest cReq = (HttpClientRequest)asyncReqResult.result();
            Handler resultHandler = asyncResult -> {
                HttpClientResponse cRes = (HttpClientResponse)asyncResult.result();
                HttpServerRequestUtil.prepareResponse((HttpServerRequest)req, (HttpClientResponse)cRes);
                if (log.isTraceEnabled()) {
                    log.trace(" x-delta for {} is {}", (Object)targetUri, (Object)cRes.headers().get("x-delta"));
                }
                cRes.bodyHandler(data -> this.makeResourceSubRequest(targetUri, req, finalExpandLevel, new AtomicInteger(), recursiveHandlerType, RecursiveHandlerFactory.createRootHandler(recursiveHandlerType, req, this.serverRoot, data, finalOriginalParams), true));
                cRes.exceptionHandler(ExpansionDeltaUtil.createResponseExceptionHandler((HttpServerRequest)req, (String)targetUri, ExpansionHandler.class));
            };
            if (log.isTraceEnabled()) {
                log.trace("set cReq headers");
            }
            cReq.idleTimeout(120000L);
            cReq.headers().setAll(req.headers());
            cReq.headers().set("Accept", "application/json");
            cReq.headers().set(SELF_REQUEST_HEADER, "true");
            cReq.setChunked(true);
            if (log.isTraceEnabled()) {
                log.trace("set request data handler");
            }
            req.handler(data -> {
                if (log.isTraceEnabled()) {
                    log.trace("write data of the last subrequest");
                }
                cReq.write(data);
            });
            if (log.isTraceEnabled()) {
                log.trace("set request end handler");
            }
            req.endHandler(v -> {
                cReq.send(resultHandler);
                log.debug("Request done");
            });
            cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)req, (String)targetUri, ExpansionHandler.class));
            if (log.isTraceEnabled()) {
                log.trace("resume request");
            }
            req.resume();
        });
    }

    private Integer extractExpandParamValue(HttpServerRequest request, Logger log) {
        String expandValue = request.params().get(EXPAND_PARAM);
        log.debug("got expand parameter value {}", (Object)expandValue);
        try {
            int value = Integer.parseInt(expandValue);
            if (value < 0) {
                log.warn("expand parameter value '{}' is not a positive number", (Object)expandValue);
                return null;
            }
            return value;
        }
        catch (NumberFormatException ex) {
            log.warn("expand parameter value '{}' is not a valid number", (Object)expandValue);
            return null;
        }
    }

    public void handleExpansionRecursion(HttpServerRequest request) {
        this.removeZipParameter(request);
        this.handleExpansionRequest(request, RecursiveHandlerFactory.RecursiveHandlerTypes.EXPANSION);
    }

    public void handleZipRecursion(HttpServerRequest request) {
        RecursiveHandlerFactory.RecursiveHandlerTypes zipType = RecursiveHandlerFactory.RecursiveHandlerTypes.ZIP;
        try {
            zipType = RecursiveHandlerFactory.RecursiveHandlerTypes.valueOf(request.params().get(ZIP_PARAM).toUpperCase());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("currently using zip mode: {}", (Object)zipType);
        }
        this.removeZipParameter(request);
        this.handleExpansionRequest(request, zipType);
    }

    private void removeZipParameter(HttpServerRequest request) {
        if (request.params().contains(ZIP_PARAM)) {
            request.params().remove(ZIP_PARAM);
        }
    }

    private void makeStorageExpandRequest(String targetUri, List subResourceNames, HttpServerRequest req, DeltaHandler<ResourceNode> handler) {
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        HttpMethod reqMethod = HttpMethod.POST;
        String reqUri = targetUri + "?storageExpand=true";
        if (this.storageExpandCounter != null) {
            this.storageExpandCounter.increment();
        }
        this.httpClient.request(reqMethod, reqUri).onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                log.warn("Failed request to {}", (Object)reqUri, (Object)asyncResult.cause());
                return;
            }
            HttpClientRequest cReq = (HttpClientRequest)asyncResult.result();
            JsonObject requestPayload = new JsonObject();
            requestPayload.put("subResources", (Object)new JsonArray(subResourceNames));
            Buffer payload = Buffer.buffer((String)requestPayload.encodePrettily());
            cReq.idleTimeout(120000L);
            cReq.headers().setAll(req.headers());
            cReq.headers().set(SELF_REQUEST_HEADER, "true");
            cReq.headers().set("Content-Type", "application/json; charset=utf-8");
            cReq.headers().set("Content-Length", "" + payload.length());
            cReq.setChunked(false);
            cReq.write((Object)payload);
            cReq.send(event -> {
                if (event.failed()) {
                    Throwable ex = event.cause();
                    log.debug("{} {}", new Object[]{reqMethod, reqUri, ex});
                    ResourceCollectionException exWrappr = new ResourceCollectionException(ex.getMessage(), StatusCode.INTERNAL_SERVER_ERROR);
                    handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)exWrappr));
                }
                HttpClientResponse cRes = (HttpClientResponse)event.result();
                if (StatusCode.NOT_FOUND.getStatusCode() == cRes.statusCode()) {
                    log.debug("NotFound: {}", (Object)targetUri);
                    cRes.handler(DEV_NULL);
                    handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.NOT_FOUND)));
                    return;
                }
                if (StatusCode.METHOD_NOT_ALLOWED.getStatusCode() == cRes.statusCode()) {
                    log.error("storageExpand not allowed for: {}", (Object)targetUri);
                    cRes.handler(DEV_NULL);
                    handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.METHOD_NOT_ALLOWED)));
                    return;
                }
                cRes.bodyHandler(data -> {
                    if (StatusCode.PAYLOAD_TOO_LARGE.getStatusCode() == cRes.statusCode()) {
                        String fullResponseBody = data.toString();
                        log.info("{}: {}: {}", new Object[]{StatusCode.PAYLOAD_TOO_LARGE, targetUri, fullResponseBody});
                        handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(fullResponseBody, StatusCode.PAYLOAD_TOO_LARGE)));
                    } else if (StatusCode.INTERNAL_SERVER_ERROR.getStatusCode() == cRes.statusCode()) {
                        String fullResponseBody = data.toString();
                        log.error("{}: {}: {}", new Object[]{StatusCode.INTERNAL_SERVER_ERROR, targetUri, fullResponseBody});
                        handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(fullResponseBody, StatusCode.INTERNAL_SERVER_ERROR)));
                    } else {
                        String eTag = this.geteTag(cRes.headers());
                        this.handleSimpleResource(this.removeParameters(targetUri), handler, (Buffer)data, eTag);
                    }
                });
            });
        });
    }

    private void makeResourceSubRequest(String targetUri, HttpServerRequest req, int recursionLevel, AtomicInteger subRequestCounter, RecursiveHandlerFactory.RecursiveHandlerTypes recursionHandlerType, DeltaHandler<ResourceNode> handler, boolean collection) {
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        if (subRequestCounter.get() > this.maxSubRequestCount) {
            handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException("Number of allowed sub requests exceeded. Limit is " + this.maxSubRequestCount + " requests", StatusCode.BAD_REQUEST)));
            return;
        }
        subRequestCounter.incrementAndGet();
        this.httpClient.request(HttpMethod.GET, targetUri).onComplete(asyncResult -> {
            if (asyncResult.failed()) {
                log.warn("Failed request to {}: {}", (Object)targetUri, (Object)asyncResult.cause());
                return;
            }
            HttpClientRequest cReq = (HttpClientRequest)asyncResult.result();
            if (log.isTraceEnabled()) {
                log.trace("set the cReq headers for the subRequest");
            }
            cReq.idleTimeout(120000L);
            cReq.headers().setAll(req.headers());
            cReq.headers().set("Accept", "application/json");
            cReq.headers().set(SELF_REQUEST_HEADER, "true");
            cReq.setChunked(true);
            cReq.exceptionHandler(ExpansionDeltaUtil.createRequestExceptionHandler((HttpServerRequest)req, (String)targetUri, ExpansionHandler.class));
            if (log.isTraceEnabled()) {
                log.trace("end the cReq for the subRequest");
            }
            cReq.send(event -> {
                HttpClientResponse cRes = (HttpClientResponse)event.result();
                if (log.isTraceEnabled()) {
                    log.trace(" x-delta for {} is {}", (Object)targetUri, (Object)cRes.headers().get("x-delta"));
                }
                handler.storeXDeltaResponseHeader(cRes.headers().get("x-delta"));
                cRes.bodyHandler(data -> {
                    String eTag = this.geteTag(cRes.headers());
                    if (StatusCode.NOT_FOUND.getStatusCode() == cRes.statusCode()) {
                        log.debug("requested resource could not be found: {}", (Object)targetUri);
                        handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.NOT_FOUND)));
                    } else if (StatusCode.INTERNAL_SERVER_ERROR.getStatusCode() == cRes.statusCode()) {
                        log.debug("error in request resource : {}", (Object)targetUri);
                        handler.handle(new ResourceNode(SERIOUS_EXCEPTION, (Object)new ResourceCollectionException(cRes.statusMessage(), StatusCode.INTERNAL_SERVER_ERROR)));
                    } else if (collection) {
                        try {
                            this.handleCollectionResource(this.removeParameters(targetUri), req, recursionLevel, subRequestCounter, recursionHandlerType, handler, (Buffer)data, eTag);
                        }
                        catch (ResourceCollectionException e) {
                            if (log.isTraceEnabled()) {
                                log.trace("handling collection failed with: {}", (Object)e.getMessage());
                            }
                            this.handleSimpleResource(this.removeParameters(targetUri), handler, (Buffer)data, eTag);
                        }
                    } else {
                        this.handleSimpleResource(this.removeParameters(targetUri), handler, (Buffer)data, eTag);
                    }
                });
            });
        });
    }

    private void handleSimpleResource(String targetUri, Handler<ResourceNode> handler, Buffer data, String eTag) {
        String resourceName = ExpansionDeltaUtil.extractCollectionFromPath((String)targetUri);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Simple resource: {}", (Object)resourceName);
        }
        handler.handle((Object)new ResourceNode(resourceName, data, eTag, targetUri));
    }

    private String removeParameters(String targetUri) {
        int parameterIndex = targetUri.lastIndexOf(63);
        if (parameterIndex != -1) {
            return targetUri.substring(0, parameterIndex);
        }
        return targetUri;
    }

    private void respondBadRequest(HttpServerRequest request, String body) {
        ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.BAD_REQUEST, ExpansionHandler.class);
        request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
        request.response().end(body);
        request.resume();
    }

    private void handleCollectionResource(String targetUri, HttpServerRequest req, int recursionLevel, AtomicInteger subRequestCounter, RecursiveHandlerFactory.RecursiveHandlerTypes recursionHandlerType, DeltaHandler<ResourceNode> handler, Buffer data, String eTag) throws ResourceCollectionException {
        List subResourceNames;
        ExpansionDeltaUtil.CollectionResourceContainer collectionResourceContainer = ExpansionDeltaUtil.verifyCollectionResponse((String)targetUri, (Buffer)data, null);
        Logger log = RequestLoggerFactory.getLogger(ExpansionHandler.class, (HttpServerRequest)req);
        if (log.isTraceEnabled()) {
            log.trace("Collection resource: {}", (Object)collectionResourceContainer.getCollectionName());
            log.trace("actual recursion level: {}", (Object)recursionLevel);
        }
        if ((subResourceNames = collectionResourceContainer.getResourceNames()).size() == 0) {
            if (log.isTraceEnabled()) {
                log.trace("No sub resource available for: {}", (Object)collectionResourceContainer.getCollectionName());
            }
            ResourceNode node = new ResourceNode(collectionResourceContainer.getCollectionName(), new JsonArray(), eTag);
            handler.handle(node);
        } else {
            boolean maxRecursionLevelReached;
            boolean bl = maxRecursionLevelReached = recursionLevel == 0;
            if (!maxRecursionLevelReached) {
                if (log.isTraceEnabled()) {
                    log.trace("max. recursion reached for {}", (Object)collectionResourceContainer.getCollectionName());
                }
                DeltaHandler<ResourceNode> parentHandler = RecursiveHandlerFactory.createHandler(recursionHandlerType, subResourceNames, collectionResourceContainer.getCollectionName(), eTag, handler);
                if (this.isStorageExpand(targetUri)) {
                    this.makeStorageExpandRequest(targetUri, subResourceNames, req, handler);
                } else {
                    for (String childResourceName : subResourceNames) {
                        if (log.isTraceEnabled()) {
                            log.trace("processing child resource: {}", (Object)childResourceName);
                        }
                        boolean collection = this.isCollection(childResourceName);
                        String collectionURI = ExpansionDeltaUtil.constructRequestUri((String)targetUri, (MultiMap)req.params(), this.parameter_to_remove_after_initial_request, (String)childResourceName, (ExpansionDeltaUtil.SlashHandling)ExpansionDeltaUtil.SlashHandling.END_WITHOUT_SLASH);
                        this.makeResourceSubRequest(collection ? collectionURI : this.removeParameters(collectionURI), req, recursionLevel - 1, subRequestCounter, recursionHandlerType, parentHandler, collection);
                    }
                }
            } else {
                JsonArray jsonArray = new JsonArray();
                for (String childResourceName : subResourceNames) {
                    if (log.isTraceEnabled()) {
                        log.trace("(max level reached) processing child resource: {}", (Object)childResourceName);
                    }
                    jsonArray.add((Object)childResourceName);
                }
                handler.handle(new ResourceNode(collectionResourceContainer.getCollectionName(), jsonArray, eTag));
            }
        }
    }

    public boolean isCollection(String target) {
        return target.endsWith("/");
    }

    private String geteTag(MultiMap headers) {
        return headers != null && headers.contains(ETAG_HEADER) ? headers.get(ETAG_HEADER) : "";
    }
}

