/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.expansion.DeltaHandler;
import org.swisspush.gateleen.expansion.ResourceNode;

public class RecursiveExpansionHandler
implements DeltaHandler<ResourceNode> {
    private static final int PROCESS_DONE = 0;
    private Logger log = LoggerFactory.getLogger(RecursiveExpansionHandler.class);
    private ResourceNode seriousError;
    private AtomicInteger processCount;
    private String collectionName;
    private DeltaHandler<ResourceNode> parentHandler;
    private Map<String, ResourceNode> nodeMap;
    private String collectioneTag;
    private Map<String, ResourceCollectionException> resourceCollectionExceptionMap;
    private AtomicLong xDeltaResponseNumber;

    public RecursiveExpansionHandler(List<String> subResourceNames, String collectionName, String collectioneTag, DeltaHandler<ResourceNode> parentHandler) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("RecursiveExpansionHandler created for collection '{}' with a child count of {}.", (Object)collectionName, (Object)subResourceNames.size());
        }
        this.xDeltaResponseNumber = new AtomicLong(0L);
        this.processCount = new AtomicInteger(subResourceNames.size());
        this.parentHandler = parentHandler;
        this.collectionName = collectionName;
        this.collectioneTag = collectioneTag;
        this.resourceCollectionExceptionMap = new HashMap<String, ResourceCollectionException>();
        this.nodeMap = this.createEmptyNodeMap(subResourceNames);
    }

    private Map<String, ResourceNode> createEmptyNodeMap(List<String> subResourceNames) {
        LinkedHashMap<String, ResourceNode> map = new LinkedHashMap<String, ResourceNode>(subResourceNames.size());
        for (String resourceName : subResourceNames) {
            map.put(resourceName.replace("/", ""), null);
        }
        return map;
    }

    public void handle(ResourceNode node) {
        this.processCount.decrementAndGet();
        if (node != null) {
            if (node.getObject() instanceof Buffer) {
                try {
                    node.setObject(new JsonObject(((Buffer)node.getObject()).toString("UTF-8")));
                }
                catch (Exception e) {
                    this.log.error("Error in result of sub resource with path '{}' Message: {}", (Object)node.getPath(), (Object)e.getMessage());
                    node.setObject(new ResourceCollectionException(e.getMessage()));
                }
            }
            if (node.getObject() instanceof JsonObject || node.getObject() instanceof JsonArray) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("handle collection '{}' for node '{}'.", (Object)this.collectionName, (Object)node.getNodeName());
                }
                this.nodeMap.put(node.getNodeName(), node);
            } else if (node.getObject() instanceof ResourceCollectionException) {
                if (node.getNodeName().equals("a serious exception happend ")) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("(serious error) handle collection '{}'.", (Object)this.collectionName);
                    }
                    if (this.seriousError == null) {
                        this.seriousError = node;
                    }
                } else {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("(no serious error) handle collection '{}'.", (Object)this.collectionName);
                    }
                    this.resourceCollectionExceptionMap.put(node.getNodeName(), (ResourceCollectionException)node.getObject());
                }
            } else if (node.getObject() instanceof Map) {
                this.resourceCollectionExceptionMap.putAll((Map)node.getObject());
            } else if (this.log.isTraceEnabled()) {
                this.log.trace("No match found for handling node. This should not happen!");
            }
        }
        if (this.processCount.get() == 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("finishing process");
                this.log.trace(" -> serious error:    " + (this.seriousError != null));
                this.log.trace(" -> resource errors:  " + !this.resourceCollectionExceptionMap.isEmpty());
            }
            if (this.seriousError != null) {
                this.parentHandler.handle(this.seriousError);
            } else if (!this.resourceCollectionExceptionMap.isEmpty()) {
                this.parentHandler.handle(new ResourceNode(this.collectionName, this.resourceCollectionExceptionMap));
            } else {
                StringBuilder eTags = new StringBuilder();
                eTags.append(this.collectioneTag);
                JsonObject nodes = new JsonObject();
                for (String key : this.nodeMap.keySet()) {
                    ResourceNode orderedNode = this.nodeMap.get(key);
                    eTags.append(orderedNode.geteTag());
                    nodes.put(key, orderedNode.getObject());
                }
                this.parentHandler.storeXDeltaResponseHeader("" + this.xDeltaResponseNumber.get());
                this.parentHandler.handle(new ResourceNode(this.collectionName, nodes, eTags.toString()));
            }
        }
    }

    @Override
    public void storeXDeltaResponseHeader(String xDeltaResponseNumber) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("storeXDeltaResponseHeader > {}", (Object)xDeltaResponseNumber);
        }
        if (xDeltaResponseNumber != null) {
            try {
                long tempxDeltaResponseNumber = Long.parseLong(xDeltaResponseNumber);
                if (this.xDeltaResponseNumber.get() < tempxDeltaResponseNumber) {
                    this.xDeltaResponseNumber.set(tempxDeltaResponseNumber);
                }
            }
            catch (NumberFormatException e) {
                this.log.warn("Delta response value was not a number", (Throwable)e);
            }
        }
    }
}

