/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.expansion;

import io.vertx.core.http.HttpServerRequest;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.ResourceCollectionException;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.expansion.DeltaHandler;
import org.swisspush.gateleen.expansion.ResourceNode;

public abstract class RecursiveRootHandlerBase
implements DeltaHandler<ResourceNode> {
    protected static final Logger log = LoggerFactory.getLogger(RecursiveRootHandlerBase.class);
    protected AtomicLong xDeltaResponseNumber = new AtomicLong(0L);

    void handleResponseError(HttpServerRequest req, ResourceCollectionException exception) {
        if (log.isTraceEnabled()) {
            log.trace("got a ResourceCollectionException: {}", (Object)exception.getMessage());
        }
        ResponseStatusCodeLogUtil.debug((HttpServerRequest)req, (StatusCode)exception.getStatusCode(), RecursiveRootHandlerBase.class);
        req.response().setStatusCode(exception.getStatusCode().getStatusCode());
        req.response().setStatusMessage(exception.getStatusCode().getStatusMessage());
        req.response().putHeader("Content-Type", "text/plain");
        req.response().end(exception.getMessage());
    }

    void checkIfError(ResourceNode node) throws ResourceCollectionException {
        if (node.getObject() != null) {
            if (node.getObject() instanceof ResourceCollectionException) {
                throw (ResourceCollectionException)node.getObject();
            }
            if (node.getObject() instanceof Map) {
                Map errorMap = (Map)node.getObject();
                StringBuilder errorMessage = new StringBuilder("Errors found in resources:\n");
                for (String resource : errorMap.keySet()) {
                    errorMessage.append(resource).append(": ").append(((ResourceCollectionException)errorMap.get(resource)).getMessage()).append("\n");
                }
                if (!errorMap.isEmpty()) {
                    throw new ResourceCollectionException(errorMessage.toString(), StatusCode.INTERNAL_SERVER_ERROR);
                }
            }
        }
    }

    @Override
    public void storeXDeltaResponseHeader(String xDeltaResponseNumber) {
        if (log.isTraceEnabled()) {
            log.trace(" (root) storeXDeltaResponseHeader > {}", (Object)xDeltaResponseNumber);
        }
        if (xDeltaResponseNumber != null) {
            try {
                long tempxDeltaResponseNumber = Long.parseLong(xDeltaResponseNumber);
                if (this.xDeltaResponseNumber.get() < tempxDeltaResponseNumber) {
                    this.xDeltaResponseNumber.set(tempxDeltaResponseNumber);
                }
            }
            catch (NumberFormatException e) {
                log.warn("Delta response value was not a number", (Throwable)e);
            }
        }
    }
}

