/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadablePartial;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.CollectionContentComparator;
import org.swisspush.gateleen.core.util.HttpRequestHeader;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.hook.HookTriggerType;
import org.swisspush.gateleen.hook.HttpHook;
import org.swisspush.gateleen.hook.Listener;
import org.swisspush.gateleen.hook.ListenerRepository;
import org.swisspush.gateleen.hook.LocalListenerRepository;
import org.swisspush.gateleen.hook.LocalRouteRepository;
import org.swisspush.gateleen.hook.Route;
import org.swisspush.gateleen.hook.RouteRepository;
import org.swisspush.gateleen.hook.queueingstrategy.DefaultQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.DiscardPayloadQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategyFactory;
import org.swisspush.gateleen.hook.queueingstrategy.ReducedPropagationQueueingStrategy;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationManager;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.expiry.ExpiryCheckHandler;
import org.swisspush.gateleen.queue.queuing.QueueClient;
import org.swisspush.gateleen.queue.queuing.RequestQueue;

public class HookHandler {
    public static final String HOOKED_HEADER = "x-hooked";
    public static final String HOOK_ROUTES_LISTED = "x-hook-routes-listed";
    public static final String HOOKS_LISTENERS_URI_PART = "/_hooks/listeners/";
    public static final String LISTENER_QUEUE_PREFIX = "listener-hook";
    private static final String LISTENER_HOOK_TARGET_PATH = "listeners/";
    public static final String HOOKS_ROUTE_URI_PART = "/_hooks/route";
    private static final String HOOK_STORAGE_PATH = "registrations/";
    private static final String HOOK_LISTENER_STORAGE_PATH = "registrations/listeners/";
    private static final String HOOK_ROUTE_STORAGE_PATH = "registrations/routes/";
    private static final String SAVE_LISTENER_ADDRESS = "gateleen.hook-listener-insert";
    private static final String REMOVE_LISTENER_ADDRESS = "gateleen.hook-listener-remove";
    private static final String SAVE_ROUTE_ADDRESS = "gateleen.hook-route-insert";
    private static final String REMOVE_ROUTE_ADDRESS = "gateleen.hook-route-remove";
    private static final int DEFAULT_HOOK_STORAGE_EXPIRE_AFTER_TIME = 3600;
    private static final int DEFAULT_HOOK_LISTENERS_EXPIRE_AFTER_TIME = 30;
    private static final int DEFAULT_CLEANUP_TIME = 15000;
    public static final String REQUESTURL = "requesturl";
    public static final String EXPIRATION_TIME = "expirationTime";
    public static final String HOOK = "hook";
    public static final String EXPIRE_AFTER = "expireAfter";
    public static final String QUEUE_EXPIRE_AFTER = "queueExpireAfter";
    public static final String STATIC_HEADERS = "staticHeaders";
    public static final String FULL_URL = "fullUrl";
    public static final String DISCARD_PAYLOAD = "discardPayload";
    public static final String HOOK_TRIGGER_TYPE = "type";
    public static final String LISTABLE = "listable";
    public static final String COLLECTION = "collection";
    private final Comparator<String> collectionContentComparator;
    private Logger log = LoggerFactory.getLogger(HookHandler.class);
    private Vertx vertx;
    private final ResourceStorage storage;
    private MonitoringHandler monitoringHandler;
    private LoggingResourceManager loggingResourceManager;
    private final HttpClient selfClient;
    private String userProfilePath;
    private String hookRootUri;
    private boolean listableRoutes;
    private ListenerRepository listenerRepository;
    private RouteRepository routeRepository;
    private RequestQueue requestQueue;
    private ReducedPropagationManager reducedPropagationManager;

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri) {
        this(vertx, selfClient, storage, loggingResourceManager, monitoringHandler, userProfilePath, hookRootUri, (RequestQueue)new QueueClient(vertx, monitoringHandler));
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue) {
        this(vertx, selfClient, storage, loggingResourceManager, monitoringHandler, userProfilePath, hookRootUri, requestQueue, false);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes) {
        this(vertx, selfClient, storage, loggingResourceManager, monitoringHandler, userProfilePath, hookRootUri, requestQueue, false, null);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes, ReducedPropagationManager reducedPropagationManager) {
        this.log.debug("Creating HookHandler ...");
        this.vertx = vertx;
        this.selfClient = selfClient;
        this.storage = storage;
        this.loggingResourceManager = loggingResourceManager;
        this.monitoringHandler = monitoringHandler;
        this.userProfilePath = userProfilePath;
        this.hookRootUri = hookRootUri;
        this.requestQueue = requestQueue;
        this.listableRoutes = listableRoutes;
        this.reducedPropagationManager = reducedPropagationManager;
        this.listenerRepository = new LocalListenerRepository();
        this.routeRepository = new LocalRouteRepository();
        this.collectionContentComparator = new CollectionContentComparator();
    }

    public void init() {
        this.registerListenerRegistrationHandler();
        this.registerRouteRegistrationHandler();
        this.loadStoredListeners();
        this.loadStoredRoutes();
        this.registerCleanupHandler();
    }

    private void registerCleanupHandler() {
        this.vertx.setPeriodic(15000L, (Handler)new Handler<Long>(){

            public void handle(Long timerID) {
                HookHandler.this.log.trace("Running hook cleanup ...");
                LocalDateTime nowAsTime = ExpiryCheckHandler.getActualTime();
                for (Listener listener : HookHandler.this.listenerRepository.getListeners()) {
                    if (!listener.getHook().getExpirationTime().isBefore((ReadablePartial)nowAsTime)) continue;
                    HookHandler.this.log.debug("Listener " + listener.getListenerId() + " expired at " + listener.getHook().getExpirationTime() + " and actual time is " + nowAsTime);
                    HookHandler.this.listenerRepository.removeListener(listener.getListenerId());
                    HookHandler.this.routeRepository.removeRoute(HookHandler.this.hookRootUri + HookHandler.LISTENER_HOOK_TARGET_PATH + listener.getListenerId());
                }
                Map<String, Route> routes = HookHandler.this.routeRepository.getRoutes();
                for (String key : routes.keySet()) {
                    Route route = routes.get(key);
                    if (!route.getHook().getExpirationTime().isBefore((ReadablePartial)nowAsTime)) continue;
                    HookHandler.this.routeRepository.removeRoute(key);
                }
                HookHandler.this.log.trace("done");
            }
        });
    }

    private void loadStoredRoutes() {
        this.log.debug("loadStoredRoutes");
        HttpClientRequest selfRequest = this.selfClient.request(HttpMethod.GET, this.hookRootUri + HOOK_ROUTE_STORAGE_PATH + "?expand=1", response -> {
            if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                this.makeResponse((HttpClientResponse)response);
            } else if (response.statusCode() == StatusCode.NOT_FOUND.getStatusCode()) {
                this.log.debug("No route previously stored");
            } else {
                this.log.error("Routes could not be loaded.");
            }
        });
        selfRequest.setTimeout(120000L);
        selfRequest.end();
    }

    private void makeResponse(HttpClientResponse response) {
        response.bodyHandler(event -> {
            JsonObject responseObject = new JsonObject(event.toString());
            if (responseObject.getValue("routes") instanceof JsonObject) {
                JsonObject routes = responseObject.getJsonObject("routes");
                for (String routeStorageId : routes.fieldNames()) {
                    this.log.info("Loading route with storage id: " + routeStorageId);
                    JsonObject storageObject = routes.getJsonObject(routeStorageId);
                    this.registerRoute(Buffer.buffer((String)storageObject.toString()));
                }
            } else {
                this.log.info("Currently are no routes stored!");
            }
        });
    }

    private void loadStoredListeners() {
        this.log.debug("loadStoredListeners");
        HttpClientRequest selfRequest = this.selfClient.request(HttpMethod.GET, this.hookRootUri + HOOK_LISTENER_STORAGE_PATH + "?expand=1", (Handler)new Handler<HttpClientResponse>(){

            public void handle(HttpClientResponse response) {
                if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                    response.bodyHandler((Handler)new Handler<Buffer>(){

                        public void handle(Buffer event) {
                            JsonObject responseObject = new JsonObject(event.toString());
                            if (responseObject.getValue("listeners") instanceof JsonObject) {
                                JsonObject listeners = responseObject.getJsonObject("listeners");
                                for (String listenerStorageId : listeners.fieldNames()) {
                                    HookHandler.this.log.info("Loading listener with storage id: " + listenerStorageId);
                                    JsonObject storageObject = listeners.getJsonObject(listenerStorageId);
                                    HookHandler.this.registerListener(Buffer.buffer((String)storageObject.toString()));
                                }
                            } else {
                                HookHandler.this.log.info("Currently are no listeners stored!");
                            }
                        }
                    });
                } else if (response.statusCode() == StatusCode.NOT_FOUND.getStatusCode()) {
                    HookHandler.this.log.debug("No listener previously stored");
                } else {
                    HookHandler.this.log.error("Listeners could not be loaded.");
                }
            }
        });
        selfRequest.setTimeout(120000L);
        selfRequest.end();
    }

    private void registerRouteRegistrationHandler() {
        this.vertx.eventBus().consumer(SAVE_ROUTE_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.storage.get((String)event.body(), buffer -> {
                    if (buffer != null) {
                        HookHandler.this.registerRoute(buffer);
                    } else {
                        HookHandler.this.log.warn("Could not get URL '" + (event.body() == null ? "<null>" : (String)event.body()) + "' (getting hook route).");
                    }
                });
            }
        });
        this.vertx.eventBus().consumer(REMOVE_ROUTE_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.unregisterRoute((String)event.body());
            }
        });
    }

    private void registerListenerRegistrationHandler() {
        this.vertx.eventBus().consumer(SAVE_LISTENER_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.storage.get((String)event.body(), buffer -> {
                    if (buffer != null) {
                        HookHandler.this.registerListener(buffer);
                    } else {
                        HookHandler.this.log.warn("Could not get URL '" + (event.body() == null ? "<null>" : (String)event.body()) + "' (getting hook listener).");
                    }
                });
            }
        });
        this.vertx.eventBus().consumer(REMOVE_LISTENER_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.unregisterListener((String)event.body());
            }
        });
    }

    public boolean handle(HttpServerRequest request) {
        boolean consumed = false;
        if (this.isHookListenerRegistration(request)) {
            this.handleListenerRegistration(request);
            return true;
        }
        if (this.isHookListenerUnregistration(request)) {
            this.handleListenerUnregistration(request);
            return true;
        }
        if (this.isHookRouteRegistration(request)) {
            this.handleRouteRegistration(request);
            return true;
        }
        if (this.isHookRouteUnregistration(request)) {
            this.handleRouteUnregistration(request);
            return true;
        }
        List<Listener> listeners = this.listenerRepository.findListeners(request.uri(), request.method().name());
        if (!listeners.isEmpty() && !this.isRequestAlreadyHooked(request)) {
            this.installBodyHandler(request, listeners);
            consumed = true;
        }
        if (!consumed) {
            consumed = this.routeRequestIfNeeded(request);
            if (!consumed) {
                return this.createListingIfRequested(request);
            }
            return consumed;
        }
        return true;
    }

    private boolean createListingIfRequested(HttpServerRequest request) {
        ArrayList<String> collections;
        boolean routesListed;
        String routesListedHeader = request.headers().get(HOOK_ROUTES_LISTED);
        boolean bl = routesListed = routesListedHeader != null && routesListedHeader.equals("true");
        if (request.method().equals((Object)HttpMethod.GET) && !routesListed && !(collections = new ArrayList<String>(this.routeRepository.getCollections(request.uri()))).isEmpty()) {
            String parentUri = request.uri().contains("?") ? request.uri().substring(0, request.uri().indexOf(63)) : request.uri();
            String parentCollection = this.getCollectionName(parentUri);
            collections.sort(this.collectionContentComparator);
            if (this.log.isTraceEnabled()) {
                this.log.trace("createListingIfRequested > (parentUri) {}, (parentCollection) {}", (Object)parentUri, (Object)parentCollection);
            }
            HttpClientRequest selfRequest = this.selfClient.request(request.method(), request.uri(), response -> {
                request.response().setStatusCode(response.statusCode());
                request.response().setStatusMessage(response.statusMessage());
                request.response().setChunked(true);
                request.response().headers().addAll(response.headers());
                request.response().headers().remove(HttpRequestHeader.CONTENT_LENGTH.getName());
                request.response().headers().remove(HOOK_ROUTES_LISTED);
                if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("createListingIfRequested > use existing array");
                    }
                    response.handler(data -> {
                        JsonObject responseObject = new JsonObject(data.toString());
                        if (responseObject.getValue(parentCollection) instanceof JsonArray) {
                            JsonArray parentCollectionArray = responseObject.getJsonArray(parentCollection);
                            collections.forEach(arg_0 -> ((JsonArray)parentCollectionArray).add(arg_0));
                        }
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("createListingIfRequested > response: {}", (Object)responseObject.toString());
                        }
                        request.response().write(Buffer.buffer((String)responseObject.toString()));
                    });
                } else if (response.statusCode() == StatusCode.NOT_FOUND.getStatusCode()) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("createListingIfRequested > creating new array");
                    }
                    response.handler(data -> {
                        request.response().setStatusCode(StatusCode.OK.getStatusCode());
                        request.response().setStatusMessage(StatusCode.OK.getStatusMessage());
                        JsonObject responseObject = new JsonObject();
                        JsonArray parentCollectionArray = new JsonArray();
                        responseObject.put(parentCollection, parentCollectionArray);
                        collections.forEach(arg_0 -> ((JsonArray)parentCollectionArray).add(arg_0));
                        if (this.log.isTraceEnabled()) {
                            this.log.trace("createListingIfRequested > response: {}", (Object)responseObject.toString());
                        }
                        request.response().write(Buffer.buffer((String)responseObject.toString()));
                    });
                } else {
                    this.log.debug("createListingIfRequested - got response - ERROR");
                    response.handler(data -> request.response().write(data));
                }
                response.endHandler(v -> request.response().end());
            });
            if (request.headers() != null && !request.headers().isEmpty()) {
                selfRequest.headers().setAll(request.headers());
            }
            selfRequest.headers().add(HOOK_ROUTES_LISTED, "true");
            selfRequest.exceptionHandler(exception -> this.log.warn("HookHandler: listing of collections (routes) failed: " + request.uri() + ": " + exception.getMessage()));
            selfRequest.setTimeout(120000L);
            selfRequest.end();
            return true;
        }
        return false;
    }

    private String getCollectionName(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf("/"));
        }
        return url.substring(url.lastIndexOf("/") + 1, url.length());
    }

    private boolean routeRequestIfNeeded(HttpServerRequest request) {
        Route route = this.routeRepository.getRoute(request.uri());
        if (route != null && (route.getHook().getMethods().isEmpty() || route.getHook().getMethods().contains(request.method().name()))) {
            this.log.debug("Forward request " + request.uri());
            route.forward(request);
            return true;
        }
        return false;
    }

    private void installBodyHandler(HttpServerRequest request, List<Listener> listeners) {
        request.bodyHandler(buffer -> {
            List<Listener> beforeListener = this.getFilteredListeners(listeners, HookTriggerType.BEFORE);
            List<Listener> afterListener = this.getFilteredListeners(listeners, HookTriggerType.AFTER);
            Handler<Void> afterHandler = this.installAfterHandler(request, (Buffer)buffer, afterListener);
            Handler<Void> beforeHandler = this.installBeforeHandler(request, (Buffer)buffer, beforeListener, afterHandler);
            this.callListener(request, (Buffer)buffer, beforeListener, beforeHandler);
        });
    }

    private void callListener(HttpServerRequest request, Buffer buffer, List<Listener> filteredListeners, Handler<Void> handler) {
        for (Listener listener : filteredListeners) {
            String targetUri;
            this.log.debug("Enqueue request matching " + request.method() + " " + listener.getMonitoredUrl() + " with listener " + listener.getListener());
            String path = request.uri();
            if (!listener.getHook().isFullUrl()) {
                path = request.uri().replace(listener.getMonitoredUrl(), "");
            }
            if (listener.getHook().getDestination().startsWith("/")) {
                targetUri = listener.getListener() + path;
                this.log.debug(" > internal target: " + targetUri);
            } else {
                targetUri = this.hookRootUri + LISTENER_HOOK_TARGET_PATH + listener.getListener() + path;
                this.log.debug(" > external target: " + targetUri);
            }
            String queue = "listener-hook-" + listener.getListenerId();
            CaseInsensitiveHeaders queueHeaders = new CaseInsensitiveHeaders();
            queueHeaders.addAll(request.headers());
            if (ExpiryCheckHandler.getExpireAfter((MultiMap)queueHeaders) == null) {
                ExpiryCheckHandler.setExpireAfter((MultiMap)queueHeaders, (int)listener.getHook().getExpireAfter());
            }
            if (ExpiryCheckHandler.getQueueExpireAfter((MultiMap)queueHeaders) == null && listener.getHook().getQueueExpireAfter() != -1) {
                ExpiryCheckHandler.setQueueExpireAfter((MultiMap)queueHeaders, (int)listener.getHook().getQueueExpireAfter());
            }
            this.updateHeadersWithStaticHeaders((MultiMap)queueHeaders, listener.getHook().getStaticHeaders());
            queueHeaders.add("x-translate-status-4xx", "200");
            QueueingStrategy queueingStrategy = listener.getHook().getQueueingStrategy();
            if (queueingStrategy instanceof DefaultQueueingStrategy) {
                this.requestQueue.enqueue(new HttpRequest(request.method(), targetUri, (MultiMap)queueHeaders, buffer.getBytes()), queue, handler);
                continue;
            }
            if (queueingStrategy instanceof DiscardPayloadQueueingStrategy) {
                if (HttpRequestHeader.containsHeader((MultiMap)queueHeaders, (HttpRequestHeader)HttpRequestHeader.CONTENT_LENGTH)) {
                    queueHeaders.set(HttpRequestHeader.CONTENT_LENGTH.getName(), "0");
                }
                this.requestQueue.enqueue(new HttpRequest(request.method(), targetUri, (MultiMap)queueHeaders, null), queue, handler);
                continue;
            }
            if (queueingStrategy instanceof ReducedPropagationQueueingStrategy) {
                if (this.reducedPropagationManager != null) {
                    this.reducedPropagationManager.processIncomingRequest(request.method(), targetUri, (MultiMap)queueHeaders, buffer, queue, ((ReducedPropagationQueueingStrategy)queueingStrategy).getPropagationInterval(), handler);
                    continue;
                }
                this.log.error("ReducedPropagationQueueingStrategy without configured ReducedPropagationManager. Not going to handle (enqueue) anything!");
                continue;
            }
            this.log.error("QueueingStrategy '" + queueingStrategy.getClass().getSimpleName() + "' is not handled. Could be an error, check the source code!");
        }
        if (filteredListeners.isEmpty() && handler != null) {
            handler.handle(null);
        }
    }

    private Handler<Void> installAfterHandler(HttpServerRequest request, Buffer buffer, List<Listener> afterListener) {
        Handler afterHandler = event -> this.callListener(request, buffer, afterListener, null);
        return afterHandler;
    }

    private Handler<Void> installBeforeHandler(final HttpServerRequest request, final Buffer buffer, final List<Listener> beforeListener, final Handler<Void> afterHandler) {
        Handler<Void> beforeHandler = new Handler<Void>(){
            private AtomicInteger currentCount = new AtomicInteger(0);
            private boolean sent = false;

            public void handle(Void event) {
                if ((this.currentCount.incrementAndGet() == beforeListener.size() || beforeListener.isEmpty()) && !this.sent) {
                    this.sent = true;
                    Route route = HookHandler.this.routeRepository.getRoute(request.uri());
                    if (route != null && (route.getHook().getMethods().isEmpty() || route.getHook().getMethods().contains(request.method().name()))) {
                        HookHandler.this.log.debug("Forward request (consumed) " + request.uri());
                        route.forward(request, buffer);
                    } else {
                        request.headers().add(HookHandler.HOOKED_HEADER, "true");
                        HookHandler.this.createSelfRequest(request, buffer, (Handler<Void>)afterHandler);
                    }
                }
            }
        };
        return beforeHandler;
    }

    private List<Listener> getFilteredListeners(List<Listener> listeners, HookTriggerType hookTriggerType) {
        return listeners.stream().filter(listener -> listener.getHook().getHookTriggerType().equals((Object)hookTriggerType)).collect(Collectors.toList());
    }

    private void updateHeadersWithStaticHeaders(MultiMap queueHeaders, Map<String, String> staticHeaders) {
        if (staticHeaders != null) {
            for (Map.Entry<String, String> entry : staticHeaders.entrySet()) {
                String entryValue = entry.getValue();
                if (entryValue != null && entryValue.length() > 0) {
                    queueHeaders.set(entry.getKey(), entry.getValue());
                    continue;
                }
                queueHeaders.remove(entry.getKey());
            }
        }
    }

    private void handleRouteUnregistration(HttpServerRequest request) {
        this.log.debug("handleRouteUnregistration > " + request.uri());
        String routeStorageUri = this.hookRootUri + HOOK_ROUTE_STORAGE_PATH + this.getStorageIdentifier(request.uri());
        this.storage.delete(routeStorageUri, status -> {
            this.vertx.eventBus().publish(REMOVE_ROUTE_ADDRESS, (Object)request.uri());
            request.response().end();
        });
    }

    private void handleRouteRegistration(HttpServerRequest request) {
        this.log.debug("handleRouteRegistration > " + request.uri());
        request.bodyHandler(hookData -> {
            String routeStorageUri = this.hookRootUri + HOOK_ROUTE_STORAGE_PATH + this.getStorageIdentifier(request.uri());
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter((MultiMap)request.headers());
            if (expireAfter == null) {
                expireAfter = 3600;
            }
            ExpiryCheckHandler.setExpireAfter((HttpServerRequest)request, (int)expireAfter);
            LocalDateTime expirationTime = ExpiryCheckHandler.getExpirationTime((int)expireAfter);
            JsonObject storageObject = new JsonObject();
            storageObject.put(REQUESTURL, request.uri());
            storageObject.put(EXPIRATION_TIME, ExpiryCheckHandler.printDateTime((LocalDateTime)expirationTime));
            storageObject.put(HOOK, new JsonObject(hookData.toString()));
            this.storage.put(routeStorageUri, request.headers(), Buffer.buffer((String)storageObject.toString()), status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    this.vertx.eventBus().publish(SAVE_ROUTE_ADDRESS, (Object)routeStorageUri);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        });
    }

    private String getStorageIdentifier(String url) {
        return url.replace("/", "+");
    }

    private void handleListenerUnregistration(HttpServerRequest request) {
        this.log.debug("handleListenerUnregistration > " + request.uri());
        String listenerStorageUri = this.hookRootUri + HOOK_LISTENER_STORAGE_PATH + this.getUniqueListenerId(request.uri());
        this.storage.delete(listenerStorageUri, status -> {
            this.vertx.eventBus().publish(REMOVE_LISTENER_ADDRESS, (Object)request.uri());
            request.response().end();
        });
    }

    private void handleListenerRegistration(HttpServerRequest request) {
        this.log.debug("handleListenerRegistration > " + request.uri());
        request.bodyHandler(hookData -> {
            String hookOnUri;
            JsonObject hook = new JsonObject(hookData.toString());
            String destination = hook.getString("destination");
            if (destination.startsWith(hookOnUri = this.getMonitoredUrlSegment(request.uri()))) {
                request.response().setStatusCode(400);
                String msg = "Destination-URI should not be within subtree of your hooked resource. This would lead to an infinite loop.";
                request.response().setStatusMessage("Destination-URI should not be within subtree of your hooked resource. This would lead to an infinite loop.");
                request.response().end("Destination-URI should not be within subtree of your hooked resource. This would lead to an infinite loop.");
                return;
            }
            String listenerStorageUri = this.hookRootUri + HOOK_LISTENER_STORAGE_PATH + this.getUniqueListenerId(request.uri());
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter((MultiMap)request.headers());
            if (expireAfter == null) {
                expireAfter = 3600;
            }
            ExpiryCheckHandler.setExpireAfter((HttpServerRequest)request, (int)expireAfter);
            LocalDateTime expirationTime = ExpiryCheckHandler.getExpirationTime((int)expireAfter);
            JsonObject storageObject = new JsonObject();
            storageObject.put(REQUESTURL, request.uri());
            storageObject.put(EXPIRATION_TIME, ExpiryCheckHandler.printDateTime((LocalDateTime)expirationTime));
            storageObject.put(HOOK, hook);
            this.storage.put(listenerStorageUri, request.headers(), Buffer.buffer((String)storageObject.toString()), status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    this.vertx.eventBus().publish(SAVE_LISTENER_ADDRESS, (Object)listenerStorageUri);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        });
    }

    private void createSelfRequest(HttpServerRequest request, Buffer requestBody, Handler<Void> afterHandler) {
        this.log.debug("Create self request for " + request.uri());
        HttpClientRequest selfRequest = this.selfClient.request(request.method(), request.uri(), response -> {
            request.response().setStatusCode(response.statusCode());
            request.response().setStatusMessage(response.statusMessage());
            request.response().setChunked(true);
            request.response().headers().addAll(response.headers());
            request.response().headers().remove(HttpRequestHeader.CONTENT_LENGTH.getName());
            response.handler(data -> request.response().write(data));
            response.endHandler(v -> request.response().end());
            if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                afterHandler.handle(null);
            }
        });
        if (request.headers() != null && !request.headers().isEmpty()) {
            selfRequest.headers().setAll(request.headers());
        }
        selfRequest.exceptionHandler(exception -> this.log.warn("HookHandler HOOK_ERROR: Failed self request to " + request.uri() + ": " + exception.getMessage()));
        selfRequest.setTimeout(120000L);
        if (requestBody != null) {
            selfRequest.end(requestBody);
        } else {
            selfRequest.end();
        }
    }

    public boolean isRequestAlreadyHooked(HttpServerRequest request) {
        String hooked = request.headers().get(HOOKED_HEADER);
        return hooked != null ? hooked.equals("true") : false;
    }

    private void unregisterRoute(String requestUrl) {
        String routedUrl = this.getRoutedUrlSegment(requestUrl);
        this.log.debug("Unregister route " + routedUrl);
        this.routeRepository.removeRoute(routedUrl);
    }

    private void unregisterListener(String requestUrl) {
        String listenerId = this.getUniqueListenerId(requestUrl);
        this.log.debug("Unregister listener " + listenerId);
        this.routeRepository.removeRoute(this.hookRootUri + LISTENER_HOOK_TARGET_PATH + this.getListenerUrlSegment(requestUrl));
        this.listenerRepository.removeListener(listenerId);
    }

    private void registerListener(Buffer buffer) {
        JsonObject storageObject = new JsonObject(buffer.toString());
        String requestUrl = storageObject.getString(REQUESTURL);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Request URL: " + requestUrl);
        }
        String target = this.getListenerUrlSegment(requestUrl);
        String listenerId = this.getUniqueListenerId(requestUrl);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Target (1st): " + target);
        }
        JsonObject jsonHook = storageObject.getJsonObject(HOOK);
        JsonArray jsonMethods = jsonHook.getJsonArray("methods");
        HttpHook hook = new HttpHook(jsonHook.getString("destination"));
        if (jsonMethods != null) {
            hook.setMethods(jsonMethods.getList());
        }
        if (jsonHook.containsKey("filter")) {
            hook.setFilter(jsonHook.getString("filter"));
        }
        if (jsonHook.containsKey("filter")) {
            hook.setFilter(jsonHook.getString("filter"));
        }
        if (jsonHook.getInteger(EXPIRE_AFTER) != null) {
            hook.setExpireAfter(jsonHook.getInteger(EXPIRE_AFTER));
        } else {
            hook.setExpireAfter(30);
        }
        if (jsonHook.getInteger(QUEUE_EXPIRE_AFTER) != null) {
            hook.setQueueExpireAfter(jsonHook.getInteger(QUEUE_EXPIRE_AFTER));
        }
        if (jsonHook.getString(HOOK_TRIGGER_TYPE) != null) {
            try {
                hook.setHookTriggerType(HookTriggerType.valueOf(jsonHook.getString(HOOK_TRIGGER_TYPE).toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                this.log.warn("Listener " + listenerId + " for target " + target + " has an invalid trigger type " + jsonHook.getString(HOOK_TRIGGER_TYPE) + " and will not be registred!", (Throwable)e);
                return;
            }
        }
        this.extractAndAddStaticHeadersToHook(jsonHook, hook);
        String expirationTimeExpression = storageObject.getString(EXPIRATION_TIME);
        LocalDateTime expirationTime = null;
        if (expirationTimeExpression != null) {
            try {
                expirationTime = ExpiryCheckHandler.parseDateTime((String)expirationTimeExpression);
            }
            catch (Exception e) {
                this.log.warn("Listener " + listenerId + " for target " + target + " has an invalid expiration time " + expirationTimeExpression + " and will not be registred!", (Throwable)e);
                return;
            }
        } else {
            this.log.warn("Listener " + listenerId + " for target " + target + " has no expiration time and will not be registred!");
            return;
        }
        this.log.debug("Register listener and  route " + target + " with expiration at " + expirationTime);
        hook.setExpirationTime(expirationTime);
        hook.setFullUrl(jsonHook.getBoolean(FULL_URL, Boolean.valueOf(false)));
        hook.setQueueingStrategy(QueueingStrategyFactory.buildQueueStrategy(jsonHook));
        if (hook.getDestination().startsWith("/")) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("internal target, switching target!");
            }
            target = hook.getDestination();
        } else {
            String urlPattern = this.hookRootUri + LISTENER_HOOK_TARGET_PATH + target;
            this.routeRepository.addRoute(urlPattern, this.createRoute(urlPattern, hook));
            if (this.log.isTraceEnabled()) {
                this.log.trace("external target, add route for urlPattern: " + urlPattern);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("Target (2nd): " + target);
        }
        this.listenerRepository.addListener(new Listener(listenerId, this.getMonitoredUrlSegment(requestUrl), target, hook));
    }

    private void extractAndAddStaticHeadersToHook(JsonObject jsonHook, HttpHook hook) {
        JsonObject staticHeaders = jsonHook.getJsonObject(STATIC_HEADERS);
        if (staticHeaders != null && staticHeaders.size() > 0) {
            hook.addStaticHeaders(new LinkedHashMap<String, String>());
            for (Map.Entry entry : staticHeaders.getMap().entrySet()) {
                hook.getStaticHeaders().put((String)entry.getKey(), entry.getValue().toString());
            }
        }
    }

    protected String getUniqueListenerId(String requestUrl) {
        StringBuilder listenerId = new StringBuilder();
        listenerId.append(this.convertToStoragePattern(this.getListenerUrlSegment(requestUrl)));
        listenerId.append(this.convertToStoragePattern(this.getMonitoredUrlSegment(requestUrl)));
        return listenerId.toString();
    }

    private String convertToStoragePattern(String urlSegment) {
        return urlSegment.replace("/", "+").replace(".", "+").replace(":", "+");
    }

    private void registerRoute(Buffer buffer) {
        JsonObject storageObject = new JsonObject(buffer.toString());
        String requestUrl = storageObject.getString(REQUESTURL);
        String routedUrl = this.getRoutedUrlSegment(requestUrl);
        this.log.debug("Register route to  " + routedUrl);
        JsonObject jsonHook = storageObject.getJsonObject(HOOK);
        JsonArray jsonMethods = jsonHook.getJsonArray("methods");
        HttpHook hook = new HttpHook(jsonHook.getString("destination"));
        if (jsonMethods != null) {
            hook.setMethods(jsonMethods.getList());
        }
        if (jsonHook.getInteger(EXPIRE_AFTER) != null) {
            hook.setExpireAfter(jsonHook.getInteger(EXPIRE_AFTER));
        } else {
            hook.setExpireAfter(30);
        }
        if (jsonHook.getInteger(QUEUE_EXPIRE_AFTER) != null) {
            hook.setQueueExpireAfter(jsonHook.getInteger(QUEUE_EXPIRE_AFTER));
        }
        if (jsonHook.getBoolean(LISTABLE) != null) {
            hook.setListable(jsonHook.getBoolean(LISTABLE));
        } else {
            hook.setListable(this.listableRoutes);
        }
        if (jsonHook.getBoolean(COLLECTION) != null) {
            hook.setCollection(jsonHook.getBoolean(COLLECTION));
        }
        this.extractAndAddStaticHeadersToHook(jsonHook, hook);
        String expirationTimeExpression = storageObject.getString(EXPIRATION_TIME);
        if (expirationTimeExpression != null) {
            try {
                hook.setExpirationTime(ExpiryCheckHandler.parseDateTime((String)expirationTimeExpression));
            }
            catch (Exception e) {
                this.log.warn("Route " + routedUrl + " has an invalid expiration time " + expirationTimeExpression + " and will not be registred!");
                return;
            }
        } else {
            this.log.warn("Route " + routedUrl + " has no expiration time and will not be registred!");
            return;
        }
        hook.setFullUrl(storageObject.getBoolean(FULL_URL, Boolean.valueOf(false)));
        hook.setQueueingStrategy(QueueingStrategyFactory.buildQueueStrategy(storageObject));
        this.routeRepository.addRoute(routedUrl, this.createRoute(routedUrl, hook));
    }

    private Route createRoute(String urlPattern, HttpHook hook) {
        return new Route(this.vertx, this.storage, this.loggingResourceManager, this.monitoringHandler, this.userProfilePath, hook, urlPattern);
    }

    private String getRoutedUrlSegment(String requestUrl) {
        return requestUrl.substring(0, requestUrl.indexOf(HOOKS_ROUTE_URI_PART));
    }

    private String getMonitoredUrlSegment(String requestUrl) {
        return requestUrl.substring(0, requestUrl.indexOf(HOOKS_LISTENERS_URI_PART));
    }

    private String getListenerUrlSegment(String requestUrl) {
        int pos = requestUrl.indexOf(HOOKS_LISTENERS_URI_PART);
        String segment = requestUrl.substring(pos + HOOKS_LISTENERS_URI_PART.length());
        return segment;
    }

    private boolean isHookListenerUnregistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_LISTENERS_URI_PART) && HttpMethod.DELETE == request.method();
    }

    private boolean isHookListenerRegistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_LISTENERS_URI_PART) && HttpMethod.PUT == request.method();
    }

    private boolean isHookRouteRegistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_ROUTE_URI_PART) && HttpMethod.PUT == request.method();
    }

    private boolean isHookRouteUnregistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_ROUTE_URI_PART) && HttpMethod.DELETE == request.method();
    }
}

