/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook.queueingstrategy;

import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import org.swisspush.gateleen.hook.queueingstrategy.DefaultQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.DiscardPayloadQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.ReducedPropagationQueueingStrategy;

public class QueueingStrategyFactory {
    private static final String QUEUEING_STRATEGY_PROPERTY = "queueingStrategy";
    private static Logger LOG = LoggerFactory.getLogger(QueueingStrategyFactory.class);

    private QueueingStrategyFactory() {
    }

    public static QueueingStrategy buildQueueStrategy(JsonObject hookConfiguration) {
        QueueingStrategy queueingStrategy = new DefaultQueueingStrategy();
        if (hookConfiguration == null || !hookConfiguration.containsKey(QUEUEING_STRATEGY_PROPERTY)) {
            return queueingStrategy;
        }
        Object queueingStrategyConfigObj = hookConfiguration.getValue(QUEUEING_STRATEGY_PROPERTY);
        if (!(queueingStrategyConfigObj instanceof JsonObject)) {
            LOG.warn((Object)("Invalid 'queueingStrategy' configuration found: " + queueingStrategyConfigObj + ". Using DefaultQueueingStrategy instead"));
            return queueingStrategy;
        }
        JsonObject queueingStrategyConfig = (JsonObject)queueingStrategyConfigObj;
        Strategy strategy = Strategy.fromString(queueingStrategyConfig.getString("type"));
        if (strategy == null) {
            LOG.warn((Object)("Invalid 'queueingStrategy' configuration found: " + queueingStrategyConfig.encode() + ". Using DefaultQueueingStrategy instead"));
            return queueingStrategy;
        }
        switch (strategy) {
            case DISCARD_PAYLOAD: {
                queueingStrategy = new DiscardPayloadQueueingStrategy();
                break;
            }
            case REDUCED_PROPAGATION: {
                queueingStrategy = QueueingStrategyFactory.buildReducedPropagationQueueingStrategy(queueingStrategyConfig);
                break;
            }
            default: {
                LOG.warn((Object)("Unknown strategy '" + (Object)((Object)strategy) + "'. Using DefaultQueueingStrategy instead"));
            }
        }
        return queueingStrategy;
    }

    private static QueueingStrategy buildReducedPropagationQueueingStrategy(JsonObject queueingStrategyConfig) {
        try {
            Long interval = queueingStrategyConfig.getLong("interval");
            if (interval != null) {
                return new ReducedPropagationQueueingStrategy(interval);
            }
            LOG.warn((Object)("Got a 'ReducedPropagationQueueingStrategy' configuration with an invalid interval value: " + queueingStrategyConfig.encode()));
            return new DefaultQueueingStrategy();
        }
        catch (Exception ex) {
            LOG.warn((Object)("Got a 'ReducedPropagationQueueingStrategy' configuration with an invalid interval value: " + queueingStrategyConfig.encode()));
            return new DefaultQueueingStrategy();
        }
    }

    private static enum Strategy {
        DISCARD_PAYLOAD("discardPayload"),
        REDUCED_PROPAGATION("reducedPropagation");

        private final String type;

        private Strategy(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static Strategy fromString(String op) {
            for (Strategy strategy : Strategy.values()) {
                if (!strategy.getType().equalsIgnoreCase(op)) continue;
                return strategy;
            }
            return null;
        }
    }
}

