/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook.reducedpropagation.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.redis.RedisClient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.swisspush.gateleen.core.lua.LuaScript;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationStorage;
import org.swisspush.gateleen.hook.reducedpropagation.lua.ReducedPropagationLuaScripts;
import org.swisspush.gateleen.hook.reducedpropagation.lua.RemoveExpiredQueuesRedisCommand;
import org.swisspush.gateleen.hook.reducedpropagation.lua.StartQueueTimerRedisCommand;

public class RedisReducedPropagationStorage
implements ReducedPropagationStorage {
    private RedisClient redisClient;
    private Logger log = LoggerFactory.getLogger(RedisReducedPropagationStorage.class);
    static final String QUEUE_TIMERS = "gateleen.hook-reducedpropagation-queuetimers";
    static final String QUEUE_REQUESTS = "gateleen.hook-reducedpropagation-queuerequests";
    private LuaScriptState startQueueTimerLuaScriptState;
    private LuaScriptState removeExpiredQueuesRedisCommand;

    public RedisReducedPropagationStorage(RedisClient redisClient) {
        this.redisClient = redisClient;
        this.startQueueTimerLuaScriptState = new LuaScriptState((LuaScript)ReducedPropagationLuaScripts.START_QUEUE_TIMER, redisClient, false);
        this.removeExpiredQueuesRedisCommand = new LuaScriptState((LuaScript)ReducedPropagationLuaScripts.REMOVE_EXPIRED_QUEUES, redisClient, false);
    }

    @Override
    public Future<List<String>> removeExpiredQueues(long currentTS) {
        Future future = Future.future();
        List<String> keys = Collections.singletonList(QUEUE_TIMERS);
        List<String> arguments = Collections.singletonList(String.valueOf(currentTS));
        RemoveExpiredQueuesRedisCommand cmd = new RemoveExpiredQueuesRedisCommand(this.removeExpiredQueuesRedisCommand, keys, arguments, this.redisClient, this.log, (Future<List<String>>)future);
        cmd.exec(0);
        return future;
    }

    @Override
    public Future<Boolean> addQueue(String queue, long expireTS) {
        Future future = Future.future();
        List<String> keys = Collections.singletonList(QUEUE_TIMERS);
        List<String> arguments = Arrays.asList(queue, String.valueOf(expireTS));
        StartQueueTimerRedisCommand cmd = new StartQueueTimerRedisCommand(this.startQueueTimerLuaScriptState, keys, arguments, this.redisClient, this.log, (Future<Boolean>)future);
        cmd.exec(0);
        return future;
    }

    @Override
    public Future<Void> storeQueueRequest(String queue, JsonObject queueRequest) {
        Future future = Future.future();
        if (StringUtils.isEmpty((CharSequence)queue)) {
            future.fail("Queue is not allowed to be empty");
            return future;
        }
        if (queueRequest == null) {
            future.fail("Request is not allowed to be empty");
            return future;
        }
        try {
            String queueRequestStr = queueRequest.encode();
            this.redisClient.hset(QUEUE_REQUESTS, queue, queueRequestStr, reply -> {
                if (reply.failed()) {
                    String message = "Failed to store request for queue '" + queue + "'. Cause: " + RedisReducedPropagationStorage.logCause(reply);
                    this.log.error((Object)message);
                    future.fail(message);
                } else {
                    future.complete();
                }
            });
        }
        catch (DecodeException ex) {
            future.fail("Failed to decode request for queue '" + queue + "'");
            return future;
        }
        return future;
    }

    @Override
    public Future<JsonObject> getQueueRequest(String queue) {
        Future future = Future.future();
        if (StringUtils.isEmpty((CharSequence)queue)) {
            future.fail("Queue is not allowed to be empty");
            return future;
        }
        this.redisClient.hget(QUEUE_REQUESTS, queue, reply -> {
            if (reply.failed()) {
                String message = "get queue request '" + queue + "' from hash '" + QUEUE_REQUESTS + "' resulted in cause " + RedisReducedPropagationStorage.logCause(reply);
                this.log.error((Object)message);
                future.fail(message);
            } else {
                String resultStr = (String)reply.result();
                if (StringUtils.isNotEmpty((CharSequence)resultStr)) {
                    try {
                        JsonObject queueRequest = new JsonObject(resultStr);
                        future.complete((Object)queueRequest);
                    }
                    catch (DecodeException ex) {
                        future.fail("Failed to decode queue request for queue '" + queue + "'. Got this from storage: " + resultStr);
                    }
                } else {
                    future.complete(null);
                }
            }
        });
        return future;
    }

    @Override
    public Future<Void> removeQueueRequest(String queue) {
        Future future = Future.future();
        if (StringUtils.isEmpty((CharSequence)queue)) {
            future.fail("Queue is not allowed to be empty");
            return future;
        }
        this.redisClient.hdel(QUEUE_REQUESTS, queue, reply -> {
            if (reply.failed()) {
                String message = "Failed to remove request for queue '" + queue + "'. Cause: " + RedisReducedPropagationStorage.logCause(reply);
                this.log.error((Object)message);
                future.fail(message);
            } else {
                future.complete();
            }
        });
        return future;
    }

    private static String logCause(AsyncResult result) {
        if (result.cause() != null) {
            return result.cause().getMessage();
        }
        return null;
    }
}

