/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;
import org.swisspush.gateleen.core.http.HeaderFunction;
import org.swisspush.gateleen.core.http.HeaderFunctions;
import org.swisspush.gateleen.hook.HookTriggerType;
import org.swisspush.gateleen.hook.queueingstrategy.DefaultQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategy;

public class HttpHook {
    private String destination;
    private List<String> methods;
    private LocalDateTime expirationTime;
    private boolean fullUrl = false;
    private QueueingStrategy queueingStrategy = new DefaultQueueingStrategy();
    private Pattern filter = null;
    private int queueExpireAfter;
    private HeaderFunction headerFunction = HeaderFunctions.DO_NOTHING;
    private HookTriggerType hookTriggerType;
    private boolean listable = false;
    private boolean collection = true;

    public HttpHook(String destination) {
        this.destination = destination;
        this.methods = new ArrayList<String>();
        this.queueExpireAfter = -1;
        this.hookTriggerType = HookTriggerType.BEFORE;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public Optional<LocalDateTime> getExpirationTime() {
        return Optional.ofNullable(this.expirationTime);
    }

    public void setExpirationTime(LocalDateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean isFullUrl() {
        return this.fullUrl;
    }

    public void setFullUrl(boolean fullUrl) {
        this.fullUrl = fullUrl;
    }

    public QueueingStrategy getQueueingStrategy() {
        return this.queueingStrategy;
    }

    public void setQueueingStrategy(QueueingStrategy queueingStrategy) {
        this.queueingStrategy = queueingStrategy;
    }

    public Pattern getFilter() {
        return this.filter;
    }

    public void setFilter(String regex) {
        this.filter = Pattern.compile(regex);
    }

    public int getQueueExpireAfter() {
        return this.queueExpireAfter;
    }

    public void setQueueExpireAfter(int queueExpireAfter) {
        this.queueExpireAfter = queueExpireAfter;
    }

    public HeaderFunction getHeaderFunction() {
        return this.headerFunction;
    }

    public void setHeaderFunction(HeaderFunction headerFunction) {
        this.headerFunction = headerFunction;
    }

    public HookTriggerType getHookTriggerType() {
        return this.hookTriggerType;
    }

    public void setHookTriggerType(HookTriggerType hookTriggerType) {
        this.hookTriggerType = hookTriggerType;
    }

    public boolean isListable() {
        return this.listable;
    }

    public void setListable(boolean listable) {
        this.listable = listable;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }
}

