/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.headers.VertxHttpHeaders;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HeaderFunction;
import org.swisspush.gateleen.core.http.HeaderFunctions;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.CollectionContentComparator;
import org.swisspush.gateleen.core.util.HttpRequestHeader;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.hook.HookTriggerType;
import org.swisspush.gateleen.hook.HttpHook;
import org.swisspush.gateleen.hook.Listener;
import org.swisspush.gateleen.hook.ListenerRepository;
import org.swisspush.gateleen.hook.LocalListenerRepository;
import org.swisspush.gateleen.hook.LocalRouteRepository;
import org.swisspush.gateleen.hook.Route;
import org.swisspush.gateleen.hook.RouteRepository;
import org.swisspush.gateleen.hook.queueingstrategy.DefaultQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.DiscardPayloadQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategyFactory;
import org.swisspush.gateleen.hook.queueingstrategy.ReducedPropagationQueueingStrategy;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationManager;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.expiry.ExpiryCheckHandler;
import org.swisspush.gateleen.queue.queuing.QueueClient;
import org.swisspush.gateleen.queue.queuing.QueueProcessor;
import org.swisspush.gateleen.queue.queuing.RequestQueue;

public class HookHandler
implements LoggableResource {
    public static final String HOOKED_HEADER = "x-hooked";
    public static final String HOOK_ROUTES_LISTED = "x-hook-routes-listed";
    public static final String HOOKS_LISTENERS_URI_PART = "/_hooks/listeners/";
    public static final String LISTENER_QUEUE_PREFIX = "listener-hook";
    private static final String X_QUEUE = "x-queue";
    private static final String X_EXPIRE_AFTER = "X-Expire-After";
    private static final String LISTENER_HOOK_TARGET_PATH = "listeners/";
    public static final String HOOKS_ROUTE_URI_PART = "/_hooks/route";
    private static final String HOOK_STORAGE_PATH = "registrations/";
    private static final String HOOK_LISTENER_STORAGE_PATH = "registrations/listeners/";
    private static final String HOOK_ROUTE_STORAGE_PATH = "registrations/routes/";
    private static final String SAVE_LISTENER_ADDRESS = "gateleen.hook-listener-insert";
    private static final String REMOVE_LISTENER_ADDRESS = "gateleen.hook-listener-remove";
    private static final String SAVE_ROUTE_ADDRESS = "gateleen.hook-route-insert";
    private static final String REMOVE_ROUTE_ADDRESS = "gateleen.hook-route-remove";
    private static final int DEFAULT_HOOK_STORAGE_EXPIRE_AFTER_TIME = 3600;
    private static final int DEFAULT_CLEANUP_TIME = 15000;
    public static final String REQUESTURL = "requesturl";
    public static final String EXPIRATION_TIME = "expirationTime";
    public static final String HOOK = "hook";
    public static final String QUEUE_EXPIRE_AFTER = "queueExpireAfter";
    public static final String STATIC_HEADERS = "staticHeaders";
    public static final String FULL_URL = "fullUrl";
    public static final String DISCARD_PAYLOAD = "discardPayload";
    public static final String HOOK_TRIGGER_TYPE = "type";
    public static final String LISTABLE = "listable";
    public static final String COLLECTION = "collection";
    private final Comparator<String> collectionContentComparator;
    private static final Logger log = LoggerFactory.getLogger(HookHandler.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private Vertx vertx;
    private final ResourceStorage userProfileStorage;
    private final ResourceStorage hookStorage;
    private MonitoringHandler monitoringHandler;
    private LoggingResourceManager loggingResourceManager;
    private final HttpClient selfClient;
    private String userProfilePath;
    private String hookRootUri;
    private boolean listableRoutes;
    private ListenerRepository listenerRepository;
    private RouteRepository routeRepository;
    private RequestQueue requestQueue;
    private ReducedPropagationManager reducedPropagationManager;
    private boolean logHookConfigurationResourceChanges = false;
    private Handler<Void> doneHandler;
    private final JsonSchema jsonSchemaHook;

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri) {
        this(vertx, selfClient, storage, loggingResourceManager, monitoringHandler, userProfilePath, hookRootUri, (RequestQueue)new QueueClient(vertx, monitoringHandler));
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue) {
        this(vertx, selfClient, storage, loggingResourceManager, monitoringHandler, userProfilePath, hookRootUri, requestQueue, false);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes) {
        this(vertx, selfClient, storage, loggingResourceManager, monitoringHandler, userProfilePath, hookRootUri, requestQueue, false, null);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes, ReducedPropagationManager reducedPropagationManager) {
        this(vertx, selfClient, storage, loggingResourceManager, monitoringHandler, userProfilePath, hookRootUri, requestQueue, listableRoutes, reducedPropagationManager, null, storage);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage userProfileStorage, LoggingResourceManager loggingResourceManager, MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes, ReducedPropagationManager reducedPropagationManager, Handler doneHandler, ResourceStorage hookStorage) {
        log.debug("Creating HookHandler ...");
        this.vertx = vertx;
        this.selfClient = selfClient;
        this.userProfileStorage = userProfileStorage;
        this.loggingResourceManager = loggingResourceManager;
        this.monitoringHandler = monitoringHandler;
        this.userProfilePath = userProfilePath;
        this.hookRootUri = hookRootUri;
        this.requestQueue = requestQueue;
        this.listableRoutes = listableRoutes;
        this.reducedPropagationManager = reducedPropagationManager;
        this.listenerRepository = new LocalListenerRepository();
        this.routeRepository = new LocalRouteRepository();
        this.collectionContentComparator = new CollectionContentComparator();
        this.doneHandler = doneHandler;
        this.hookStorage = hookStorage;
        URL url = HookHandler.class.getResource("/gateleen_hooking_schema_hook");
        this.jsonSchemaHook = JsonSchemaFactory.getInstance().getSchema(url);
    }

    public void init() {
        final ArrayList<Consumer<Handler>> initMethods = new ArrayList<Consumer<Handler>>();
        initMethods.add(this::registerListenerRegistrationHandler);
        initMethods.add(this::registerRouteRegistrationHandler);
        initMethods.add(this::loadStoredListeners);
        initMethods.add(this::loadStoredRoutes);
        initMethods.add(this::registerCleanupHandler);
        Handler<Void> readyHandler = new Handler<Void>(){
            private AtomicInteger readyCounter;
            {
                this.readyCounter = new AtomicInteger(initMethods.size());
            }

            public void handle(Void aVoid) {
                if (this.readyCounter.decrementAndGet() == 0) {
                    log.info("HookHandler is ready!");
                    if (HookHandler.this.doneHandler != null) {
                        HookHandler.this.doneHandler.handle(null);
                    }
                }
            }
        };
        initMethods.forEach(arg_0 -> HookHandler.lambda$init$0((Handler)readyHandler, arg_0));
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logHookConfigurationResourceChanges = resourceLoggingEnabled;
    }

    private void registerCleanupHandler(Handler<Void> readyHandler) {
        this.vertx.setPeriodic(15000L, (Handler)new Handler<Long>(){

            public void handle(Long timerID) {
                log.trace("Running hook cleanup ...");
                DateTime now = DateTime.now();
                for (Listener listener : HookHandler.this.listenerRepository.getListeners()) {
                    Optional<DateTime> expirationTime = listener.getHook().getExpirationTime();
                    if (!expirationTime.isPresent()) {
                        log.trace("Listener " + listener.getListenerId() + " will never expire.");
                        continue;
                    }
                    if (!expirationTime.get().isBefore((ReadableInstant)now)) continue;
                    log.debug("Listener " + listener.getListenerId() + " expired at " + expirationTime.get() + " and current time is " + now);
                    HookHandler.this.listenerRepository.removeListener(listener.getListenerId());
                    HookHandler.this.routeRepository.removeRoute(HookHandler.this.hookRootUri + HookHandler.LISTENER_HOOK_TARGET_PATH + listener.getListenerId());
                }
                Map<String, Route> routes = HookHandler.this.routeRepository.getRoutes();
                for (String key : routes.keySet()) {
                    Route route = routes.get(key);
                    Optional<DateTime> expirationTime = route.getHook().getExpirationTime();
                    if (!expirationTime.isPresent()) {
                        log.trace("Route " + key + " will never expire.");
                        continue;
                    }
                    if (!expirationTime.get().isBefore((ReadableInstant)now)) continue;
                    HookHandler.this.routeRepository.removeRoute(key);
                }
                HookHandler.this.monitoringHandler.updateListenerCount((long)HookHandler.this.listenerRepository.size());
                HookHandler.this.monitoringHandler.updateRoutesCount((long)HookHandler.this.routeRepository.getRoutes().size());
                log.trace("done");
            }
        });
        readyHandler.handle(null);
    }

    private void loadStoredRoutes(Handler<Void> readyHandler) {
        log.debug("loadStoredRoutes");
        String routeBase = this.hookRootUri + HOOK_ROUTE_STORAGE_PATH;
        this.hookStorage.get(routeBase, buffer -> {
            if (buffer != null) {
                JsonObject listOfRoutes = new JsonObject(buffer.toString());
                JsonArray routeNames = listOfRoutes.getJsonArray("routes");
                Iterator keys = routeNames.getList().iterator();
                AtomicInteger storedRoutesCount = new AtomicInteger(routeNames.getList().size());
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.hookStorage.get(routeBase + key, routeBody -> {
                        if (routeBody != null) {
                            this.registerRoute((Buffer)routeBody);
                        } else {
                            log.warn("Could not get URL '" + routeBase + key + "' (getting hook route).");
                        }
                        if (storedRoutesCount.decrementAndGet() == 0) {
                            readyHandler.handle(null);
                        }
                    });
                }
            } else {
                log.warn("Could not get URL '" + routeBase + "' (getting hook route).");
                readyHandler.handle(null);
            }
        });
    }

    private void loadStoredListeners(Handler<Void> readyHandler) {
        log.debug("loadStoredListeners");
        String listenerBase = this.hookRootUri + HOOK_LISTENER_STORAGE_PATH;
        this.hookStorage.get(listenerBase, buffer -> {
            if (buffer != null) {
                JsonObject listOfListeners = new JsonObject(buffer.toString());
                JsonArray listenerNames = listOfListeners.getJsonArray("listeners");
                Iterator keys = listenerNames.getList().iterator();
                AtomicInteger storedListenerCount = new AtomicInteger(listenerNames.getList().size());
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.hookStorage.get(listenerBase + key, listenerBody -> {
                        if (listenerBody != null) {
                            this.registerListener((Buffer)listenerBody);
                        } else {
                            log.warn("Could not get URL '" + listenerBase + key + "' (getting hook listener).");
                        }
                        if (storedListenerCount.decrementAndGet() == 0) {
                            readyHandler.handle(null);
                        }
                    });
                }
            } else {
                log.warn("Could not get URL '" + listenerBase + "' (getting hook listener).");
                readyHandler.handle(null);
            }
        });
    }

    private void registerRouteRegistrationHandler(Handler<Void> readyHandler) {
        this.vertx.eventBus().consumer(SAVE_ROUTE_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.hookStorage.get((String)event.body(), buffer -> {
                    if (buffer != null) {
                        HookHandler.this.registerRoute(buffer);
                    } else {
                        log.warn("Could not get URL '" + (event.body() == null ? "<null>" : (String)event.body()) + "' (getting hook route).");
                    }
                });
            }
        });
        this.vertx.eventBus().consumer(REMOVE_ROUTE_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.unregisterRoute((String)event.body());
            }
        });
        readyHandler.handle(null);
    }

    public void registerListenerRegistrationHandler(Handler<Void> readyHandler) {
        this.vertx.eventBus().consumer(SAVE_LISTENER_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.hookStorage.get((String)event.body(), buffer -> {
                    if (buffer != null) {
                        HookHandler.this.registerListener(buffer);
                    } else {
                        log.warn("Could not get URL '" + (event.body() == null ? "<null>" : (String)event.body()) + "' (getting hook listener).");
                    }
                });
            }
        });
        this.vertx.eventBus().consumer(REMOVE_LISTENER_ADDRESS, (Handler)new Handler<Message<String>>(){

            public void handle(Message<String> event) {
                HookHandler.this.unregisterListener((String)event.body());
            }
        });
        readyHandler.handle(null);
    }

    public boolean handle(HttpServerRequest request) {
        boolean consumed = false;
        if (this.isHookListenerRegistration(request)) {
            this.handleListenerRegistration(request);
            return true;
        }
        if (this.isHookListenerUnregistration(request)) {
            this.handleListenerUnregistration(request);
            return true;
        }
        if (this.isHookRouteRegistration(request)) {
            this.handleRouteRegistration(request);
            return true;
        }
        if (this.isHookRouteUnregistration(request)) {
            this.handleRouteUnregistration(request);
            return true;
        }
        List<Listener> listeners = this.listenerRepository.findListeners(request.uri(), request.method().name());
        if (!listeners.isEmpty() && !this.isRequestAlreadyHooked(request)) {
            this.installBodyHandler(request, listeners);
            consumed = true;
        }
        if (!consumed) {
            consumed = this.routeRequestIfNeeded(request);
            if (!consumed) {
                return this.createListingIfRequested(request);
            }
            return consumed;
        }
        return true;
    }

    private boolean createListingIfRequested(HttpServerRequest request) {
        ArrayList<String> collections;
        boolean routesListed;
        String routesListedHeader = request.headers().get(HOOK_ROUTES_LISTED);
        boolean bl = routesListed = routesListedHeader != null && routesListedHeader.equals("true");
        if (request.method().equals((Object)HttpMethod.GET) && !routesListed && !(collections = new ArrayList<String>(this.routeRepository.getCollections(request.uri()))).isEmpty()) {
            String parentUri = request.uri().contains("?") ? request.uri().substring(0, request.uri().indexOf(63)) : request.uri();
            String parentCollection = this.getCollectionName(parentUri);
            collections.sort(this.collectionContentComparator);
            if (log.isTraceEnabled()) {
                log.trace("createListingIfRequested > (parentUri) {}, (parentCollection) {}", (Object)parentUri, (Object)parentCollection);
            }
            HttpClientRequest selfRequest = this.selfClient.request(request.method(), request.uri(), response -> {
                HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)response);
                request.response().headers().remove(HOOK_ROUTES_LISTED);
                if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                    if (log.isTraceEnabled()) {
                        log.trace("createListingIfRequested > use existing array");
                    }
                    response.handler(data -> {
                        JsonObject responseObject = new JsonObject(data.toString());
                        if (responseObject.getValue(parentCollection) instanceof JsonArray) {
                            JsonArray parentCollectionArray = responseObject.getJsonArray(parentCollection);
                            collections.forEach(arg_0 -> ((JsonArray)parentCollectionArray).add(arg_0));
                        }
                        if (log.isTraceEnabled()) {
                            log.trace("createListingIfRequested > response: {}", (Object)responseObject.toString());
                        }
                        request.response().write(Buffer.buffer((String)responseObject.toString()));
                    });
                } else if (response.statusCode() == StatusCode.NOT_FOUND.getStatusCode()) {
                    if (log.isTraceEnabled()) {
                        log.trace("createListingIfRequested > creating new array");
                    }
                    response.handler(data -> {
                        request.response().setStatusCode(StatusCode.OK.getStatusCode());
                        request.response().setStatusMessage(StatusCode.OK.getStatusMessage());
                        JsonObject responseObject = new JsonObject();
                        JsonArray parentCollectionArray = new JsonArray();
                        responseObject.put(parentCollection, parentCollectionArray);
                        collections.forEach(arg_0 -> ((JsonArray)parentCollectionArray).add(arg_0));
                        if (log.isTraceEnabled()) {
                            log.trace("createListingIfRequested > response: {}", (Object)responseObject.toString());
                        }
                        request.response().write(Buffer.buffer((String)responseObject.toString()));
                    });
                } else {
                    log.debug("createListingIfRequested - got response - ERROR");
                    response.handler(data -> request.response().write(data));
                }
                response.endHandler(v -> request.response().end());
            });
            if (request.headers() != null && !request.headers().isEmpty()) {
                selfRequest.headers().setAll(request.headers());
            }
            selfRequest.headers().add(HOOK_ROUTES_LISTED, "true");
            selfRequest.exceptionHandler(exception -> log.warn("HookHandler: listing of collections (routes) failed: " + request.uri() + ": " + exception.getMessage()));
            selfRequest.setTimeout(120000L);
            selfRequest.end();
            return true;
        }
        return false;
    }

    private String getCollectionName(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf("/"));
        }
        return url.substring(url.lastIndexOf("/") + 1, url.length());
    }

    private boolean routeRequestIfNeeded(HttpServerRequest request) {
        Route route = this.routeRepository.getRoute(request.uri());
        if (route != null && (route.getHook().getMethods().isEmpty() || route.getHook().getMethods().contains(request.method().name()))) {
            log.debug("Forward request " + request.uri());
            route.forward(request);
            return true;
        }
        return false;
    }

    private void installBodyHandler(HttpServerRequest request, List<Listener> listeners) {
        request.bodyHandler(buffer -> {
            List<Listener> beforeListener = this.getFilteredListeners(listeners, HookTriggerType.BEFORE);
            List<Listener> afterListener = this.getFilteredListeners(listeners, HookTriggerType.AFTER);
            Handler<Void> afterHandler = this.installAfterHandler(request, (Buffer)buffer, afterListener);
            Handler<Void> beforeHandler = this.installBeforeHandler(request, (Buffer)buffer, beforeListener, afterHandler);
            this.callListener(request, (Buffer)buffer, beforeListener, beforeHandler);
        });
    }

    private void callListener(HttpServerRequest request, Buffer buffer, List<Listener> filteredListeners, Handler<Void> handler) {
        for (Listener listener : filteredListeners) {
            String queue;
            String targetUri;
            log.debug("Enqueue request matching " + request.method() + " " + listener.getMonitoredUrl() + " with listener " + listener.getListener());
            String path = request.uri();
            if (!listener.getHook().isFullUrl()) {
                path = request.uri().replace(listener.getMonitoredUrl(), "");
            }
            if (listener.getHook().getDestination().startsWith("/")) {
                targetUri = listener.getListener() + path;
                log.debug(" > internal target: " + targetUri);
            } else {
                targetUri = this.hookRootUri + LISTENER_HOOK_TARGET_PATH + listener.getListener() + path;
                log.debug(" > external target: " + targetUri);
            }
            VertxHttpHeaders queueHeaders = new VertxHttpHeaders();
            queueHeaders.addAll(request.headers());
            HeaderFunctions.EvalScope evalScope = listener.getHook().getHeaderFunction().apply((MultiMap)queueHeaders);
            if (evalScope.getErrorMessage() != null) {
                log.warn("problem applying header manipulator chain {} in listener {}", (Object)evalScope.getErrorMessage(), (Object)listener.getListenerId());
            }
            if (ExpiryCheckHandler.getQueueExpireAfter((MultiMap)queueHeaders) == null && listener.getHook().getQueueExpireAfter() != -1) {
                ExpiryCheckHandler.setQueueExpireAfter((MultiMap)queueHeaders, (int)listener.getHook().getQueueExpireAfter());
            }
            if ((queue = queueHeaders.get(X_QUEUE)) == null) {
                queue = "listener-hook-" + listener.getListenerId();
            } else {
                queueHeaders.remove(X_QUEUE);
            }
            QueueingStrategy queueingStrategy = listener.getHook().getQueueingStrategy();
            if (queueingStrategy instanceof DefaultQueueingStrategy) {
                this.requestQueue.enqueue(new HttpRequest(request.method(), targetUri, (MultiMap)queueHeaders, buffer.getBytes()), queue, handler);
                continue;
            }
            if (queueingStrategy instanceof DiscardPayloadQueueingStrategy) {
                if (HttpRequestHeader.containsHeader((MultiMap)queueHeaders, (HttpRequestHeader)HttpRequestHeader.CONTENT_LENGTH)) {
                    queueHeaders.set(HttpRequestHeader.CONTENT_LENGTH.getName(), "0");
                }
                this.requestQueue.enqueue(new HttpRequest(request.method(), targetUri, (MultiMap)queueHeaders, null), queue, handler);
                continue;
            }
            if (queueingStrategy instanceof ReducedPropagationQueueingStrategy) {
                if (this.reducedPropagationManager != null) {
                    this.reducedPropagationManager.processIncomingRequest(request.method(), targetUri, (MultiMap)queueHeaders, buffer, queue, ((ReducedPropagationQueueingStrategy)queueingStrategy).getPropagationIntervalMs(), handler);
                    continue;
                }
                log.error("ReducedPropagationQueueingStrategy without configured ReducedPropagationManager. Not going to handle (enqueue) anything!");
                continue;
            }
            log.error("QueueingStrategy '" + queueingStrategy.getClass().getSimpleName() + "' is not handled. Could be an error, check the source code!");
        }
        if (filteredListeners.isEmpty() && handler != null) {
            handler.handle(null);
        }
    }

    private Handler<Void> installAfterHandler(HttpServerRequest request, Buffer buffer, List<Listener> afterListener) {
        Handler afterHandler = event -> this.callListener(request, buffer, afterListener, null);
        return afterHandler;
    }

    private Handler<Void> installBeforeHandler(final HttpServerRequest request, final Buffer buffer, final List<Listener> beforeListener, final Handler<Void> afterHandler) {
        Handler<Void> beforeHandler = new Handler<Void>(){
            private AtomicInteger currentCount = new AtomicInteger(0);
            private boolean sent = false;

            public void handle(Void event) {
                if ((this.currentCount.incrementAndGet() == beforeListener.size() || beforeListener.isEmpty()) && !this.sent) {
                    this.sent = true;
                    Route route = HookHandler.this.routeRepository.getRoute(request.uri());
                    if (route != null && (route.getHook().getMethods().isEmpty() || route.getHook().getMethods().contains(request.method().name()))) {
                        log.debug("Forward request (consumed) " + request.uri());
                        route.forward(request, buffer);
                    } else {
                        request.headers().set(HookHandler.HOOKED_HEADER, "true");
                        HookHandler.this.createSelfRequest(request, buffer, (Handler<Void>)afterHandler);
                    }
                }
            }
        };
        return beforeHandler;
    }

    private List<Listener> getFilteredListeners(List<Listener> listeners, HookTriggerType hookTriggerType) {
        return listeners.stream().filter(listener -> listener.getHook().getHookTriggerType().equals((Object)hookTriggerType)).collect(Collectors.toList());
    }

    private void handleRouteUnregistration(HttpServerRequest request) {
        log.debug("handleRouteUnregistration > " + request.uri());
        String routeStorageUri = this.hookRootUri + HOOK_ROUTE_STORAGE_PATH + this.getStorageIdentifier(request.uri());
        this.hookStorage.delete(routeStorageUri, status -> {
            this.vertx.eventBus().publish(REMOVE_ROUTE_ADDRESS, (Object)request.uri());
            request.response().end();
        });
    }

    private void handleRouteRegistration(HttpServerRequest request) {
        log.debug("handleRouteRegistration > " + request.uri());
        request.bodyHandler(hookData -> {
            JsonObject hook;
            if (this.isHookJsonInvalid(request, (Buffer)hookData)) {
                return;
            }
            String routeStorageUri = this.hookRootUri + HOOK_ROUTE_STORAGE_PATH + this.getStorageIdentifier(request.uri());
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter((MultiMap)request.headers());
            if (expireAfter == null) {
                expireAfter = 3600;
            }
            ExpiryCheckHandler.setExpireAfter((HttpServerRequest)request, (int)expireAfter);
            DateTime expirationTime = ExpiryCheckHandler.getExpirationTime((int)expireAfter);
            try {
                hook = new JsonObject(hookData.toString());
            }
            catch (DecodeException e) {
                this.badRequest(request, "Cannot decode JSON", e.getMessage());
                return;
            }
            JsonObject storageObject = new JsonObject();
            storageObject.put(REQUESTURL, request.uri());
            storageObject.put(EXPIRATION_TIME, ExpiryCheckHandler.printDateTime((DateTime)expirationTime));
            storageObject.put(HOOK, hook);
            Buffer buffer = Buffer.buffer((String)storageObject.toString());
            this.hookStorage.put(routeStorageUri, request.headers(), buffer, status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    if (this.logHookConfigurationResourceChanges) {
                        RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                    }
                    this.vertx.eventBus().publish(SAVE_ROUTE_ADDRESS, (Object)routeStorageUri);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        });
    }

    private String getStorageIdentifier(String url) {
        return url.replace("/", "+");
    }

    private void handleListenerUnregistration(HttpServerRequest request) {
        log.debug("handleListenerUnregistration > " + request.uri());
        String listenerStorageUri = this.hookRootUri + HOOK_LISTENER_STORAGE_PATH + this.getUniqueListenerId(request.uri());
        this.hookStorage.delete(listenerStorageUri, status -> {
            this.vertx.eventBus().publish(REMOVE_LISTENER_ADDRESS, (Object)request.uri());
            request.response().end();
        });
    }

    private void handleListenerRegistration(HttpServerRequest request) {
        log.debug("handleListenerRegistration > " + request.uri());
        request.bodyHandler(hookData -> {
            JsonObject hook;
            if (this.isListenerJsonInvalid(request, (Buffer)hookData)) {
                return;
            }
            try {
                hook = new JsonObject(hookData);
            }
            catch (DecodeException e) {
                log.error("Cannot decode JSON", (Throwable)e);
                this.badRequest(request, "Cannot decode JSON", e.getMessage());
                return;
            }
            String destination = hook.getString("destination");
            String hookOnUri = this.getMonitoredUrlSegment(request.uri());
            if (destination.startsWith(hookOnUri)) {
                this.badRequest(request, "illegal destination", "Destination-URI should not be within subtree of your hooked resource. This would lead to an infinite loop.");
                return;
            }
            String listenerStorageUri = this.hookRootUri + HOOK_LISTENER_STORAGE_PATH + this.getUniqueListenerId(request.uri());
            String expirationTime = HookHandler.extractExpTimeAndManipulatePassedRequestAndReturnExpTime(request).orElse(null);
            if (log.isDebugEnabled()) {
                log.debug("Hook " + request.uri() + " expirationTime is " + expirationTime + ".");
            }
            JsonObject storageObject = new JsonObject();
            storageObject.put(REQUESTURL, request.uri());
            storageObject.put(EXPIRATION_TIME, expirationTime);
            storageObject.put(HOOK, hook);
            Buffer buffer = Buffer.buffer((String)storageObject.toString());
            this.hookStorage.put(listenerStorageUri, request.headers(), buffer, status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    if (this.logHookConfigurationResourceChanges) {
                        RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                    }
                    this.vertx.eventBus().publish(SAVE_LISTENER_ADDRESS, (Object)listenerStorageUri);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        });
    }

    private boolean isListenerJsonInvalid(HttpServerRequest request, Buffer hookData) {
        JsonObject hook;
        if (this.isHookJsonInvalid(request, hookData)) {
            return true;
        }
        try {
            hook = new JsonObject(hookData);
        }
        catch (DecodeException e) {
            log.error("Cannot decode JSON", (Throwable)e);
            this.badRequest(request, "Cannot decode JSON", e.getMessage());
            return true;
        }
        JsonArray methods = hook.getJsonArray("methods");
        if (methods != null) {
            for (Object method : methods) {
                if (QueueProcessor.httpMethodIsQueueable((HttpMethod)HttpMethod.valueOf((String)((String)method)))) continue;
                String msg = "Listener registration request tries to hook for not allowed '" + method + "' method.";
                log.error(msg);
                this.badRequest(request, "Bad Request", msg + "\n");
                return true;
            }
        }
        return false;
    }

    public boolean isHookJsonInvalid(HttpServerRequest request, Buffer hookData) {
        try {
            JsonNode hook = OBJECT_MAPPER.readTree(hookData.getBytes());
            Set valMsgs = this.jsonSchemaHook.validate(hook);
            if (valMsgs.size() > 0) {
                this.badRequest(request, "Hook JSON invalid", valMsgs.toString());
                return true;
            }
        }
        catch (Exception ex) {
            log.error("Cannot decode JSON", (Throwable)ex);
            this.badRequest(request, "Cannot decode JSON", ex.getMessage());
            return true;
        }
        return false;
    }

    private void badRequest(HttpServerRequest request, String statusMsg, String longMsg) {
        HttpServerResponse response = request.response();
        response.setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage(statusMsg);
        request.response().end(longMsg);
    }

    private void createSelfRequest(HttpServerRequest request, Buffer requestBody, Handler<Void> afterHandler) {
        log.debug("Create self request for " + request.uri());
        HttpClientRequest selfRequest = this.selfClient.request(request.method(), request.uri(), response -> {
            HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)response);
            response.handler(data -> request.response().write(data));
            response.endHandler(v -> request.response().end());
            if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                afterHandler.handle(null);
            }
        });
        if (request.headers() != null && !request.headers().isEmpty()) {
            selfRequest.headers().setAll(request.headers());
        }
        selfRequest.exceptionHandler(exception -> log.warn("HookHandler HOOK_ERROR: Failed self request to " + request.uri() + ": " + exception.getMessage()));
        selfRequest.setTimeout(120000L);
        if (requestBody != null) {
            selfRequest.end(requestBody);
        } else {
            selfRequest.end();
        }
    }

    public boolean isRequestAlreadyHooked(HttpServerRequest request) {
        String hooked = request.headers().get(HOOKED_HEADER);
        return hooked != null ? hooked.equals("true") : false;
    }

    private void unregisterRoute(String requestUrl) {
        String routedUrl = this.getRoutedUrlSegment(requestUrl);
        log.debug("Unregister route " + routedUrl);
        this.routeRepository.removeRoute(routedUrl);
        this.monitoringHandler.updateRoutesCount((long)this.routeRepository.getRoutes().size());
    }

    private void unregisterListener(String requestUrl) {
        String listenerId = this.getUniqueListenerId(requestUrl);
        log.debug("Unregister listener " + listenerId);
        this.routeRepository.removeRoute(this.hookRootUri + LISTENER_HOOK_TARGET_PATH + this.getListenerUrlSegment(requestUrl));
        this.listenerRepository.removeListener(listenerId);
        this.monitoringHandler.updateListenerCount((long)this.listenerRepository.size());
    }

    private void registerListener(Buffer buffer) {
        JsonObject storageObject = new JsonObject(buffer.toString());
        String requestUrl = storageObject.getString(REQUESTURL);
        if (log.isTraceEnabled()) {
            log.trace("Request URL: " + requestUrl);
        }
        String target = this.getListenerUrlSegment(requestUrl);
        String listenerId = this.getUniqueListenerId(requestUrl);
        if (log.isTraceEnabled()) {
            log.trace("Target (1st): " + target);
        }
        JsonObject jsonHook = storageObject.getJsonObject(HOOK);
        JsonArray jsonMethods = jsonHook.getJsonArray("methods");
        HttpHook hook = new HttpHook(jsonHook.getString("destination"));
        if (jsonMethods != null) {
            hook.setMethods(jsonMethods.getList());
        }
        if (jsonHook.containsKey("filter")) {
            hook.setFilter(jsonHook.getString("filter"));
        }
        if (jsonHook.getInteger(QUEUE_EXPIRE_AFTER) != null) {
            hook.setQueueExpireAfter(jsonHook.getInteger(QUEUE_EXPIRE_AFTER));
        }
        if (jsonHook.getString(HOOK_TRIGGER_TYPE) != null) {
            try {
                hook.setHookTriggerType(HookTriggerType.valueOf(jsonHook.getString(HOOK_TRIGGER_TYPE).toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Listener " + listenerId + " for target " + target + " has an invalid trigger type " + jsonHook.getString(HOOK_TRIGGER_TYPE) + " and will not be registred!", (Throwable)e);
                return;
            }
        }
        this.extractAndAddStaticHeadersToHook(jsonHook, hook);
        this.extractAndAddProxyOptionsToHook(jsonHook, hook);
        String expirationTimeExpression = storageObject.getString(EXPIRATION_TIME);
        if (expirationTimeExpression == null) {
            log.debug("Register listener and route " + target + " with infinite expiration.");
            hook.setExpirationTime(null);
        } else {
            DateTime expirationTime;
            try {
                expirationTime = ExpiryCheckHandler.parseDateTime((String)expirationTimeExpression);
            }
            catch (RuntimeException e) {
                log.warn("Listener " + listenerId + " for target " + target + " has an invalid expiration time " + expirationTimeExpression + " and will not be registred!", (Throwable)e);
                return;
            }
            log.debug("Register listener and route " + target + " with expiration at " + expirationTime);
            hook.setExpirationTime(expirationTime);
        }
        hook.setFullUrl(jsonHook.getBoolean(FULL_URL, Boolean.valueOf(false)));
        hook.setQueueingStrategy(QueueingStrategyFactory.buildQueueStrategy(jsonHook));
        if (hook.getDestination().startsWith("/")) {
            if (log.isTraceEnabled()) {
                log.trace("internal target, switching target!");
            }
            target = hook.getDestination();
        } else {
            String urlPattern = this.hookRootUri + LISTENER_HOOK_TARGET_PATH + target;
            this.routeRepository.addRoute(urlPattern, this.createRoute(urlPattern, hook));
            if (log.isTraceEnabled()) {
                log.trace("external target, add route for urlPattern: " + urlPattern);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Target (2nd): " + target);
        }
        this.listenerRepository.addListener(new Listener(listenerId, this.getMonitoredUrlSegment(requestUrl), target, hook));
        this.monitoringHandler.updateListenerCount((long)this.listenerRepository.size());
    }

    private void extractAndAddProxyOptionsToHook(JsonObject jsonHook, HttpHook hook) {
        JsonObject proxyOptions = jsonHook.getJsonObject("proxyOptions");
        if (proxyOptions != null) {
            hook.setProxyOptions(new ProxyOptions(proxyOptions));
        }
    }

    private void extractAndAddStaticHeadersToHook(JsonObject jsonHook, HttpHook hook) {
        JsonArray headers = jsonHook.getJsonArray("headers");
        if (headers != null) {
            HeaderFunction headerFunction = HeaderFunctions.parseFromJson((JsonArray)headers);
            hook.setHeaderFunction(headerFunction);
            return;
        }
        JsonObject staticHeaders = jsonHook.getJsonObject(STATIC_HEADERS);
        if (staticHeaders != null) {
            log.warn("you use the deprecated \"staticHeaders\" syntax in your hook (" + jsonHook + "). Please migrate to the more flexible \"headers\" syntax");
            hook.setHeaderFunction(HeaderFunctions.parseStaticHeadersFromJson((JsonObject)staticHeaders));
        }
    }

    protected String getUniqueListenerId(String requestUrl) {
        StringBuilder listenerId = new StringBuilder();
        listenerId.append(this.convertToStoragePattern(this.getListenerUrlSegment(requestUrl)));
        listenerId.append(this.convertToStoragePattern(this.getMonitoredUrlSegment(requestUrl)));
        return listenerId.toString();
    }

    private String convertToStoragePattern(String urlSegment) {
        return urlSegment.replace("/", "+").replace(".", "+").replace(":", "+");
    }

    private void registerRoute(Buffer buffer) {
        JsonObject storageObject = new JsonObject(buffer.toString());
        String requestUrl = storageObject.getString(REQUESTURL);
        String routedUrl = this.getRoutedUrlSegment(requestUrl);
        log.debug("Register route to  " + routedUrl);
        JsonObject jsonHook = storageObject.getJsonObject(HOOK);
        JsonArray jsonMethods = jsonHook.getJsonArray("methods");
        HttpHook hook = new HttpHook(jsonHook.getString("destination"));
        if (jsonMethods != null) {
            hook.setMethods(jsonMethods.getList());
        }
        if (jsonHook.getInteger(QUEUE_EXPIRE_AFTER) != null) {
            hook.setQueueExpireAfter(jsonHook.getInteger(QUEUE_EXPIRE_AFTER));
        }
        if (jsonHook.getBoolean(LISTABLE) != null) {
            hook.setListable(jsonHook.getBoolean(LISTABLE));
        } else {
            hook.setListable(this.listableRoutes);
        }
        if (jsonHook.getBoolean(COLLECTION) != null) {
            hook.setCollection(jsonHook.getBoolean(COLLECTION));
        }
        this.extractAndAddStaticHeadersToHook(jsonHook, hook);
        this.extractAndAddProxyOptionsToHook(jsonHook, hook);
        String expirationTimeExpression = storageObject.getString(EXPIRATION_TIME);
        if (expirationTimeExpression != null) {
            try {
                hook.setExpirationTime(ExpiryCheckHandler.parseDateTime((String)expirationTimeExpression));
            }
            catch (Exception e) {
                log.warn("Route " + routedUrl + " has an invalid expiration time " + expirationTimeExpression + " and will not be registred!");
                return;
            }
        } else {
            log.warn("Route " + routedUrl + " has no expiration time and will not be registred!");
            return;
        }
        hook.setFullUrl(storageObject.getBoolean(FULL_URL, Boolean.valueOf(false)));
        hook.setQueueingStrategy(QueueingStrategyFactory.buildQueueStrategy(storageObject));
        hook.setConnectionPoolSize(jsonHook.getInteger("connectionPoolSize"));
        boolean mustCreateNewRoute = true;
        Route existingRoute = this.routeRepository.getRoutes().get(routedUrl);
        if (existingRoute != null) {
            mustCreateNewRoute = this.mustCreateNewRouteForHook(existingRoute, hook);
        }
        if (mustCreateNewRoute) {
            this.routeRepository.addRoute(routedUrl, this.createRoute(routedUrl, hook));
        } else {
            existingRoute.getRule().setHeaderFunction(hook.getHeaderFunction());
            existingRoute.getHook().setExpirationTime(hook.getExpirationTime().orElse(null));
        }
        this.monitoringHandler.updateRoutesCount((long)this.routeRepository.getRoutes().size());
    }

    private boolean mustCreateNewRouteForHook(Route existingRoute, HttpHook newHook) {
        HttpHook oldHook = existingRoute.getHook();
        boolean same = Objects.equals(oldHook.getDestination(), newHook.getDestination());
        same &= Objects.equals(oldHook.getMethods(), newHook.getMethods());
        same &= oldHook.isCollection() == newHook.isCollection();
        same &= oldHook.isFullUrl() == newHook.isFullUrl();
        same &= oldHook.isListable() == newHook.isListable();
        same &= oldHook.isCollection() == newHook.isCollection();
        same &= oldHook.isCollection() == newHook.isCollection();
        return !(same &= Objects.equals(oldHook.getConnectionPoolSize(), newHook.getConnectionPoolSize()));
    }

    private Route createRoute(String urlPattern, HttpHook hook) {
        return new Route(this.vertx, this.userProfileStorage, this.loggingResourceManager, this.monitoringHandler, this.userProfilePath, hook, urlPattern, this.selfClient);
    }

    private String getRoutedUrlSegment(String requestUrl) {
        return requestUrl.substring(0, requestUrl.indexOf(HOOKS_ROUTE_URI_PART));
    }

    private String getMonitoredUrlSegment(String requestUrl) {
        return requestUrl.substring(0, requestUrl.indexOf(HOOKS_LISTENERS_URI_PART));
    }

    private String getListenerUrlSegment(String requestUrl) {
        int pos = requestUrl.indexOf(HOOKS_LISTENERS_URI_PART);
        String segment = requestUrl.substring(pos + HOOKS_LISTENERS_URI_PART.length());
        return segment;
    }

    private boolean isHookListenerUnregistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_LISTENERS_URI_PART) && HttpMethod.DELETE == request.method();
    }

    private boolean isHookListenerRegistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_LISTENERS_URI_PART) && HttpMethod.PUT == request.method();
    }

    private boolean isHookRouteRegistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_ROUTE_URI_PART) && HttpMethod.PUT == request.method();
    }

    private boolean isHookRouteUnregistration(HttpServerRequest request) {
        return request.uri().contains(HOOKS_ROUTE_URI_PART) && HttpMethod.DELETE == request.method();
    }

    private static Optional<String> extractExpTimeAndManipulatePassedRequestAndReturnExpTime(HttpServerRequest request) {
        int expireAfter = ExpiryCheckHandler.getExpireAfterConcerningCaseOfCorruptHeaderAndInfinite((MultiMap)request.headers()).orElse(3600);
        String expirationTime = ExpiryCheckHandler.getExpirationTimeAsString((int)expireAfter).orElse(null);
        ExpiryCheckHandler.setExpireAfter((HttpServerRequest)request, (int)expireAfter);
        return Optional.ofNullable(expirationTime);
    }

    private static /* synthetic */ void lambda$init$0(Handler readyHandler, Consumer handlerConsumer) {
        handlerConsumer.accept(readyHandler);
    }
}

