/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import io.vertx.core.net.ProxyOptions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.swisspush.gateleen.core.http.HeaderFunction;
import org.swisspush.gateleen.core.http.HeaderFunctions;
import org.swisspush.gateleen.hook.HookTriggerType;
import org.swisspush.gateleen.hook.queueingstrategy.DefaultQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategy;

public class HttpHook {
    public static final String CONNECTION_POOL_SIZE_PROPERTY_NAME = "connectionPoolSize";
    public static final String CONNECTION_MAX_WAIT_QUEUE_SIZE_PROPERTY_NAME = "maxWaitQueueSize";
    public static final int CONNECTION_POOL_SIZE_DEFAULT_VALUE = 50;
    public static final int CONNECTION_MAX_WAIT_QUEUE_SIZE_DEFAULT_VALUE = -1;
    private String destination;
    private List<String> methods;
    private Map<Pattern, Integer> translateStatus;
    private DateTime expirationTime;
    private boolean fullUrl = false;
    private QueueingStrategy queueingStrategy = new DefaultQueueingStrategy();
    private Pattern filter = null;
    private int queueExpireAfter;
    private HeaderFunction headerFunction = HeaderFunctions.DO_NOTHING;
    private HookTriggerType hookTriggerType;
    private boolean listable = false;
    private boolean collection = true;
    private Integer connectionPoolSize = null;
    private Integer maxWaitQueueSize = null;
    private ProxyOptions proxyOptions = null;

    public HttpHook(String destination) {
        this.destination = destination;
        this.methods = new ArrayList<String>();
        this.translateStatus = new HashMap<Pattern, Integer>();
        this.queueExpireAfter = -1;
        this.hookTriggerType = HookTriggerType.BEFORE;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public List<String> getMethods() {
        return this.methods;
    }

    public void setMethods(List<String> methods) {
        this.methods = methods;
    }

    public Map<Pattern, Integer> getTranslateStatus() {
        return this.translateStatus;
    }

    public void addTranslateStatus(Pattern key, Integer value) {
        this.translateStatus.put(key, value);
    }

    public Optional<DateTime> getExpirationTime() {
        return Optional.ofNullable(this.expirationTime);
    }

    public void setExpirationTime(DateTime expirationTime) {
        this.expirationTime = expirationTime;
    }

    public boolean isFullUrl() {
        return this.fullUrl;
    }

    public void setFullUrl(boolean fullUrl) {
        this.fullUrl = fullUrl;
    }

    public QueueingStrategy getQueueingStrategy() {
        return this.queueingStrategy;
    }

    public void setQueueingStrategy(QueueingStrategy queueingStrategy) {
        this.queueingStrategy = queueingStrategy;
    }

    public Pattern getFilter() {
        return this.filter;
    }

    public void setFilter(String regex) {
        this.filter = Pattern.compile(regex);
    }

    public int getQueueExpireAfter() {
        return this.queueExpireAfter;
    }

    public void setQueueExpireAfter(int queueExpireAfter) {
        this.queueExpireAfter = queueExpireAfter;
    }

    public HeaderFunction getHeaderFunction() {
        return this.headerFunction;
    }

    public void setHeaderFunction(HeaderFunction headerFunction) {
        this.headerFunction = headerFunction;
    }

    public HookTriggerType getHookTriggerType() {
        return this.hookTriggerType;
    }

    public void setHookTriggerType(HookTriggerType hookTriggerType) {
        this.hookTriggerType = hookTriggerType;
    }

    public boolean isListable() {
        return this.listable;
    }

    public void setListable(boolean listable) {
        this.listable = listable;
    }

    public boolean isCollection() {
        return this.collection;
    }

    public void setCollection(boolean collection) {
        this.collection = collection;
    }

    public Integer getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public void setConnectionPoolSize(Integer connectionPoolSize) {
        if (connectionPoolSize != null && connectionPoolSize < 1) {
            throw new IllegalArgumentException("Values below 1 not valid.");
        }
        this.connectionPoolSize = connectionPoolSize;
    }

    public Integer getMaxWaitQueueSize() {
        return this.maxWaitQueueSize;
    }

    public void setMaxWaitQueueSize(Integer maxWaitQueueSize) {
        if (maxWaitQueueSize != null && maxWaitQueueSize < -1) {
            throw new IllegalArgumentException("Values below -1 not valid.");
        }
        this.maxWaitQueueSize = maxWaitQueueSize;
    }

    public ProxyOptions getProxyOptions() {
        return this.proxyOptions;
    }

    public void setProxyOptions(ProxyOptions proxyOptions) {
        this.proxyOptions = proxyOptions;
    }
}

