/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook.reducedpropagation.lua;

import io.vertx.core.Promise;
import io.vertx.redis.client.RedisAPI;
import io.vertx.redis.client.Response;
import io.vertx.redis.client.impl.types.MultiType;
import java.util.List;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.lua.LuaScriptState;
import org.swisspush.gateleen.core.lua.RedisCommand;
import org.swisspush.gateleen.core.util.RedisUtils;

public class RemoveExpiredQueuesRedisCommand
implements RedisCommand {
    private LuaScriptState luaScriptState;
    private List<String> keys;
    private List<String> arguments;
    private Promise<Response> promise;
    private RedisAPI redisAPI;
    private Logger log;

    public RemoveExpiredQueuesRedisCommand(LuaScriptState luaScriptState, List<String> keys, List<String> arguments, RedisAPI redisAPI, Logger log, Promise<Response> promise) {
        this.luaScriptState = luaScriptState;
        this.keys = keys;
        this.arguments = arguments;
        this.redisAPI = redisAPI;
        this.log = log;
        this.promise = promise;
    }

    public void exec(int executionCounter) {
        List args = RedisUtils.toPayload((Object[])new Object[]{this.luaScriptState.getSha(), this.keys.size(), this.keys, this.arguments});
        this.redisAPI.evalsha(args, event -> {
            if (event.succeeded()) {
                Response response = (Response)event.result();
                if (response != null && response.size() != 0) {
                    this.promise.complete((Object)response);
                } else {
                    this.promise.complete((Object)MultiType.EMPTY_MULTI);
                }
            } else {
                String message = event.cause().getMessage();
                if (message != null && message.startsWith("NOSCRIPT")) {
                    this.log.warn("RemoveExpiredQueuesRedisCommand script couldn't be found, reload it");
                    this.log.warn("amount the script got loaded: " + String.valueOf(executionCounter));
                    if (executionCounter > 10) {
                        this.promise.fail("amount the script got loaded is higher than 10, we abort");
                    } else {
                        this.luaScriptState.loadLuaScript((RedisCommand)new RemoveExpiredQueuesRedisCommand(this.luaScriptState, this.keys, this.arguments, this.redisAPI, this.log, this.promise), executionCounter);
                    }
                } else {
                    this.promise.fail("RemoveExpiredQueuesRedisCommand request failed with message: " + message);
                }
            }
        });
    }
}

