/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.headers.HeadersMultiMap;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.ProxyOptions;
import io.vertx.ext.web.RoutingContext;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.http.HeaderFunction;
import org.swisspush.gateleen.core.http.HeaderFunctions;
import org.swisspush.gateleen.core.http.HttpRequest;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.CollectionContentComparator;
import org.swisspush.gateleen.core.util.ExpiryCheckHandler;
import org.swisspush.gateleen.core.util.HttpHeaderUtil;
import org.swisspush.gateleen.core.util.HttpRequestHeader;
import org.swisspush.gateleen.core.util.HttpServerRequestUtil;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.hook.HookTriggerType;
import org.swisspush.gateleen.hook.HttpHook;
import org.swisspush.gateleen.hook.Listener;
import org.swisspush.gateleen.hook.ListenerRepository;
import org.swisspush.gateleen.hook.LocalListenerRepository;
import org.swisspush.gateleen.hook.LocalRouteRepository;
import org.swisspush.gateleen.hook.Route;
import org.swisspush.gateleen.hook.RouteRepository;
import org.swisspush.gateleen.hook.queueingstrategy.DefaultQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.DiscardPayloadQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategyFactory;
import org.swisspush.gateleen.hook.queueingstrategy.ReducedPropagationQueueingStrategy;
import org.swisspush.gateleen.hook.reducedpropagation.ReducedPropagationManager;
import org.swisspush.gateleen.logging.LogAppenderRepository;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.queue.queuing.QueueClient;
import org.swisspush.gateleen.queue.queuing.QueueProcessor;
import org.swisspush.gateleen.queue.queuing.RequestQueue;
import org.swisspush.gateleen.queue.queuing.splitter.NoOpQueueSplitter;
import org.swisspush.gateleen.queue.queuing.splitter.QueueSplitter;
import org.swisspush.gateleen.routing.RuleFactory;
import org.swisspush.gateleen.validation.RegexpValidator;
import org.swisspush.gateleen.validation.ValidationException;

public class HookHandler
implements LoggableResource {
    public static final String HOOKED_HEADER = "x-hooked";
    public static final String HOOK_ROUTES_LISTED = "x-hook-routes-listed";
    public static final String HOOKS_LISTENERS_URI_PART = "/_hooks/listeners/";
    public static final String LISTENER_QUEUE_PREFIX = "listener-hook";
    private static final String X_QUEUE = "x-queue";
    private static final String LISTENER_HOOK_TARGET_PATH = "listeners/";
    public static final String HOOKS_ROUTE_URI_PART = "/_hooks/route";
    private static final String HOOK_STORAGE_PATH = "registrations/";
    private static final String HOOK_LISTENER_STORAGE_PATH = "registrations/listeners/";
    private static final String HOOK_ROUTE_STORAGE_PATH = "registrations/routes/";
    private static final String SAVE_LISTENER_ADDRESS = "gateleen.hook-listener-insert";
    private static final String REMOVE_LISTENER_ADDRESS = "gateleen.hook-listener-remove";
    private static final String SAVE_ROUTE_ADDRESS = "gateleen.hook-route-insert";
    private static final String REMOVE_ROUTE_ADDRESS = "gateleen.hook-route-remove";
    private static final int STATUS_CODE_2XX = 2;
    private static final int DEFAULT_HOOK_STORAGE_EXPIRE_AFTER_TIME = 3600;
    private static final int DEFAULT_CLEANUP_TIME = 15000;
    public static final String REQUESTURL = "requesturl";
    public static final String EXPIRATION_TIME = "expirationTime";
    public static final String HOOK = "hook";
    public static final String TRANSLATE_STATUS = "translateStatus";
    public static final String METHODS = "methods";
    public static final String HEADERS_FILTER = "headersFilter";
    public static final String DESTINATION = "destination";
    public static final String FILTER = "filter";
    public static final String QUEUE_EXPIRE_AFTER = "queueExpireAfter";
    public static final String STATIC_HEADERS = "staticHeaders";
    public static final String FULL_URL = "fullUrl";
    public static final String DISCARD_PAYLOAD = "discardPayload";
    public static final String HOOK_TRIGGER_TYPE = "type";
    public static final String LISTABLE = "listable";
    public static final String COLLECTION = "collection";
    private static final String CONTENT_TYPE_JSON = "application/json";
    private static final String LISTENERS_KEY = "listeners";
    private static final String ROUTES_KEY = "routes";
    private final Comparator<String> collectionContentComparator;
    private static final Logger log = LoggerFactory.getLogger(HookHandler.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final JsonSchemaFactory JSON_SCHEMA_FACTORY = JsonSchemaFactory.getInstance();
    private final Vertx vertx;
    private final ResourceStorage userProfileStorage;
    private final ResourceStorage hookStorage;
    private final MonitoringHandler monitoringHandler;
    private final LoggingResourceManager loggingResourceManager;
    private final LogAppenderRepository logAppenderRepository;
    private final HttpClient selfClient;
    private final String userProfilePath;
    private final String hookRootUri;
    private final boolean listableRoutes;
    private final ListenerRepository listenerRepository;
    final RouteRepository routeRepository;
    private final RequestQueue requestQueue;
    private final ReducedPropagationManager reducedPropagationManager;
    private boolean logHookConfigurationResourceChanges = false;
    private final Handler<Void> doneHandler;
    private final JsonSchema jsonSchemaHook;
    private int routeMultiplier;
    private final QueueSplitter queueSplitter;
    private final String routeBase;
    private final String listenerBase;
    private final String normalizedRouteBase;
    private final String normalizedListenerBase;
    private final AtomicLong listenerCount = new AtomicLong(0L);
    private final AtomicLong routesCount = new AtomicLong(0L);
    private MeterRegistry meterRegistry;

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, @Nullable MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri) {
        this(vertx, selfClient, storage, loggingResourceManager, logAppenderRepository, monitoringHandler, userProfilePath, hookRootUri, (RequestQueue)new QueueClient(vertx, monitoringHandler));
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, @Nullable MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue) {
        this(vertx, selfClient, storage, loggingResourceManager, logAppenderRepository, monitoringHandler, userProfilePath, hookRootUri, requestQueue, false);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, @Nullable MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes) {
        this(vertx, selfClient, storage, loggingResourceManager, logAppenderRepository, monitoringHandler, userProfilePath, hookRootUri, requestQueue, false, null);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage storage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, @Nullable MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes, @Nullable ReducedPropagationManager reducedPropagationManager) {
        this(vertx, selfClient, storage, loggingResourceManager, logAppenderRepository, monitoringHandler, userProfilePath, hookRootUri, requestQueue, listableRoutes, reducedPropagationManager, null, storage);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage userProfileStorage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, @Nullable MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes, ReducedPropagationManager reducedPropagationManager, @Nullable Handler doneHandler, ResourceStorage hookStorage) {
        this(vertx, selfClient, userProfileStorage, loggingResourceManager, logAppenderRepository, monitoringHandler, userProfilePath, hookRootUri, requestQueue, listableRoutes, reducedPropagationManager, doneHandler, hookStorage, 1);
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage userProfileStorage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, @Nullable MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes, ReducedPropagationManager reducedPropagationManager, @Nullable Handler doneHandler, ResourceStorage hookStorage, int routeMultiplier) {
        this(vertx, selfClient, userProfileStorage, loggingResourceManager, logAppenderRepository, monitoringHandler, userProfilePath, hookRootUri, requestQueue, listableRoutes, reducedPropagationManager, doneHandler, hookStorage, routeMultiplier, (QueueSplitter)new NoOpQueueSplitter());
    }

    public HookHandler(Vertx vertx, HttpClient selfClient, ResourceStorage userProfileStorage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, @Nullable MonitoringHandler monitoringHandler, String userProfilePath, String hookRootUri, RequestQueue requestQueue, boolean listableRoutes, ReducedPropagationManager reducedPropagationManager, @Nullable Handler doneHandler, ResourceStorage hookStorage, int routeMultiplier, @Nonnull QueueSplitter queueSplitter) {
        log.debug("Creating HookHandler ...");
        this.vertx = vertx;
        this.selfClient = selfClient;
        this.userProfileStorage = userProfileStorage;
        this.loggingResourceManager = loggingResourceManager;
        this.logAppenderRepository = logAppenderRepository;
        this.monitoringHandler = monitoringHandler;
        this.userProfilePath = userProfilePath;
        this.hookRootUri = hookRootUri;
        this.requestQueue = requestQueue;
        this.listableRoutes = listableRoutes;
        this.reducedPropagationManager = reducedPropagationManager;
        this.listenerRepository = new LocalListenerRepository();
        this.routeRepository = new LocalRouteRepository();
        this.collectionContentComparator = new CollectionContentComparator();
        this.doneHandler = doneHandler;
        this.hookStorage = hookStorage;
        this.routeMultiplier = routeMultiplier;
        this.queueSplitter = queueSplitter;
        String hookSchema = ResourcesUtils.loadResource((String)"gateleen_hooking_schema_hook", (boolean)true);
        this.jsonSchemaHook = JSON_SCHEMA_FACTORY.getSchema(hookSchema);
        this.listenerBase = hookRootUri + HOOK_LISTENER_STORAGE_PATH;
        this.routeBase = hookRootUri + HOOK_ROUTE_STORAGE_PATH;
        this.normalizedListenerBase = this.listenerBase.replaceAll("/+$", "");
        this.normalizedRouteBase = this.routeBase.replaceAll("/+$", "");
    }

    public void init() {
        final ArrayList<Consumer<Handler>> initMethods = new ArrayList<Consumer<Handler>>();
        initMethods.add(this::registerListenerRegistrationHandler);
        initMethods.add(this::registerRouteRegistrationHandler);
        initMethods.add(this::loadStoredListeners);
        initMethods.add(this::loadStoredRoutes);
        initMethods.add(this::registerCleanupHandler);
        initMethods.add(this::registerRouteMultiplierChangeHandler);
        Handler<Void> readyHandler = new Handler<Void>(){
            private final AtomicInteger readyCounter;
            {
                this.readyCounter = new AtomicInteger(initMethods.size());
            }

            public void handle(Void aVoid) {
                if (this.readyCounter.decrementAndGet() == 0) {
                    log.info("HookHandler is ready!");
                    if (HookHandler.this.doneHandler != null) {
                        HookHandler.this.doneHandler.handle(null);
                    }
                }
            }
        };
        initMethods.forEach(arg_0 -> HookHandler.lambda$init$0((Handler)readyHandler, arg_0));
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        if (meterRegistry != null) {
            Gauge.builder((String)"gateleen.listener.count", (Object)this.listenerCount, AtomicLong::get).description("Amount of listener hooks currently registered").register(meterRegistry);
            Gauge.builder((String)"gateleen.routes.count", (Object)this.routesCount, AtomicLong::get).description("Amount of route hooks currently registered").register(meterRegistry);
        }
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logHookConfigurationResourceChanges = resourceLoggingEnabled;
    }

    private void registerCleanupHandler(Handler<Void> readyHandler) {
        this.vertx.setPeriodic(15000L, timerID -> {
            log.trace("Running hook cleanup ...");
            DateTime now = DateTime.now();
            for (Listener listener : this.listenerRepository.getListeners()) {
                Optional<DateTime> expirationTime = listener.getHook().getExpirationTime();
                if (expirationTime.isEmpty()) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Listener {} will never expire.", (Object)listener.getListenerId());
                    continue;
                }
                if (!expirationTime.get().isBefore((ReadableInstant)now)) continue;
                log.debug("Listener {} expired at {} and current time is {}", new Object[]{listener.getListenerId(), expirationTime.get(), now});
                this.listenerRepository.removeListener(listener.getListenerId());
                this.routeRepository.removeRoute(this.hookRootUri + LISTENER_HOOK_TARGET_PATH + listener.getListenerId());
            }
            Map<String, Route> routes = this.routeRepository.getRoutes();
            for (String key : routes.keySet()) {
                Route route = routes.get(key);
                Optional<DateTime> expirationTime = route.getHook().getExpirationTime();
                if (expirationTime.isEmpty()) {
                    if (!log.isTraceEnabled()) continue;
                    log.trace("Route {} will never expire.", (Object)key);
                    continue;
                }
                if (!expirationTime.get().isBefore((ReadableInstant)now)) continue;
                this.routeRepository.removeRoute(key);
            }
            if (this.meterRegistry != null) {
                this.listenerCount.set(this.listenerRepository.size());
                this.routesCount.set(this.routeRepository.getRoutes().size());
            }
            if (this.monitoringHandler != null) {
                this.monitoringHandler.updateListenerCount((long)this.listenerRepository.size());
                this.monitoringHandler.updateRoutesCount((long)this.routeRepository.getRoutes().size());
            }
            log.trace("done");
        });
        readyHandler.handle(null);
    }

    private void loadStoredRoutes(Handler<Void> readyHandler) {
        log.debug("loadStoredRoutes");
        this.hookStorage.get(this.routeBase, buffer -> {
            if (buffer != null) {
                JsonObject listOfRoutes = new JsonObject(buffer.toString());
                JsonArray routeNames = listOfRoutes.getJsonArray(ROUTES_KEY);
                Iterator keys = routeNames.getList().iterator();
                AtomicInteger storedRoutesCount = new AtomicInteger(routeNames.getList().size());
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.hookStorage.get(this.routeBase + key, routeBody -> {
                        if (routeBody != null) {
                            this.registerRoute((Buffer)routeBody);
                        } else {
                            log.warn("Could not get URL '{}' (getting hook route).", (Object)(this.routeBase + key));
                        }
                        if (storedRoutesCount.decrementAndGet() == 0) {
                            readyHandler.handle(null);
                        }
                    });
                }
            } else {
                log.warn("Could not get URL '{}' (getting hook route).", (Object)this.routeBase);
                readyHandler.handle(null);
            }
        });
    }

    private void loadStoredListeners(Handler<Void> readyHandler) {
        log.debug("loadStoredListeners");
        this.hookStorage.get(this.listenerBase, buffer -> {
            if (buffer != null) {
                JsonObject listOfListeners = new JsonObject(buffer.toString());
                JsonArray listenerNames = listOfListeners.getJsonArray(LISTENERS_KEY);
                Iterator keys = listenerNames.getList().iterator();
                AtomicInteger storedListenerCount = new AtomicInteger(listenerNames.getList().size());
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    this.hookStorage.get(this.listenerBase + key, listenerBody -> {
                        if (listenerBody != null) {
                            this.registerListener((Buffer)listenerBody);
                        } else {
                            log.warn("Could not get URL '{}' (getting hook listener).", (Object)(this.listenerBase + key));
                        }
                        if (storedListenerCount.decrementAndGet() == 0) {
                            readyHandler.handle(null);
                        }
                    });
                }
            } else {
                log.warn("Could not get URL '{}' (getting hook listener).", (Object)this.listenerBase);
                readyHandler.handle(null);
            }
        });
    }

    private void registerRouteRegistrationHandler(Handler<Void> readyHandler) {
        this.vertx.eventBus().consumer(SAVE_ROUTE_ADDRESS, event -> this.hookStorage.get((String)event.body(), buffer -> {
            if (buffer != null) {
                this.registerRoute((Buffer)buffer);
            } else {
                log.warn("Could not get URL '{}' (getting hook route).", event.body() == null ? "<null>" : event.body());
            }
        }));
        this.vertx.eventBus().consumer(REMOVE_ROUTE_ADDRESS, event -> this.unregisterRoute((String)event.body()));
        readyHandler.handle(null);
    }

    private void registerRouteMultiplierChangeHandler(Handler<Void> readyHandler) {
        this.vertx.eventBus().consumer("gateleen.route-multiplier", event -> {
            log.info("Updating route multiplier: {}", event.body() == null ? "<null>" : event.body());
            try {
                this.routeMultiplier = Integer.parseInt((String)event.body());
            }
            catch (NumberFormatException e) {
                log.info("failed to parse route multiplier: {}", event.body(), (Object)e);
            }
        });
        readyHandler.handle(null);
    }

    public void registerListenerRegistrationHandler(Handler<Void> readyHandler) {
        this.vertx.eventBus().consumer(SAVE_LISTENER_ADDRESS, event -> this.hookStorage.get((String)event.body(), buffer -> {
            if (buffer != null) {
                this.registerListener((Buffer)buffer);
            } else {
                log.warn("Could not get URL '{}' (getting hook listener).", event.body() == null ? "<null>" : event.body());
            }
        }));
        this.vertx.eventBus().consumer(REMOVE_LISTENER_ADDRESS, event -> this.unregisterListener((String)event.body()));
        readyHandler.handle(null);
    }

    public boolean handle(RoutingContext ctx) {
        List<Listener> listeners;
        HttpServerRequest request = ctx.request();
        boolean consumed = false;
        String requestUri = request.uri();
        HttpMethod requestMethod = request.method();
        if (requestMethod == HttpMethod.PUT) {
            if (requestUri.contains(HOOKS_LISTENERS_URI_PART)) {
                this.handleListenerRegistration(request);
                return true;
            }
            if (requestUri.contains(HOOKS_ROUTE_URI_PART)) {
                this.handleRouteRegistration(request);
                return true;
            }
        }
        if (requestMethod == HttpMethod.DELETE) {
            if (requestUri.contains(HOOKS_LISTENERS_URI_PART)) {
                this.handleListenerUnregistration(request);
                return true;
            }
            if (requestUri.contains(HOOKS_ROUTE_URI_PART)) {
                this.handleRouteUnregistration(request);
                return true;
            }
        }
        if (requestMethod == HttpMethod.GET && null != request.getParam("q")) {
            if (requestUri.contains(this.normalizedListenerBase)) {
                this.handleListenerSearch(request);
                return true;
            }
            if (requestUri.contains(this.normalizedRouteBase)) {
                this.handleRouteSearch(request);
                return true;
            }
        }
        if (!(listeners = this.listenerRepository.findListeners(request.uri(), request.method().name(), request.headers())).isEmpty() && !this.isRequestAlreadyHooked(request)) {
            this.installBodyHandler(ctx, listeners);
            consumed = true;
        }
        if (!consumed) {
            consumed = this.routeRequestIfNeeded(ctx);
            if (!consumed) {
                return this.createListingIfRequested(request);
            }
            return consumed;
        }
        return true;
    }

    private void handleListenerSearch(HttpServerRequest request) {
        this.handleSearch(this.listenerRepository.getListeners().stream().collect(Collectors.toMap(Listener::getListenerId, listener -> listener)), listener -> listener.getHook().getDestination(), LISTENERS_KEY, request);
    }

    private void handleRouteSearch(HttpServerRequest request) {
        this.handleSearch(this.routeRepository.getRoutes().entrySet().stream().collect(Collectors.toMap(entry -> ((Route)entry.getValue()).getHookDisplayText(), Map.Entry::getValue)), route -> route.getHook().getDestination(), ROUTES_KEY, request);
    }

    private <T> void handleSearch(Map<String, T> repository, Function<T, String> getDestination, String resultKey, HttpServerRequest request) {
        String queryParam = request.getParam("q");
        if (request.params().size() > 1 || StringUtils.isEmpty((CharSequence)queryParam)) {
            request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
            request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage());
            request.response().end("Only the 'q' parameter is allowed and can't be empty or null");
            return;
        }
        JsonArray matchingResults = new JsonArray();
        repository.forEach((key, value) -> {
            String destination = (String)getDestination.apply(value);
            if (destination != null && destination.contains(queryParam)) {
                matchingResults.add((Object)this.convertToStoragePattern((String)key));
            }
        });
        JsonObject result = new JsonObject();
        result.put(resultKey, (Object)matchingResults);
        String encodedResult = result.encode();
        request.response().putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)CONTENT_TYPE_JSON);
        request.response().end(encodedResult);
    }

    private boolean createListingIfRequested(HttpServerRequest request) {
        ArrayList<String> collections;
        boolean routesListed;
        String routesListedHeader = request.headers().get(HOOK_ROUTES_LISTED);
        boolean bl = routesListed = routesListedHeader != null && routesListedHeader.equals("true");
        if (request.method().equals((Object)HttpMethod.GET) && !routesListed && !(collections = new ArrayList<String>(this.routeRepository.getCollections(request.uri()))).isEmpty()) {
            String parentUri = request.uri().contains("?") ? request.uri().substring(0, request.uri().indexOf(63)) : request.uri();
            String parentCollection = this.getCollectionName(parentUri);
            collections.sort(this.collectionContentComparator);
            if (log.isTraceEnabled()) {
                log.trace("createListingIfRequested > (parentUri) {}, (parentCollection) {}", (Object)parentUri, (Object)parentCollection);
            }
            this.selfClient.request(request.method(), request.uri()).onComplete(asyncReqResult -> {
                if (asyncReqResult.failed()) {
                    log.warn("Failed request to {}: {}", (Object)request.uri(), (Object)asyncReqResult.cause());
                    return;
                }
                HttpClientRequest selfRequest = (HttpClientRequest)asyncReqResult.result();
                if (request.headers() != null && !request.headers().isEmpty()) {
                    selfRequest.headers().setAll(request.headers());
                }
                selfRequest.headers().add(HOOK_ROUTES_LISTED, "true");
                selfRequest.exceptionHandler(exception -> log.warn("HookHandler: listing of collections (routes) failed: {}: {}", (Object)request.uri(), (Object)exception.getMessage()));
                selfRequest.idleTimeout(120000L);
                selfRequest.send(asyncResult -> {
                    HttpClientResponse response = (HttpClientResponse)asyncResult.result();
                    HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)response);
                    request.response().headers().remove(HOOK_ROUTES_LISTED);
                    if (response.statusCode() == StatusCode.OK.getStatusCode()) {
                        if (log.isTraceEnabled()) {
                            log.trace("createListingIfRequested > use existing array");
                        }
                        response.handler(data -> {
                            JsonObject responseObject = new JsonObject(data.toString());
                            if (responseObject.getValue(parentCollection) instanceof JsonArray) {
                                JsonArray parentCollectionArray = responseObject.getJsonArray(parentCollection);
                                collections.forEach(arg_0 -> ((JsonArray)parentCollectionArray).add(arg_0));
                            }
                            if (log.isTraceEnabled()) {
                                log.trace("createListingIfRequested > response: {}", (Object)responseObject);
                            }
                            request.response().write((Object)Buffer.buffer((String)responseObject.toString()));
                        });
                    } else if (response.statusCode() == StatusCode.NOT_FOUND.getStatusCode()) {
                        if (log.isTraceEnabled()) {
                            log.trace("createListingIfRequested > creating new array");
                        }
                        response.handler(data -> {
                            request.response().setStatusCode(StatusCode.OK.getStatusCode());
                            request.response().setStatusMessage(StatusCode.OK.getStatusMessage());
                            JsonObject responseObject = new JsonObject();
                            JsonArray parentCollectionArray = new JsonArray();
                            responseObject.put(parentCollection, (Object)parentCollectionArray);
                            collections.forEach(arg_0 -> ((JsonArray)parentCollectionArray).add(arg_0));
                            if (log.isTraceEnabled()) {
                                log.trace("createListingIfRequested > response: {}", (Object)responseObject);
                            }
                            request.response().write((Object)Buffer.buffer((String)responseObject.toString()));
                        });
                    } else {
                        log.debug("createListingIfRequested - got response - ERROR");
                        response.handler(data -> request.response().write(data));
                    }
                    response.endHandler(v -> request.response().end());
                });
            });
            return true;
        }
        return false;
    }

    private String getCollectionName(String url) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.lastIndexOf("/"));
        }
        return url.substring(url.lastIndexOf("/") + 1, url.length());
    }

    private boolean routeRequestIfNeeded(RoutingContext ctx) {
        Route route = this.routeRepository.getRoute(ctx.request().uri());
        if (this.doMethodsMatch(route, ctx) && this.doHeadersMatch(route, ctx)) {
            log.debug("Forward request {}", (Object)ctx.request().uri());
            route.forward(ctx);
            return true;
        }
        return false;
    }

    private boolean doMethodsMatch(Route route, RoutingContext ctx) {
        return route != null && (route.getHook().getMethods().isEmpty() || route.getHook().getMethods().contains(ctx.request().method().name()));
    }

    private boolean doHeadersMatch(Route route, RoutingContext ctx) {
        if (route == null) {
            return false;
        }
        if (route.getHook().getHeadersFilterPattern() == null) {
            return true;
        }
        Pattern headersFilterPattern = route.getHook().getHeadersFilterPattern();
        log.debug("Looking for request headers with pattern {}", (Object)headersFilterPattern.pattern());
        return HttpHeaderUtil.hasMatchingHeader((MultiMap)ctx.request().headers(), (Pattern)headersFilterPattern);
    }

    private void installBodyHandler(RoutingContext ctx, List<Listener> listeners) {
        ctx.request().bodyHandler(buffer -> {
            List<Listener> beforeListener = this.getFilteredListeners(listeners, HookTriggerType.BEFORE);
            List<Listener> afterListener = this.getFilteredListeners(listeners, HookTriggerType.AFTER);
            Handler<Void> afterHandler = this.installAfterHandler(ctx, (Buffer)buffer, afterListener);
            Handler<Void> beforeHandler = this.installBeforeHandler(ctx, (Buffer)buffer, beforeListener, afterHandler);
            this.callListener(ctx, (Buffer)buffer, beforeListener, beforeHandler);
        });
    }

    private void callListener(RoutingContext ctx, Buffer buffer, List<Listener> filteredListeners, Handler<Void> handler) {
        HttpServerRequest request = ctx.request();
        for (Listener listener : filteredListeners) {
            Object queue;
            String targetUri;
            log.debug("Enqueue request matching {} {} with listener {}", new Object[]{request.method(), listener.getMonitoredUrl(), listener.getListener()});
            String path = request.uri();
            if (!listener.getHook().isFullUrl()) {
                path = request.uri().replace(listener.getMonitoredUrl(), "");
            }
            if (listener.getHook().getDestination().startsWith("/")) {
                targetUri = listener.getListener() + path;
                log.debug(" > internal target: {}", (Object)targetUri);
            } else {
                targetUri = this.hookRootUri + LISTENER_HOOK_TARGET_PATH + listener.getListener() + path;
                log.debug(" > external target: {}", (Object)targetUri);
            }
            HeadersMultiMap queueHeaders = new HeadersMultiMap();
            queueHeaders.addAll(request.headers());
            HeaderFunctions.EvalScope evalScope = listener.getHook().getHeaderFunction().apply((MultiMap)queueHeaders);
            if (evalScope.getErrorMessage() != null) {
                log.warn("problem applying header manipulator chain {} in listener {}", (Object)evalScope.getErrorMessage(), (Object)listener.getListenerId());
            }
            if (ExpiryCheckHandler.getQueueExpireAfter((MultiMap)queueHeaders) == null && listener.getHook().getQueueExpireAfter() != -1) {
                ExpiryCheckHandler.setQueueExpireAfter((MultiMap)queueHeaders, (int)listener.getHook().getQueueExpireAfter());
            }
            if ((queue = queueHeaders.get(X_QUEUE)) == null) {
                queue = "listener-hook-" + listener.getListenerId();
            } else {
                queueHeaders.remove(X_QUEUE);
            }
            queue = this.queueSplitter.convertToSubQueue((String)queue, request);
            QueueingStrategy queueingStrategy = listener.getHook().getQueueingStrategy();
            if (queueingStrategy instanceof DefaultQueueingStrategy) {
                this.requestQueue.enqueue(new HttpRequest(request.method(), targetUri, (MultiMap)queueHeaders, buffer.getBytes()), (String)queue, handler);
                continue;
            }
            if (queueingStrategy instanceof DiscardPayloadQueueingStrategy) {
                if (HttpRequestHeader.containsHeader((MultiMap)queueHeaders, (HttpRequestHeader)HttpRequestHeader.CONTENT_LENGTH)) {
                    queueHeaders.set(HttpRequestHeader.CONTENT_LENGTH.getName(), "0");
                }
                this.requestQueue.enqueue(new HttpRequest(request.method(), targetUri, (MultiMap)queueHeaders, null), (String)queue, handler);
                continue;
            }
            if (queueingStrategy instanceof ReducedPropagationQueueingStrategy) {
                if (this.reducedPropagationManager != null) {
                    this.reducedPropagationManager.processIncomingRequest(request.method(), targetUri, (MultiMap)queueHeaders, buffer, (String)queue, ((ReducedPropagationQueueingStrategy)queueingStrategy).getPropagationIntervalMs(), handler);
                    continue;
                }
                log.error("ReducedPropagationQueueingStrategy without configured ReducedPropagationManager. Not going to handle (enqueue) anything!");
                continue;
            }
            log.error("QueueingStrategy '{}' is not handled. Could be an error, check the source code!", (Object)queueingStrategy.getClass().getSimpleName());
        }
        if (filteredListeners.isEmpty() && handler != null) {
            handler.handle(null);
        }
    }

    private Handler<Void> installAfterHandler(RoutingContext ctx, Buffer buffer, List<Listener> afterListener) {
        return event -> this.callListener(ctx, buffer, afterListener, null);
    }

    private Handler<Void> installBeforeHandler(final RoutingContext ctx, final Buffer buffer, final List<Listener> beforeListener, final Handler<Void> afterHandler) {
        return new Handler<Void>(){
            private AtomicInteger currentCount = new AtomicInteger(0);
            private boolean sent = false;

            public void handle(Void event) {
                if ((this.currentCount.incrementAndGet() == beforeListener.size() || beforeListener.isEmpty()) && !this.sent) {
                    this.sent = true;
                    Route route = HookHandler.this.routeRepository.getRoute(ctx.request().uri());
                    if (HookHandler.this.doMethodsMatch(route, ctx) && HookHandler.this.doHeadersMatch(route, ctx)) {
                        log.debug("Forward request (consumed) {}", (Object)ctx.request().uri());
                        route.forward(ctx, buffer, (Handler<Void>)afterHandler);
                    } else {
                        ctx.request().headers().set(HookHandler.HOOKED_HEADER, "true");
                        HookHandler.this.createSelfRequest(ctx.request(), buffer, (Handler<Void>)afterHandler);
                    }
                }
            }
        };
    }

    private List<Listener> getFilteredListeners(List<Listener> listeners, HookTriggerType hookTriggerType) {
        return listeners.stream().filter(listener -> listener.getHook().getHookTriggerType().equals((Object)hookTriggerType)).collect(Collectors.toList());
    }

    private void handleRouteUnregistration(HttpServerRequest request) {
        log.debug("handleRouteUnregistration > {}", (Object)request.uri());
        String routeStorageUri = this.hookRootUri + HOOK_ROUTE_STORAGE_PATH + this.getStorageIdentifier(request.uri());
        this.hookStorage.delete(routeStorageUri, status -> {
            this.vertx.eventBus().publish(REMOVE_ROUTE_ADDRESS, (Object)request.uri());
            request.response().end();
        });
    }

    private void handleRouteRegistration(HttpServerRequest request) {
        log.debug("handleRouteRegistration > {}", (Object)request.uri());
        request.bodyHandler(hookData -> {
            JsonObject hook;
            if (this.isHookJsonInvalid(request, (Buffer)hookData)) {
                return;
            }
            String routeStorageUri = this.hookRootUri + HOOK_ROUTE_STORAGE_PATH + this.getStorageIdentifier(request.uri());
            Integer expireAfter = ExpiryCheckHandler.getExpireAfter((MultiMap)request.headers());
            if (expireAfter == null) {
                expireAfter = 3600;
            }
            ExpiryCheckHandler.setExpireAfter((HttpServerRequest)request, (int)expireAfter);
            DateTime expirationTime = ExpiryCheckHandler.getExpirationTime((int)expireAfter);
            try {
                hook = new JsonObject(hookData.toString());
            }
            catch (DecodeException e) {
                this.badRequest(request, "Cannot decode JSON", e.getMessage());
                return;
            }
            JsonObject storageObject = new JsonObject();
            storageObject.put(REQUESTURL, (Object)request.uri());
            storageObject.put(EXPIRATION_TIME, (Object)ExpiryCheckHandler.printDateTime((DateTime)expirationTime));
            storageObject.put(HOOK, (Object)hook);
            Buffer buffer = Buffer.buffer((String)storageObject.toString());
            this.hookStorage.put(routeStorageUri, request.headers(), buffer, status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    if (this.logHookConfigurationResourceChanges) {
                        RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                    }
                    this.vertx.eventBus().publish(SAVE_ROUTE_ADDRESS, (Object)routeStorageUri);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        });
    }

    private String getStorageIdentifier(String url) {
        return url.replace("/", "+");
    }

    private void handleListenerUnregistration(HttpServerRequest request) {
        log.debug("handleListenerUnregistration > {}", (Object)request.uri());
        String listenerStorageUri = this.hookRootUri + HOOK_LISTENER_STORAGE_PATH + this.getUniqueListenerId(request.uri());
        this.hookStorage.delete(listenerStorageUri, status -> {
            this.vertx.eventBus().publish(REMOVE_LISTENER_ADDRESS, (Object)request.uri());
            request.response().end();
        });
    }

    private void handleListenerRegistration(HttpServerRequest request) {
        log.debug("handleListenerRegistration > {}", (Object)request.uri());
        request.bodyHandler(hookData -> {
            JsonObject hook;
            if (this.isListenerJsonInvalid(request, (Buffer)hookData)) {
                return;
            }
            try {
                hook = new JsonObject(hookData);
            }
            catch (DecodeException e) {
                log.error("Cannot decode JSON", (Throwable)e);
                this.badRequest(request, "Cannot decode JSON", e.getMessage());
                return;
            }
            String destination = hook.getString(DESTINATION);
            String hookOnUri = this.getMonitoredUrlSegment(request.uri());
            if (destination.startsWith(hookOnUri)) {
                this.badRequest(request, "illegal destination", "Destination-URI should not be within subtree of your hooked resource. This would lead to an infinite loop.");
                return;
            }
            String listenerStorageUri = this.hookRootUri + HOOK_LISTENER_STORAGE_PATH + this.getUniqueListenerId(request.uri());
            String expirationTime = HookHandler.extractExpTimeAndManipulatePassedRequestAndReturnExpTime(request).orElse(null);
            if (log.isDebugEnabled()) {
                log.debug("Hook {} expirationTime is {}.", (Object)request.uri(), (Object)expirationTime);
            }
            JsonObject storageObject = new JsonObject();
            storageObject.put(REQUESTURL, (Object)request.uri());
            storageObject.put(EXPIRATION_TIME, (Object)expirationTime);
            storageObject.put(HOOK, (Object)hook);
            Buffer buffer = Buffer.buffer((String)storageObject.toString());
            this.hookStorage.put(listenerStorageUri, request.headers(), buffer, status -> {
                if (status.intValue() == StatusCode.OK.getStatusCode()) {
                    if (this.logHookConfigurationResourceChanges) {
                        RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)buffer);
                    }
                    this.vertx.eventBus().publish(SAVE_LISTENER_ADDRESS, (Object)listenerStorageUri);
                } else {
                    request.response().setStatusCode(status.intValue());
                }
                request.response().end();
            });
        });
    }

    private boolean isListenerJsonInvalid(HttpServerRequest request, Buffer hookData) {
        JsonObject hook;
        if (this.isHookJsonInvalid(request, hookData)) {
            return true;
        }
        try {
            hook = new JsonObject(hookData);
        }
        catch (DecodeException e) {
            log.error("Cannot decode JSON", (Throwable)e);
            this.badRequest(request, "Cannot decode JSON", e.getMessage());
            return true;
        }
        JsonArray methods = hook.getJsonArray(METHODS);
        if (methods != null) {
            for (Object method : methods) {
                if (QueueProcessor.httpMethodIsQueueable((HttpMethod)HttpMethod.valueOf((String)((String)method)))) continue;
                String msg = "Listener registration request tries to hook for not allowed '" + method + "' method.";
                log.error(msg);
                this.badRequest(request, "Bad Request", msg + "\n");
                return true;
            }
        }
        return false;
    }

    public boolean isHookJsonInvalid(HttpServerRequest request, Buffer hookData) {
        try {
            JsonNode hook = OBJECT_MAPPER.readTree(hookData.getBytes());
            Set valMsgs = this.jsonSchemaHook.validate(hook);
            if (valMsgs.size() > 0) {
                this.badRequest(request, "Hook JSON invalid", valMsgs.toString());
                return true;
            }
        }
        catch (Exception ex) {
            log.error("Cannot decode JSON", (Throwable)ex);
            this.badRequest(request, "Cannot decode JSON", ex.getMessage());
            return true;
        }
        return false;
    }

    private void badRequest(HttpServerRequest request, String statusMsg, String longMsg) {
        HttpServerResponse response = request.response();
        response.setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
        request.response().setStatusMessage(statusMsg);
        request.response().end(longMsg);
    }

    private void createSelfRequest(HttpServerRequest request, Buffer requestBody, Handler<Void> afterHandler) {
        log.debug("Create self request for {}", (Object)request.uri());
        this.selfClient.request(request.method(), request.uri()).onComplete(asyncReqResult -> {
            if (asyncReqResult.failed()) {
                log.warn("Failed request to {}: {}", (Object)request.uri(), (Object)asyncReqResult.cause());
                return;
            }
            HttpClientRequest selfRequest = (HttpClientRequest)asyncReqResult.result();
            if (request.headers() != null && !request.headers().isEmpty()) {
                selfRequest.headers().setAll(request.headers());
            }
            selfRequest.exceptionHandler(exception -> log.warn("HookHandler HOOK_ERROR: Failed self request to {}: {}", (Object)request.uri(), (Object)exception.getMessage()));
            selfRequest.idleTimeout(120000L);
            Handler asyncResultHandler = asyncResult -> {
                HttpClientResponse response = (HttpClientResponse)asyncResult.result();
                HttpServerRequestUtil.prepareResponse((HttpServerRequest)request, (HttpClientResponse)response);
                response.handler(data -> request.response().write(data));
                response.endHandler(v -> request.response().end());
                if (response.statusCode() / 100 == 2) {
                    afterHandler.handle(null);
                }
            };
            if (requestBody != null) {
                selfRequest.send(requestBody, asyncResultHandler);
            } else {
                selfRequest.send(asyncResultHandler);
            }
        });
    }

    public boolean isRequestAlreadyHooked(HttpServerRequest request) {
        String hooked = request.headers().get(HOOKED_HEADER);
        return hooked != null && hooked.equals("true");
    }

    private void unregisterRoute(String requestUrl) {
        String routedUrl = this.getRoutedUrlSegment(requestUrl);
        log.debug("Unregister route {}", (Object)routedUrl);
        this.routeRepository.removeRoute(routedUrl);
        if (this.meterRegistry != null) {
            this.routesCount.set(this.routeRepository.getRoutes().size());
        }
        if (this.monitoringHandler != null) {
            this.monitoringHandler.updateRoutesCount((long)this.routeRepository.getRoutes().size());
        }
    }

    private void unregisterListener(String requestUrl) {
        String listenerId = this.getUniqueListenerId(requestUrl);
        log.debug("Unregister listener {}", (Object)listenerId);
        this.routeRepository.removeRoute(this.hookRootUri + LISTENER_HOOK_TARGET_PATH + this.getListenerUrlSegment(requestUrl));
        this.listenerRepository.removeListener(listenerId);
        if (this.meterRegistry != null) {
            this.listenerCount.set(this.listenerRepository.size());
        }
        if (this.monitoringHandler != null) {
            this.monitoringHandler.updateListenerCount((long)this.listenerRepository.size());
        }
    }

    private void registerListener(Buffer buffer) {
        JsonObject jsonTranslateStatus;
        String headersFilter;
        JsonObject storageObject = new JsonObject(buffer.toString());
        String requestUrl = storageObject.getString(REQUESTURL);
        if (log.isTraceEnabled()) {
            log.trace("Request URL: {}", (Object)requestUrl);
        }
        String target = this.getListenerUrlSegment(requestUrl);
        String listenerId = this.getUniqueListenerId(requestUrl);
        if (log.isTraceEnabled()) {
            log.trace("Target (1st): {}", (Object)target);
        }
        JsonObject jsonHook = storageObject.getJsonObject(HOOK);
        JsonArray jsonMethods = jsonHook.getJsonArray(METHODS);
        HttpHook hook = new HttpHook(jsonHook.getString(DESTINATION));
        if (jsonMethods != null) {
            hook.setMethods(jsonMethods.getList());
        }
        if ((headersFilter = jsonHook.getString(HEADERS_FILTER)) != null) {
            try {
                Pattern headersFilterPattern = RegexpValidator.throwIfPatternInvalid((String)headersFilter);
                hook.setHeadersFilterPattern(headersFilterPattern);
            }
            catch (ValidationException e) {
                log.warn("Listener {} for target {} has an invalid headersFilter expression {} and will not be registered!", new Object[]{listenerId, target, headersFilter});
                return;
            }
        }
        if ((jsonTranslateStatus = jsonHook.getJsonObject(TRANSLATE_STATUS)) != null) {
            for (String pattern : jsonTranslateStatus.fieldNames()) {
                hook.addTranslateStatus(Pattern.compile(pattern), jsonTranslateStatus.getInteger(pattern));
            }
        }
        if (jsonHook.containsKey(FILTER)) {
            hook.setFilter(jsonHook.getString(FILTER));
        }
        if (jsonHook.getInteger(QUEUE_EXPIRE_AFTER) != null) {
            hook.setQueueExpireAfter(jsonHook.getInteger(QUEUE_EXPIRE_AFTER));
        }
        if (jsonHook.getString(HOOK_TRIGGER_TYPE) != null) {
            try {
                hook.setHookTriggerType(HookTriggerType.valueOf(jsonHook.getString(HOOK_TRIGGER_TYPE).toUpperCase()));
            }
            catch (IllegalArgumentException e) {
                log.warn("Listener " + listenerId + " for target " + target + " has an invalid trigger type " + jsonHook.getString(HOOK_TRIGGER_TYPE) + " and will not be registered!", (Throwable)e);
                return;
            }
        }
        this.extractAndAddStaticHeadersToHook(jsonHook, hook);
        this.extractAndAddProxyOptionsToHook(jsonHook, hook);
        String expirationTimeExpression = storageObject.getString(EXPIRATION_TIME);
        if (expirationTimeExpression == null) {
            log.debug("Register listener and route {} with infinite expiration.", (Object)target);
            hook.setExpirationTime(null);
        } else {
            DateTime expirationTime;
            try {
                expirationTime = ExpiryCheckHandler.parseDateTime((String)expirationTimeExpression);
            }
            catch (RuntimeException e) {
                log.warn("Listener " + listenerId + " for target " + target + " has an invalid expiration time " + expirationTimeExpression + " and will not be registered!", (Throwable)e);
                return;
            }
            log.debug("Register listener and route {} with expiration at {}", (Object)target, (Object)expirationTime);
            hook.setExpirationTime(expirationTime);
        }
        hook.setFullUrl(jsonHook.getBoolean(FULL_URL, Boolean.valueOf(false)));
        hook.setQueueingStrategy(QueueingStrategyFactory.buildQueueStrategy(jsonHook));
        if (hook.getDestination().startsWith("/")) {
            if (log.isTraceEnabled()) {
                log.trace("internal target, switching target!");
            }
            target = hook.getDestination();
        } else {
            String urlPattern = this.hookRootUri + LISTENER_HOOK_TARGET_PATH + target;
            this.routeRepository.addRoute(urlPattern, this.createRoute(urlPattern, hook, requestUrl));
            if (log.isTraceEnabled()) {
                log.trace("external target, add route for urlPattern: {}", (Object)urlPattern);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace("Target (2nd): {}", (Object)target);
        }
        this.listenerRepository.addListener(new Listener(listenerId, this.getMonitoredUrlSegment(requestUrl), target, hook));
        if (this.meterRegistry != null) {
            this.listenerCount.set(this.listenerRepository.size());
        }
        if (this.monitoringHandler != null) {
            this.monitoringHandler.updateListenerCount((long)this.listenerRepository.size());
        }
    }

    private void extractAndAddProxyOptionsToHook(JsonObject jsonHook, HttpHook hook) {
        JsonObject proxyOptions = jsonHook.getJsonObject("proxyOptions");
        if (proxyOptions != null) {
            hook.setProxyOptions(new ProxyOptions(proxyOptions));
        }
    }

    private void extractAndAddStaticHeadersToHook(JsonObject jsonHook, HttpHook hook) {
        JsonArray headers = jsonHook.getJsonArray("headers");
        if (headers != null) {
            HeaderFunction headerFunction = HeaderFunctions.parseFromJson((JsonArray)headers);
            hook.setHeaderFunction(headerFunction);
            return;
        }
        JsonObject staticHeaders = jsonHook.getJsonObject(STATIC_HEADERS);
        if (staticHeaders != null) {
            log.info("you use the deprecated \"staticHeaders\" syntax in your hook ({}). Please migrate to the more flexible \"headers\" syntax", (Object)jsonHook);
            hook.setHeaderFunction(HeaderFunctions.parseStaticHeadersFromJson((JsonObject)staticHeaders));
        }
    }

    protected String getUniqueListenerId(String requestUrl) {
        StringBuilder listenerId = new StringBuilder();
        listenerId.append(this.convertToStoragePattern(this.getListenerUrlSegment(requestUrl)));
        listenerId.append(this.convertToStoragePattern(this.getMonitoredUrlSegment(requestUrl)));
        return listenerId.toString();
    }

    private String convertToStoragePattern(String urlSegment) {
        return urlSegment.replace("/", "+").replace(".", "+").replace(":", "+");
    }

    private void registerRoute(Buffer buffer) {
        JsonObject jsonTranslateStatus;
        String headersFilter;
        JsonObject storageObject = new JsonObject(buffer.toString());
        String requestUrl = storageObject.getString(REQUESTURL);
        String routedUrl = this.getRoutedUrlSegment(requestUrl);
        log.debug("Register route to {}", (Object)routedUrl);
        JsonObject jsonHook = storageObject.getJsonObject(HOOK);
        JsonArray jsonMethods = jsonHook.getJsonArray(METHODS);
        HttpHook hook = new HttpHook(jsonHook.getString(DESTINATION));
        if (jsonMethods != null) {
            hook.setMethods(jsonMethods.getList());
        }
        if ((headersFilter = jsonHook.getString(HEADERS_FILTER)) != null) {
            try {
                Pattern headersFilterPattern = RegexpValidator.throwIfPatternInvalid((String)headersFilter);
                hook.setHeadersFilterPattern(headersFilterPattern);
            }
            catch (ValidationException e) {
                log.warn("Route {} has an invalid headersFilter expression {} and will not be registered!", (Object)routedUrl, (Object)headersFilter);
                return;
            }
        }
        if ((jsonTranslateStatus = jsonHook.getJsonObject(TRANSLATE_STATUS)) != null) {
            for (String pattern : jsonTranslateStatus.fieldNames()) {
                hook.addTranslateStatus(Pattern.compile(pattern), jsonTranslateStatus.getInteger(pattern));
            }
        }
        if (jsonHook.getInteger(QUEUE_EXPIRE_AFTER) != null) {
            hook.setQueueExpireAfter(jsonHook.getInteger(QUEUE_EXPIRE_AFTER));
        }
        if (jsonHook.getBoolean(LISTABLE) != null) {
            hook.setListable(jsonHook.getBoolean(LISTABLE));
        } else {
            hook.setListable(this.listableRoutes);
        }
        if (jsonHook.getBoolean(COLLECTION) != null) {
            hook.setCollection(jsonHook.getBoolean(COLLECTION));
        }
        this.extractAndAddStaticHeadersToHook(jsonHook, hook);
        this.extractAndAddProxyOptionsToHook(jsonHook, hook);
        String expirationTimeExpression = storageObject.getString(EXPIRATION_TIME);
        if (expirationTimeExpression != null) {
            try {
                hook.setExpirationTime(ExpiryCheckHandler.parseDateTime((String)expirationTimeExpression));
            }
            catch (Exception e) {
                log.warn("Route {} has an invalid expiration time {} and will not be registered!", (Object)routedUrl, (Object)expirationTimeExpression);
                return;
            }
        } else {
            log.warn("Route {} has no expiration time and will not be registered!", (Object)routedUrl);
            return;
        }
        hook.setFullUrl(storageObject.getBoolean(FULL_URL, Boolean.valueOf(false)));
        hook.setQueueingStrategy(QueueingStrategyFactory.buildQueueStrategy(storageObject));
        Integer originalPoolSize = jsonHook.getInteger("connectionPoolSize");
        if (originalPoolSize != null) {
            int appliedPoolSize = RuleFactory.evaluatePoolSize((int)originalPoolSize, (int)this.routeMultiplier);
            log.debug("Original pool size is {}, applied size is {}", (Object)originalPoolSize, (Object)appliedPoolSize);
            hook.setConnectionPoolSize(appliedPoolSize);
        }
        hook.setMaxWaitQueueSize(jsonHook.getInteger("maxWaitQueueSize"));
        Integer timeout = jsonHook.getInteger("timeout");
        if (timeout != null) {
            hook.setTimeout(1000 * timeout);
        }
        boolean mustCreateNewRoute = true;
        Route existingRoute = this.routeRepository.getRoutes().get(routedUrl);
        if (existingRoute != null) {
            mustCreateNewRoute = this.mustCreateNewRouteForHook(existingRoute, hook);
        }
        if (mustCreateNewRoute) {
            this.routeRepository.addRoute(routedUrl, this.createRoute(routedUrl, hook, requestUrl));
        } else {
            existingRoute.getRule().setHeaderFunction(hook.getHeaderFunction());
            existingRoute.getHook().setExpirationTime(hook.getExpirationTime().orElse(null));
        }
        if (this.meterRegistry != null) {
            this.routesCount.set(this.routeRepository.getRoutes().size());
        }
        if (this.monitoringHandler != null) {
            this.monitoringHandler.updateRoutesCount((long)this.routeRepository.getRoutes().size());
        }
    }

    private boolean mustCreateNewRouteForHook(Route existingRoute, HttpHook newHook) {
        HttpHook oldHook = existingRoute.getHook();
        boolean same = Objects.equals(oldHook.getDestination(), newHook.getDestination());
        same &= Objects.equals(oldHook.getMethods(), newHook.getMethods());
        same &= Objects.equals(oldHook.getTranslateStatus(), newHook.getTranslateStatus());
        same &= oldHook.isCollection() == newHook.isCollection();
        same &= oldHook.isFullUrl() == newHook.isFullUrl();
        same &= oldHook.isListable() == newHook.isListable();
        same &= oldHook.isCollection() == newHook.isCollection();
        same &= oldHook.isCollection() == newHook.isCollection();
        same &= Objects.equals(oldHook.getConnectionPoolSize(), newHook.getConnectionPoolSize());
        same &= Objects.equals(oldHook.getMaxWaitQueueSize(), newHook.getMaxWaitQueueSize());
        same &= Objects.equals(oldHook.getTimeout(), newHook.getTimeout());
        return !(same &= this.headersFilterPatternEquals(oldHook.getHeadersFilterPattern(), newHook.getHeadersFilterPattern()));
    }

    private boolean headersFilterPatternEquals(Pattern headersFilterPatternLeft, Pattern headersFilterPatternRight) {
        if (headersFilterPatternLeft != null && headersFilterPatternRight != null) {
            return Objects.equals(headersFilterPatternLeft.pattern(), headersFilterPatternRight.pattern());
        }
        return headersFilterPatternLeft == null && headersFilterPatternRight == null;
    }

    private Route createRoute(String urlPattern, HttpHook hook, String hookDisplayText) {
        Route route = new Route(this.vertx, this.userProfileStorage, this.loggingResourceManager, this.logAppenderRepository, this.monitoringHandler, this.userProfilePath, hook, urlPattern, this.selfClient, hookDisplayText);
        route.setMeterRegistry(this.meterRegistry);
        return route;
    }

    private String getRoutedUrlSegment(String requestUrl) {
        return requestUrl.substring(0, requestUrl.indexOf(HOOKS_ROUTE_URI_PART));
    }

    private String getMonitoredUrlSegment(String requestUrl) {
        return requestUrl.substring(0, requestUrl.indexOf(HOOKS_LISTENERS_URI_PART));
    }

    private String getListenerUrlSegment(String requestUrl) {
        int pos = requestUrl.indexOf(HOOKS_LISTENERS_URI_PART);
        return requestUrl.substring(pos + HOOKS_LISTENERS_URI_PART.length());
    }

    private static Optional<String> extractExpTimeAndManipulatePassedRequestAndReturnExpTime(HttpServerRequest request) {
        int expireAfter = ExpiryCheckHandler.getExpireAfterConcerningCaseOfCorruptHeaderAndInfinite((MultiMap)request.headers()).orElse(3600);
        String expirationTime = ExpiryCheckHandler.getExpirationTimeAsString((int)expireAfter).orElse(null);
        ExpiryCheckHandler.setExpireAfter((HttpServerRequest)request, (int)expireAfter);
        return Optional.ofNullable(expirationTime);
    }

    private static /* synthetic */ void lambda$init$0(Handler readyHandler, Consumer handlerConsumer) {
        handlerConsumer.accept(readyHandler);
    }
}

