/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook.queueingstrategy;

import io.vertx.core.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.hook.queueingstrategy.DefaultQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.DiscardPayloadQueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.QueueingStrategy;
import org.swisspush.gateleen.hook.queueingstrategy.ReducedPropagationQueueingStrategy;

public class QueueingStrategyFactory {
    private static final String QUEUEING_STRATEGY_PROPERTY = "queueingStrategy";
    private static final String INTERVAL_PROPERTY = "intervalMs";
    private static Logger LOG = LoggerFactory.getLogger(QueueingStrategyFactory.class);

    private QueueingStrategyFactory() {
    }

    public static QueueingStrategy buildQueueStrategy(JsonObject hookConfiguration) {
        QueueingStrategy queueingStrategy = new DefaultQueueingStrategy();
        if (hookConfiguration == null || !hookConfiguration.containsKey(QUEUEING_STRATEGY_PROPERTY)) {
            return queueingStrategy;
        }
        Object queueingStrategyConfigObj = hookConfiguration.getValue(QUEUEING_STRATEGY_PROPERTY);
        if (!(queueingStrategyConfigObj instanceof JsonObject)) {
            LOG.warn("Invalid 'queueingStrategy' configuration found: {}. Using DefaultQueueingStrategy instead", queueingStrategyConfigObj);
            return queueingStrategy;
        }
        JsonObject queueingStrategyConfig = (JsonObject)queueingStrategyConfigObj;
        Strategy strategy = Strategy.fromString(queueingStrategyConfig.getString("type"));
        if (strategy == null) {
            LOG.warn("Invalid 'queueingStrategy' configuration found: {}. Using DefaultQueueingStrategy instead", (Object)queueingStrategyConfig.encode());
            return queueingStrategy;
        }
        switch (strategy) {
            case DISCARD_PAYLOAD: {
                queueingStrategy = new DiscardPayloadQueueingStrategy();
                break;
            }
            case REDUCED_PROPAGATION: {
                queueingStrategy = QueueingStrategyFactory.buildReducedPropagationQueueingStrategy(queueingStrategyConfig);
                break;
            }
            default: {
                LOG.warn("Unknown strategy '{}'. Using DefaultQueueingStrategy instead", (Object)strategy);
            }
        }
        return queueingStrategy;
    }

    private static QueueingStrategy buildReducedPropagationQueueingStrategy(JsonObject queueingStrategyConfig) {
        try {
            Long intervalMs = queueingStrategyConfig.getLong(INTERVAL_PROPERTY);
            if (intervalMs != null) {
                return new ReducedPropagationQueueingStrategy(intervalMs);
            }
            LOG.warn("Got a 'ReducedPropagationQueueingStrategy' configuration with an invalid interval value: {}", (Object)queueingStrategyConfig.encode());
            return new DefaultQueueingStrategy();
        }
        catch (Exception ex) {
            LOG.warn("Got a 'ReducedPropagationQueueingStrategy' configuration with an invalid interval value: {}", (Object)queueingStrategyConfig.encode());
            return new DefaultQueueingStrategy();
        }
    }

    private static enum Strategy {
        DISCARD_PAYLOAD("discardPayload"),
        REDUCED_PROPAGATION("reducedPropagation");

        private final String type;

        private Strategy(String type) {
            this.type = type;
        }

        public String getType() {
            return this.type;
        }

        public static Strategy fromString(String op) {
            for (Strategy strategy : Strategy.values()) {
                if (!strategy.getType().equalsIgnoreCase(op)) continue;
                return strategy;
            }
            return null;
        }
    }
}

