/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import io.vertx.core.MultiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.HttpHeaderUtil;
import org.swisspush.gateleen.hook.Listener;
import org.swisspush.gateleen.hook.ListenerRepository;
import org.swisspush.gateleen.hook.ListenerRepositoryBase;

public class LocalListenerRepository
extends ListenerRepositoryBase<Map<String, Set<Listener>>>
implements ListenerRepository {
    private Logger log = LoggerFactory.getLogger(LocalListenerRepository.class);
    private Map<String, Set<Listener>> urlToListenersMap = new HashMap<String, Set<Listener>>();
    private Map<String, Listener> listenerToUrlMap = new HashMap<String, Listener>();

    @Override
    public void addListener(Listener listener) {
        this.removeListener(listener.getListenerId());
        this.log.debug("Add listener {} for resource {} with id {}", new Object[]{listener.getListener(), listener.getMonitoredUrl(), listener.getListenerId()});
        Set<Listener> listeners = this.urlToListenersMap.get(listener.getMonitoredUrl());
        if (listeners == null) {
            listeners = new HashSet<Listener>();
        }
        listeners.add(listener);
        this.urlToListenersMap.put(listener.getMonitoredUrl(), listeners);
        this.listenerToUrlMap.put(listener.getListenerId(), listener);
    }

    @Override
    public List<Listener> findListeners(String url) {
        return this.findListeners(this.urlToListenersMap, url);
    }

    @Override
    public void removeListener(String listenerId) {
        this.log.debug("Remove listener for id {}", (Object)listenerId);
        Listener listenerToRemove = this.listenerToUrlMap.get(listenerId);
        if (listenerToRemove != null) {
            this.listenerToUrlMap.remove(listenerId);
            Set<Listener> listeners = this.urlToListenersMap.get(listenerToRemove.getMonitoredUrl());
            listeners.remove(listenerToRemove);
            if (listeners.isEmpty()) {
                this.urlToListenersMap.remove(listenerToRemove.getMonitoredUrl());
            }
        }
    }

    @Override
    public int size() {
        return this.listenerToUrlMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.listenerToUrlMap.isEmpty();
    }

    @Override
    public Set<Listener> get(Map<String, Set<Listener>> container, String key) {
        return container.get(key);
    }

    @Override
    boolean containsKey(Map<String, Set<Listener>> container, String key) {
        return container.containsKey(key);
    }

    @Override
    public List<Listener> getListeners() {
        return new ArrayList<Listener>(this.listenerToUrlMap.values());
    }

    @Override
    public List<Listener> findListeners(String url, String method, MultiMap headers) {
        ArrayList<Listener> result = new ArrayList<Listener>();
        for (Listener listener : this.findListeners(url)) {
            if (!this.doesMethodMatch(listener, method) || !this.doHeadersMatch(listener, headers)) continue;
            result.add(listener);
        }
        return result;
    }

    private boolean doesMethodMatch(Listener listener, String method) {
        return listener.getHook().getMethods().isEmpty() || listener.getHook().getMethods().contains(method);
    }

    private boolean doHeadersMatch(Listener listener, MultiMap headers) {
        Pattern headersFilterPattern = listener.getHook().getHeadersFilterPattern();
        if (headersFilterPattern != null) {
            return HttpHeaderUtil.hasMatchingHeader((MultiMap)headers, (Pattern)headersFilterPattern);
        }
        return true;
    }
}

