/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.hook;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.ext.web.RoutingContext;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.hook.HttpHook;
import org.swisspush.gateleen.logging.LogAppenderRepository;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.monitoring.MonitoringHandler;
import org.swisspush.gateleen.routing.Forwarder;
import org.swisspush.gateleen.routing.Rule;

public class Route {
    private static final int GRACE_PERIOD = 30000;
    private static final int CLIENT_DEFAULT_TIMEOUT_SEC = 30;
    private static final boolean CLIENT_DEFAULT_KEEP_ALIVE = true;
    private static final boolean CLIENT_DEFAULT_EXPAND_ON_BACKEND = false;
    private static final boolean CLIENT_DEFAULT_EXPAND_IN_STORAGE = false;
    private static final int CLIENT_DEFAULT_LOG_EXPIRY = 14400;
    private static final String HTTP_CONNECTION_KEEP_ALIVE_TIMEOUT = "org.swisspush.gateleen.routing.rule.http.connection.keep.alive.timeout";
    private static int keepAliveTimeout;
    private static final Pattern URL_PARSE_PATTERN;
    private static final Logger LOG;
    private static final Logger CLEANUP_LOGGER;
    private Vertx vertx;
    private LoggingResourceManager loggingResourceManager;
    private LogAppenderRepository logAppenderRepository;
    private MonitoringHandler monitoringHandler;
    private String userProfilePath;
    private ResourceStorage storage;
    private String urlPattern;
    private HttpHook httpHook;
    private Rule rule;
    private HttpClient client;
    private Forwarder forwarder;
    private HttpClient selfClient;

    public Route(Vertx vertx, ResourceStorage storage, LoggingResourceManager loggingResourceManager, LogAppenderRepository logAppenderRepository, MonitoringHandler monitoringHandler, String userProfilePath, HttpHook httpHook, String urlPattern, HttpClient selfClient) {
        this.vertx = vertx;
        this.storage = storage;
        this.loggingResourceManager = loggingResourceManager;
        this.logAppenderRepository = logAppenderRepository;
        this.monitoringHandler = monitoringHandler;
        this.userProfilePath = userProfilePath;
        this.httpHook = httpHook;
        this.urlPattern = urlPattern;
        this.selfClient = selfClient;
        this.createRule();
        this.createHttpClient();
        this.createForwarder();
    }

    private void createForwarder() {
        this.forwarder = new Forwarder(this.vertx, this.client, this.rule, this.storage, this.loggingResourceManager, this.logAppenderRepository, this.monitoringHandler, this.userProfilePath, null);
    }

    private void createRule() {
        this.rule = new Rule();
        this.rule.setUrlPattern(this.urlPattern);
        this.prepareUrl(this.rule, this.httpHook);
        this.rule.setTimeout(30000);
        this.rule.setKeepAlive(true);
        this.rule.setKeepAliveTimeout(keepAliveTimeout);
        this.rule.setExpandOnBackend(false);
        this.rule.setStorageExpand(false);
        this.rule.setLogExpiry(14400);
        this.rule.setHeaderFunction(this.httpHook.getHeaderFunction());
        this.rule.setProxyOptions(this.httpHook.getProxyOptions());
        Integer connectionPoolSize = this.httpHook.getConnectionPoolSize();
        if (connectionPoolSize == null) {
            LOG.trace("No connectionPoolSize specified for route '{}' using default of {}.", (Object)this.rule.getRuleIdentifier(), (Object)50);
            this.rule.setPoolSize(50);
        } else {
            LOG.trace("Using connectionPoolSize {} for route '{}'.", (Object)connectionPoolSize, (Object)this.rule.getRuleIdentifier());
            this.rule.setPoolSize(connectionPoolSize.intValue());
        }
        Integer maxWaitQueueSize = this.httpHook.getMaxWaitQueueSize();
        if (maxWaitQueueSize == null) {
            LOG.trace("No maxWaitQueueSize specified for route '{}' using default of {}.", (Object)this.rule.getRuleIdentifier(), (Object)-1);
            this.rule.setMaxWaitQueueSize(-1);
        } else {
            LOG.trace("Using maxWaitQueueSize {} for route '{}'.", (Object)maxWaitQueueSize, (Object)this.rule.getRuleIdentifier());
            this.rule.setMaxWaitQueueSize(maxWaitQueueSize.intValue());
        }
        Integer timeout = this.httpHook.getTimeout();
        if (timeout == null) {
            LOG.trace("No timeout specified for route '{}' using default of {}.", (Object)this.rule.getRuleIdentifier(), (Object)30);
            this.rule.setTimeout(30000);
        } else {
            LOG.trace("Using timeout {} for route '{}'.", (Object)timeout, (Object)this.rule.getRuleIdentifier());
            this.rule.setTimeout(timeout.intValue());
        }
        if (!this.httpHook.getMethods().isEmpty()) {
            this.rule.setMethods(this.httpHook.getMethods().toArray(new String[0]));
        }
        if (!this.httpHook.getTranslateStatus().isEmpty()) {
            this.rule.addTranslateStatus(this.httpHook.getTranslateStatus());
        }
    }

    public Rule getRule() {
        return this.rule;
    }

    private void prepareUrl(Rule rule, HttpHook httpHook) {
        Matcher urlMatcher = URL_PARSE_PATTERN.matcher(httpHook.getDestination());
        if (urlMatcher.matches()) {
            rule.setHost(urlMatcher.group("host"));
            rule.setScheme(urlMatcher.group("scheme"));
            rule.setPort(rule.getScheme().equals("https") ? 443 : 80);
            String portString = urlMatcher.group("port");
            if (portString != null) {
                rule.setPort(Integer.parseInt(portString));
            }
            rule.setPath(urlMatcher.group("path"));
        } else if (httpHook.getDestination().startsWith("/")) {
            rule.setPath(httpHook.getDestination());
            rule.setHost("localhost");
            rule.setScheme("local");
        } else {
            throw new IllegalArgumentException("Destination (" + httpHook.getDestination() + ") is neither a valid url, nor a valid path.");
        }
    }

    private void createHttpClient() {
        if (this.rule.getScheme().equals("local")) {
            this.client = this.selfClient;
        } else {
            HttpClientOptions options = this.rule.buildHttpClientOptions();
            this.client = this.vertx.createHttpClient(options);
        }
    }

    public void forward(RoutingContext ctx, Buffer requestBody, @Nullable Handler<Void> afterHandler) {
        if (this.httpHook.getMethods().isEmpty()) {
            this.forwarder.handle(ctx, requestBody, afterHandler);
        } else if (this.httpHook.getMethods().contains(ctx.request().method().name())) {
            this.forwarder.handle(ctx, requestBody, afterHandler);
        }
    }

    public void forward(RoutingContext ctx) {
        this.forward(ctx, null, null);
    }

    public void cleanup() {
        if (!this.rule.getScheme().equals("local")) {
            this.vertx.setTimer(30000L, event -> {
                CLEANUP_LOGGER.debug("Cleaning up one client for route of {}", (Object)this.urlPattern);
                this.client.close();
            });
        }
    }

    public HttpHook getHook() {
        return this.httpHook;
    }

    static {
        URL_PARSE_PATTERN = Pattern.compile("^(?<scheme>https?)://(?<host>[^/:]+)(:(?<port>[0-9]+))?(?<path>/.*)$");
        LOG = LoggerFactory.getLogger(Route.class);
        CLEANUP_LOGGER = LoggerFactory.getLogger((String)(Route.class.getName() + "Cleanup"));
        String keepAliveTimeoutProperty = System.getProperty(HTTP_CONNECTION_KEEP_ALIVE_TIMEOUT);
        keepAliveTimeout = keepAliveTimeoutProperty != null ? Integer.parseInt(keepAliveTimeoutProperty) : 60;
    }
}

