/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.kafka;

import io.vertx.core.Future;
import io.vertx.kafka.client.producer.KafkaProducer;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import io.vertx.kafka.client.producer.RecordMetadata;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaMessageSender {
    private static final Logger log = LoggerFactory.getLogger(KafkaMessageSender.class);

    Future<Void> sendMessages(KafkaProducer<String, String> kafkaProducer, List<KafkaProducerRecord<String, String>> messages) {
        Future future = Future.future();
        Future f = Future.succeededFuture();
        messages.stream().reduce(f, (f1, message) -> f1.compose(ignore -> this.sendMessage(kafkaProducer, (KafkaProducerRecord<String, String>)message)), (voidFuture, voidFuture2) -> null).setHandler(res -> {
            if (res.succeeded()) {
                future.complete();
            } else {
                future.fail(res.cause());
            }
        });
        return future;
    }

    private Future<Void> sendMessage(KafkaProducer<String, String> kafkaProducer, KafkaProducerRecord<String, String> message) {
        Future f = Future.future();
        kafkaProducer.write(message, event -> {
            if (event.succeeded()) {
                if (message.key() != null) {
                    log.debug("Message with key '{}' successfully sent to kafka. Result: {}", message.key(), (Object)((RecordMetadata)event.result()).toJson());
                } else {
                    log.debug("Message without key successfully sent to kafka. Result: {}", (Object)((RecordMetadata)event.result()).toJson());
                }
                f.complete();
            } else {
                log.info("Failed to send message with key '{}' to kafka. Cause: {}", message.key(), (Object)event.cause());
                f.fail(event.cause());
            }
        });
        return f;
    }
}

