/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import java.util.ArrayList;
import java.util.List;
import org.swisspush.gateleen.validation.ValidationException;

class KafkaProducerRecordBuilder {
    private static final String RECORDS = "records";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private static final String HEADERS = "headers";

    KafkaProducerRecordBuilder() {
    }

    static List<KafkaProducerRecord<String, String>> buildRecords(String topic, Buffer payload) throws ValidationException {
        JsonObject payloadObj;
        ArrayList<KafkaProducerRecord<String, String>> kafkaProducerRecords = new ArrayList<KafkaProducerRecord<String, String>>();
        try {
            payloadObj = new JsonObject(payload);
        }
        catch (DecodeException de) {
            throw new ValidationException("Error while parsing payload");
        }
        try {
            JsonArray recordsArray = payloadObj.getJsonArray(RECORDS);
            if (recordsArray == null) {
                throw new ValidationException("Missing 'records' array");
            }
            for (int i = 0; i < recordsArray.size(); ++i) {
                kafkaProducerRecords.add(KafkaProducerRecordBuilder.fromRecordJsonObject(topic, recordsArray.getJsonObject(i)));
            }
        }
        catch (ClassCastException cce) {
            throw new ValidationException("Property 'records' must be of type JsonArray holding JsonObject objects");
        }
        return kafkaProducerRecords;
    }

    private static KafkaProducerRecord<String, String> fromRecordJsonObject(String topic, JsonObject recordObj) throws ValidationException {
        JsonObject headers;
        JsonObject valueObj;
        String key;
        try {
            key = recordObj.getString(KEY);
        }
        catch (ClassCastException cce) {
            throw new ValidationException("Property 'key' must be of type String");
        }
        try {
            valueObj = recordObj.getJsonObject(VALUE);
        }
        catch (ClassCastException cce) {
            throw new ValidationException("Property 'value' must be of type JsonObject");
        }
        if (valueObj == null) {
            throw new ValidationException("Property 'value' is required");
        }
        String value = valueObj.encode();
        KafkaProducerRecord record = KafkaProducerRecord.create((String)topic, (Object)key, (Object)value);
        try {
            headers = recordObj.getJsonObject(HEADERS);
        }
        catch (ClassCastException cce) {
            throw new ValidationException("Property 'headers' must be of type JsonObject");
        }
        if (headers != null) {
            try {
                for (String headerName : headers.fieldNames()) {
                    record.addHeader(headerName, headers.getString(headerName));
                }
            }
            catch (ClassCastException cce) {
                throw new ValidationException("Property 'headers' must be of type JsonObject holding String values only");
            }
        }
        return record;
    }
}

