/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.kafka;

import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.kafka.client.producer.KafkaProducer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.kafka.KafkaConfiguration;

public class KafkaProducerRepository {
    private final Logger log = LoggerFactory.getLogger(KafkaProducerRepository.class);
    private final Vertx vertx;
    private final Map<Pattern, KafkaProducer<String, String>> kafkaProducers;

    public KafkaProducerRepository(Vertx vertx) {
        this.vertx = vertx;
        this.kafkaProducers = new LinkedHashMap<Pattern, KafkaProducer<String, String>>();
    }

    void addKafkaProducer(KafkaConfiguration config) {
        this.log.info("About to add kafka producer from {}", (Object)config);
        this.kafkaProducers.put(config.getTopic(), (KafkaProducer<String, String>)KafkaProducer.create((Vertx)this.vertx, config.getConfigurations()));
    }

    Optional<Pair<KafkaProducer<String, String>, Pattern>> findMatchingKafkaProducer(String topic) {
        for (Map.Entry<Pattern, KafkaProducer<String, String>> entry : this.kafkaProducers.entrySet()) {
            Matcher matcher = entry.getKey().matcher(topic);
            if (!matcher.matches()) continue;
            this.log.debug("Found matching KafkaProducer with pattern '{}' for topic '{}' found", (Object)entry.getKey().pattern(), (Object)topic);
            return Optional.of(Pair.of(entry.getValue(), (Object)entry.getKey()));
        }
        this.log.info("No matching KafkaProducer for topic '{}' found", (Object)topic);
        return Optional.empty();
    }

    Future<Void> closeAll() {
        this.log.info("About to close all kafka producers");
        Future future = Future.future();
        ArrayList<Future> futures = new ArrayList<Future>();
        for (Map.Entry<Pattern, KafkaProducer<String, String>> entry : this.kafkaProducers.entrySet()) {
            Future entryFuture = Future.future();
            futures.add(entryFuture);
            entry.getValue().close(event -> {
                if (event.succeeded()) {
                    this.log.info("Successfully closed producer for topic '{}'", (Object)((Pattern)entry.getKey()).pattern());
                } else {
                    this.log.warn("Failed to close producer for topic '{}'", (Object)((Pattern)entry.getKey()).pattern());
                }
                entryFuture.complete();
            });
        }
        CompositeFuture.all(futures).setHandler(event -> {
            this.kafkaProducers.clear();
            future.complete();
        });
        return future;
    }
}

