/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.kafka;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.kafka.KafkaConfiguration;

class KafkaConfigurationParser {
    private static final Logger log = LoggerFactory.getLogger(KafkaConfigurationParser.class);
    private static final AtomicInteger instanceIndexCounter = new AtomicInteger(0);

    KafkaConfigurationParser() {
    }

    static List<KafkaConfiguration> parse(Buffer configurationResourceBuffer, Map<String, Object> properties) {
        JsonObject config;
        ArrayList<KafkaConfiguration> configurations = new ArrayList<KafkaConfiguration>();
        try {
            String replacedConfig = StringUtils.replaceWildcardConfigs((String)configurationResourceBuffer.toString(StandardCharsets.UTF_8), properties);
            config = new JsonObject(Buffer.buffer((String)replacedConfig));
        }
        catch (Exception e) {
            log.warn("Could not replace wildcards with environment properties for kafka configurations due to following reason: {}", (Object)e.getMessage());
            return configurations;
        }
        for (String topicPattern : config.fieldNames()) {
            try {
                Pattern pattern = Pattern.compile(topicPattern);
                Map<String, String> additionalConfig = KafkaConfigurationParser.extractAdditionalConfig(config.getJsonObject(topicPattern));
                KafkaConfigurationParser.setUniqueClientId(additionalConfig);
                configurations.add(new KafkaConfiguration(pattern, additionalConfig));
                log.info("Topic '{}' successfully parsed and added to kafka configuration list", (Object)topicPattern);
            }
            catch (PatternSyntaxException patternException) {
                log.warn("Topic '{}' is not a valid regex pattern. Discarding this kafka configuration", (Object)topicPattern);
            }
        }
        return configurations;
    }

    private static void setUniqueClientId(Map<String, String> config) {
        String clientId = config.get("client.id");
        if (StringUtils.isNotEmpty((CharSequence)clientId)) {
            config.put("client.id", clientId + "-" + instanceIndexCounter.incrementAndGet());
        }
    }

    private static Map<String, String> extractAdditionalConfig(JsonObject topicObject) {
        HashMap<String, String> additionalConfigs = new HashMap<String, String>();
        for (String configKey : topicObject.fieldNames()) {
            String configValue = topicObject.getString(configKey);
            additionalConfigs.put(configKey, configValue);
        }
        return additionalConfigs;
    }
}

