/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.kafka;

import io.vertx.core.Vertx;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.configuration.ConfigurationResourceManager;
import org.swisspush.gateleen.core.exception.GateleenExceptionFactory;
import org.swisspush.gateleen.kafka.KafkaHandler;
import org.swisspush.gateleen.kafka.KafkaMessageSender;
import org.swisspush.gateleen.kafka.KafkaMessageValidator;
import org.swisspush.gateleen.kafka.KafkaProducerRepository;

public class KafkaHandlerBuilder {
    private static final Logger log = LoggerFactory.getLogger(KafkaHandlerBuilder.class);
    private Vertx vertx;
    private GateleenExceptionFactory exceptionFactory;
    private ConfigurationResourceManager configurationResourceManager;
    private KafkaMessageValidator kafkaMessageValidator;
    private KafkaProducerRepository repository;
    private KafkaMessageSender kafkaMessageSender;
    private String configResourceUri;
    private String streamingPath;
    private Map<String, Object> properties;

    KafkaHandlerBuilder() {
    }

    public KafkaHandler build() {
        if (this.vertx == null) {
            throw new NullPointerException("vertx missing");
        }
        if (this.exceptionFactory == null) {
            this.exceptionFactory = GateleenExceptionFactory.newGateleenThriftyExceptionFactory();
        }
        if (this.repository == null) {
            throw new NullPointerException("kafkaProducerRepository missing");
        }
        if (this.kafkaMessageSender == null) {
            throw new NullPointerException("kafkaMessageSender missing");
        }
        if (this.streamingPath == null) {
            log.warn("no 'streamingPath' given. Are you sure you want none?");
        }
        return new KafkaHandler(this.vertx, this.exceptionFactory, this.configurationResourceManager, this.kafkaMessageValidator, this.repository, this.kafkaMessageSender, this.configResourceUri, this.streamingPath, this.properties);
    }

    public KafkaHandlerBuilder withVertx(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    public KafkaHandlerBuilder withExceptionFactory(GateleenExceptionFactory exceptionFactory) {
        this.exceptionFactory = exceptionFactory;
        return this;
    }

    public KafkaHandlerBuilder withConfigurationResourceManager(ConfigurationResourceManager configurationResourceManager) {
        this.configurationResourceManager = configurationResourceManager;
        return this;
    }

    public KafkaHandlerBuilder withKafkaMessageValidator(KafkaMessageValidator kafkaMessageValidator) {
        this.kafkaMessageValidator = kafkaMessageValidator;
        return this;
    }

    public KafkaHandlerBuilder withRepository(KafkaProducerRepository repository) {
        this.repository = repository;
        return this;
    }

    public KafkaHandlerBuilder withKafkaMessageSender(KafkaMessageSender kafkaMessageSender) {
        this.kafkaMessageSender = kafkaMessageSender;
        return this;
    }

    public KafkaHandlerBuilder withConfigResourceUri(String configResourceUri) {
        this.configResourceUri = configResourceUri;
        return this;
    }

    public KafkaHandlerBuilder withStreamingPath(String streamingPath) {
        this.streamingPath = streamingPath;
        return this;
    }

    public KafkaHandlerBuilder withProperties(Map<String, Object> properties) {
        this.properties = properties;
        return this;
    }
}

