/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.kafka;

import io.vertx.core.http.HttpServerRequest;
import java.util.Optional;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.core.util.StringUtils;

class KafkaTopicExtractor {
    private final String streamingPath;

    KafkaTopicExtractor(String streamingPath) {
        this.streamingPath = streamingPath;
    }

    Optional<String> extractTopic(HttpServerRequest request) {
        Logger requestLog = RequestLoggerFactory.getLogger(KafkaTopicExtractor.class, (HttpServerRequest)request);
        String topic = org.apache.commons.lang3.StringUtils.removeStart((String)request.uri(), (String)this.streamingPath);
        if (StringUtils.isNotEmptyTrimmed((String)topic)) {
            return Optional.of(topic);
        }
        requestLog.warn("Extracted an empty string as topic from uri {}", (Object)request.uri());
        return Optional.empty();
    }
}

