/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.kafka;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.kafka.client.producer.KafkaProducerRecord;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.core.validation.ValidationStatus;
import org.swisspush.gateleen.kafka.KafkaHandler;
import org.swisspush.gateleen.validation.SchemaLocation;
import org.swisspush.gateleen.validation.ValidationResource;
import org.swisspush.gateleen.validation.ValidationResourceManager;
import org.swisspush.gateleen.validation.ValidationUtil;
import org.swisspush.gateleen.validation.Validator;

public class KafkaMessageValidator {
    private final ValidationResourceManager validationResourceManager;
    private final Validator validator;
    private final Logger log = LoggerFactory.getLogger(KafkaHandler.class);
    private MeterRegistry meterRegistry;
    private final Map<String, Counter> failedToValidateCounterMap = new HashMap<String, Counter>();
    public static final String FAIL_VALIDATION_MESSAGES_METRIC = "gateleen.kafka.validation.fail.messages";
    public static final String FAIL_VALIDATION_MESSAGES_METRIC_DESCRIPTION = "Amount of failed kafka message validations";
    public static final String TOPIC = "topic";

    public KafkaMessageValidator(ValidationResourceManager validationResourceManager, Validator validator) {
        this.validationResourceManager = validationResourceManager;
        this.validator = validator;
    }

    public void setMeterRegistry(MeterRegistry meterRegistry) {
        this.meterRegistry = meterRegistry;
        this.failedToValidateCounterMap.clear();
    }

    public Future<ValidationResult> validateMessages(HttpServerRequest request, List<KafkaProducerRecord<String, String>> kafkaProducerRecords) {
        if (kafkaProducerRecords.isEmpty()) {
            return Future.succeededFuture((Object)new ValidationResult(ValidationStatus.VALIDATED_POSITIV));
        }
        Map entry = ValidationUtil.matchingValidationResourceEntry((ValidationResource)this.validationResourceManager.getValidationResource(), (HttpServerRequest)request, (Logger)this.log);
        if (entry == null) {
            return Future.succeededFuture((Object)new ValidationResult(ValidationStatus.VALIDATED_POSITIV));
        }
        Optional optionalSchemaLocation = ValidationUtil.matchingSchemaLocation((ValidationResource)this.validationResourceManager.getValidationResource(), (HttpServerRequest)request, (Logger)this.log);
        if (optionalSchemaLocation.isEmpty()) {
            this.log.warn("No schema location found for {}. Could not validate kafka message", (Object)request.uri());
            return Future.succeededFuture((Object)new ValidationResult(ValidationStatus.COULD_NOT_VALIDATE));
        }
        SchemaLocation schemaLocation = (SchemaLocation)optionalSchemaLocation.get();
        String topic = kafkaProducerRecords.get(0).topic();
        List futures = kafkaProducerRecords.stream().map(message -> this.validator.validateWithSchemaLocation(schemaLocation, Buffer.buffer((String)((String)message.value())), this.log)).collect(Collectors.toList());
        return CompositeFuture.all(futures).compose(compositeFuture -> {
            for (Object o : compositeFuture.list()) {
                if (((ValidationResult)o).getValidationStatus() == ValidationStatus.VALIDATED_POSITIV) continue;
                this.incrementValidationFailCount(topic);
                return Future.succeededFuture((Object)((ValidationResult)o));
            }
            return Future.succeededFuture((Object)new ValidationResult(ValidationStatus.VALIDATED_POSITIV));
        }, throwable -> {
            this.incrementValidationFailCount(topic);
            return Future.failedFuture((Throwable)throwable);
        });
    }

    private void incrementValidationFailCount(String topic) {
        Counter counter = this.failedToValidateCounterMap.get(topic);
        if (counter != null) {
            counter.increment();
            return;
        }
        if (this.meterRegistry != null) {
            Counter newCounter = Counter.builder((String)FAIL_VALIDATION_MESSAGES_METRIC).description(FAIL_VALIDATION_MESSAGES_METRIC_DESCRIPTION).tag(TOPIC, topic).register(this.meterRegistry);
            newCounter.increment();
            this.failedToValidateCounterMap.put(topic, newCounter);
        }
    }
}

