/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.DailyRollingFileAppender;
import org.apache.log4j.EnhancedPatternLayout;
import org.apache.log4j.Layout;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.event.EventBusWriter;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.logging.EventBusAppender;
import org.swisspush.gateleen.logging.FilterResult;
import org.swisspush.gateleen.logging.LoggingResource;
import org.swisspush.gateleen.logging.LoggingResourceManager;
import org.swisspush.gateleen.logging.RequestPropertyFilter;

public class LoggingHandler {
    private HttpServerRequest request;
    private MultiMap requestHeaders;
    private HttpClientResponse response;
    private boolean active = false;
    private Buffer requestPayload;
    private Buffer responsePayload;
    private LoggingResource loggingResource;
    private EventBus eventBus;
    private String currentDestination;
    private static final String LOGGING_DIR_PROPERTY = "org.swisspush.logging.dir";
    private static final String CONTENT_TYPE = "content-type";
    private static final String APPLICATION_JSON = "application/json";
    private static final String DEFAULT_LOGGER = "RequestLog";
    private static final String REJECT = "reject";
    private static final String DESTINATION = "destination";
    private static final String DESCRIPTION = "description";
    private static final String META_DATA = "metadata";
    private static final String TRANSMISSION = "transmission";
    private static final String URL = "url";
    private static final String METHOD = "method";
    private static final String STATUS_CODE = "statusCode";
    private static final String STATUS_MESSAGE = "statusMessage";
    private static final String REQUEST = "request";
    private static final String RESPONSE = "response";
    private static final String HEADERS = "headers";
    private static final String BODY = "body";
    private static final String FILE = "file";
    private static final String ADDRESS = "address";
    private Map<String, org.apache.log4j.Logger> loggers = new HashMap<String, org.apache.log4j.Logger>();
    private Map<String, Appender> appenders = new HashMap<String, Appender>();
    private Logger log;

    public LoggingHandler(LoggingResourceManager loggingResourceManager, HttpServerRequest request, EventBus eventBus) {
        this.request = request;
        this.eventBus = eventBus;
        this.loggingResource = loggingResourceManager.getLoggingResource();
        this.log = RequestLoggerFactory.getLogger(LoggingHandler.class, (HttpServerRequest)request);
        boolean stopValidation = false;
        block0: for (Map<String, String> payloadFilter : this.loggingResource.getPayloadFilters()) {
            if (this.active || stopValidation) break;
            ArrayList<Map.Entry<String, String>> payloadFilterEntrySetList = new ArrayList<Map.Entry<String, String>>();
            for (Map.Entry<String, String> filterEntry : payloadFilter.entrySet()) {
                if (filterEntry.getKey().equalsIgnoreCase(URL)) {
                    payloadFilterEntrySetList.add(0, filterEntry);
                    continue;
                }
                payloadFilterEntrySetList.add(filterEntry);
            }
            boolean reject = Boolean.parseBoolean(payloadFilter.get(REJECT));
            for (Map.Entry entry : payloadFilterEntrySetList) {
                if (REJECT.equalsIgnoreCase((String)entry.getKey()) || DESTINATION.equalsIgnoreCase((String)entry.getKey()) || DESCRIPTION.equalsIgnoreCase((String)entry.getKey())) continue;
                FilterResult result = RequestPropertyFilter.filterProperty(request, (String)entry.getKey(), (String)entry.getValue(), reject);
                if (result == FilterResult.FILTER) {
                    this.active = true;
                    this.currentDestination = this.createLoggerAndGetDestination(payloadFilter);
                    continue;
                }
                if (result == FilterResult.REJECT) {
                    this.active = false;
                    stopValidation = true;
                    continue block0;
                }
                if (result != FilterResult.NO_MATCH) continue;
                this.active = false;
                continue block0;
            }
        }
    }

    public boolean isActive() {
        return this.active;
    }

    private String createLoggerAndGetDestination(Map<String, String> payloadFilter) {
        String filterDestination = payloadFilter.get(DESTINATION);
        if (filterDestination == null) {
            this.log.debug("no filterDestination set");
            filterDestination = "default";
        }
        if (this.loggingResource.getDestinationEntries().containsKey(filterDestination)) {
            Map<String, String> destinationOptions = this.loggingResource.getDestinationEntries().get(filterDestination);
            Appender appender = null;
            if (destinationOptions.containsKey(FILE)) {
                this.log.debug("found destination entry with type 'file' for: " + filterDestination);
                appender = this.getFileAppender(filterDestination, destinationOptions.get(FILE));
            } else if (destinationOptions.containsKey(ADDRESS)) {
                this.log.debug("found destination entry with type 'eventBus' for: " + filterDestination);
                appender = this.getEventBusAppender(filterDestination, destinationOptions);
            } else {
                this.log.warn("Unknown typeLocation for destination: " + filterDestination);
            }
            if (appender != null) {
                if (!this.loggers.containsKey(filterDestination)) {
                    org.apache.log4j.Logger filterLogger = org.apache.log4j.Logger.getLogger((String)("LOG_FILTER_" + payloadFilter.get(URL)));
                    filterLogger.removeAllAppenders();
                    filterLogger.addAppender(appender);
                    filterLogger.setAdditivity(false);
                    this.loggers.put(filterDestination, filterLogger);
                }
            } else {
                this.loggers.put(filterDestination, org.apache.log4j.Logger.getLogger((String)DEFAULT_LOGGER));
            }
        } else {
            this.log.warn("no destination entry with name '" + filterDestination + "' found, using default logger instead");
            this.loggers.put(filterDestination, org.apache.log4j.Logger.getLogger((String)DEFAULT_LOGGER));
        }
        return filterDestination;
    }

    private Appender getEventBusAppender(String filterDestination, Map<String, String> destinationOptions) {
        if (!this.appenders.containsKey(filterDestination)) {
            EventBusAppender appender = new EventBusAppender();
            EventBusAppender.setEventBus(this.eventBus);
            appender.setName(filterDestination);
            appender.setAddress(destinationOptions.get(ADDRESS));
            appender.setDeliveryOptionsHeaders(new CaseInsensitiveHeaders().add(META_DATA, destinationOptions.get(META_DATA)));
            appender.setTransmissionMode(EventBusWriter.TransmissionMode.fromString((String)destinationOptions.get(TRANSMISSION)));
            EnhancedPatternLayout layout = new EnhancedPatternLayout();
            layout.setConversionPattern("%m%n");
            appender.setLayout((Layout)layout);
            this.appenders.put(filterDestination, (Appender)appender);
        }
        return this.appenders.get(filterDestination);
    }

    private Appender getFileAppender(String filterDestination, String fileName) {
        if (!this.appenders.containsKey(filterDestination)) {
            this.log.debug("file path: " + System.getProperty(LOGGING_DIR_PROPERTY) + fileName);
            DailyRollingFileAppender appender = new DailyRollingFileAppender();
            appender.setName(filterDestination);
            appender.setFile(System.getProperty(LOGGING_DIR_PROPERTY) + fileName);
            appender.setEncoding("UTF-8");
            appender.setAppend(true);
            EnhancedPatternLayout layout = new EnhancedPatternLayout();
            layout.setConversionPattern("%m%n");
            appender.setLayout((Layout)layout);
            appender.activateOptions();
            this.appenders.put(filterDestination, (Appender)appender);
        }
        return this.appenders.get(filterDestination);
    }

    public void setResponse(HttpClientResponse response) {
        this.response = response;
    }

    public void request(MultiMap headers) {
        this.requestHeaders = headers;
    }

    public void appendRequestPayload(Buffer data) {
        this.appendRequestPayload(data, this.request.headers());
    }

    public void appendResponsePayload(Buffer data) {
        this.appendResponsePayload(data, this.response.headers());
    }

    public void appendRequestPayload(Buffer data, MultiMap headers) {
        if (this.active && this.isJsonContent(headers)) {
            this.getRequestPayload().appendBuffer(data);
        }
    }

    public void appendResponsePayload(Buffer data, MultiMap headers) {
        if (this.active && this.isJsonContent(headers)) {
            this.getResponsePayload().appendBuffer(data);
        }
    }

    public void log() {
        this.log(this.request.uri(), this.request.method(), this.response.statusCode(), this.response.statusMessage(), this.requestHeaders, this.response.headers());
    }

    public void log(String uri, HttpMethod method, int statusCode, String statusMessage, MultiMap requestHeaders, MultiMap responseHeaders) {
        if (this.active) {
            JsonObject logEvent = new JsonObject().put(URL, uri).put(METHOD, method.name()).put(STATUS_CODE, Integer.valueOf(statusCode)).put(STATUS_MESSAGE, statusMessage);
            JsonObject requestLog = new JsonObject();
            JsonObject responseLog = new JsonObject();
            logEvent.put(REQUEST, requestLog);
            logEvent.put(RESPONSE, responseLog);
            requestLog.put(HEADERS, this.headersAsJson(requestHeaders));
            responseLog.put(HEADERS, this.headersAsJson(responseHeaders));
            if (this.requestPayload != null) {
                try {
                    requestLog.put(BODY, new JsonObject(this.requestPayload.toString("UTF-8")));
                }
                catch (DecodeException decodeException) {
                    // empty catch block
                }
            }
            if (this.responsePayload != null) {
                try {
                    responseLog.put(BODY, new JsonObject(this.responsePayload.toString("UTF-8")));
                }
                catch (DecodeException decodeException) {
                    // empty catch block
                }
            }
            try {
                this.aboutToLogRequest(this.currentDestination);
                this.loggers.get(this.currentDestination).info((Object)logEvent.encode());
            }
            catch (Exception ex) {
                this.errorLogRequest(this.currentDestination, ex);
            }
        }
    }

    private void aboutToLogRequest(String currentDestination) {
        this.log.info("About to log to destination " + currentDestination);
    }

    private void errorLogRequest(String currentDestination, Exception ex) {
        this.log.error("Error logging to destination " + currentDestination + ". Cause: " + ex.toString());
    }

    private JsonObject headersAsJson(MultiMap headers) {
        JsonObject obj = new JsonObject();
        switch (this.loggingResource.getHeaderLogStrategy()) {
            case LOG_ALL: {
                for (Map.Entry entry : headers) {
                    String key = ((String)entry.getKey()).toLowerCase();
                    obj.put(key, (String)entry.getValue());
                }
                break;
            }
            case LOG_LIST: {
                for (String header : this.loggingResource.getHeaders()) {
                    String value = headers.get(header);
                    if (value == null) continue;
                    obj.put(header, value);
                }
                break;
            }
            case LOG_NONE: {
                return obj;
            }
            default: {
                this.loggers.get(this.currentDestination).warn((Object)("Unsupported HeaderLogStrategy '" + (Object)((Object)this.loggingResource.getHeaderLogStrategy()) + "' used. Log nothing!"));
            }
        }
        return obj;
    }

    private Buffer getRequestPayload() {
        if (this.requestPayload == null) {
            this.requestPayload = Buffer.buffer();
        }
        return this.requestPayload;
    }

    private Buffer getResponsePayload() {
        if (this.responsePayload == null) {
            this.responsePayload = Buffer.buffer();
        }
        return this.responsePayload;
    }

    private boolean isJsonContent(MultiMap headers) {
        return headers.contains(CONTENT_TYPE) && headers.get(CONTENT_TYPE).contains(APPLICATION_JSON);
    }
}

