/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.swisspush.gateleen.core.logging.LoggableResource;
import org.swisspush.gateleen.core.logging.RequestLogger;
import org.swisspush.gateleen.core.storage.ResourceStorage;
import org.swisspush.gateleen.core.util.ResourcesUtils;
import org.swisspush.gateleen.core.util.ResponseStatusCodeLogUtil;
import org.swisspush.gateleen.core.util.StatusCode;
import org.swisspush.gateleen.core.util.StringUtils;
import org.swisspush.gateleen.core.validation.ValidationResult;
import org.swisspush.gateleen.logging.LoggingResource;
import org.swisspush.gateleen.validation.ValidationException;
import org.swisspush.gateleen.validation.Validator;

public class LoggingResourceManager
implements LoggableResource {
    private static final String UPDATE_ADDRESS = "gateleen.logging-updated";
    private final String loggingUri;
    private final ResourceStorage storage;
    private final Logger log = LoggerFactory.getLogger(LoggingResourceManager.class);
    private final Vertx vertx;
    private LoggingResource loggingResource;
    private final String loggingResourceSchema;
    private boolean logConfigurationResourceChanges = false;

    public LoggingResource getLoggingResource() {
        if (this.loggingResource == null) {
            this.loggingResource = new LoggingResource();
        }
        return this.loggingResource;
    }

    public LoggingResourceManager(Vertx vertx, ResourceStorage storage, String loggingUri) {
        this.storage = storage;
        this.vertx = vertx;
        this.loggingUri = loggingUri;
        this.loggingResourceSchema = ResourcesUtils.loadResource((String)"gateleen_logging_schema_logging", (boolean)true);
        this.updateLoggingResources();
        vertx.eventBus().consumer(UPDATE_ADDRESS, event -> this.updateLoggingResources());
    }

    public void enableResourceLogging(boolean resourceLoggingEnabled) {
        this.logConfigurationResourceChanges = resourceLoggingEnabled;
    }

    private void updateLoggingResources() {
        this.storage.get(this.loggingUri, buffer -> {
            if (buffer != null) {
                try {
                    this.updateLoggingResources((Buffer)buffer);
                }
                catch (ValidationException e) {
                    this.log.warn("Could not reconfigure logging resources (filters and headers)", (Throwable)e);
                }
            } else {
                this.log.warn("Could not get URL '" + (this.loggingUri == null ? "<null>" : this.loggingUri) + "'.");
            }
        });
    }

    private void updateLoggingResources(Buffer buffer) throws ValidationException {
        this.extractLoggingFilterValues(buffer);
        for (Map<String, String> payloadFilters : this.getLoggingResource().getPayloadFilters()) {
            this.log.info("Applying Logging-Filter: " + payloadFilters);
        }
        switch (this.getLoggingResource().getHeaderLogStrategy()) {
            case LOG_ALL: {
                this.log.info("All headers will be logged");
                break;
            }
            case LOG_NONE: {
                this.log.info("No headers will be logged");
                break;
            }
            case LOG_LIST: {
                this.log.info("Headers to log: " + this.getLoggingResource().getHeaders().toString());
            }
        }
    }

    public boolean handleLoggingResource(HttpServerRequest request) {
        if (request.uri().equals(this.loggingUri) && HttpMethod.PUT == request.method()) {
            request.bodyHandler(loggingResourceBuffer -> {
                try {
                    this.extractLoggingFilterValues((Buffer)loggingResourceBuffer);
                }
                catch (ValidationException validationException) {
                    this.log.error("Could not parse logging resource: " + validationException.toString());
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.BAD_REQUEST, LoggingResourceManager.class);
                    request.response().setStatusCode(StatusCode.BAD_REQUEST.getStatusCode());
                    request.response().setStatusMessage(StatusCode.BAD_REQUEST.getStatusMessage() + " " + validationException.getMessage());
                    if (validationException.getValidationDetails() != null) {
                        request.response().headers().add("content-type", "application/json");
                        request.response().end(validationException.getValidationDetails().encode());
                    } else {
                        request.response().end(validationException.getMessage());
                    }
                    return;
                }
                this.storage.put(this.loggingUri, loggingResourceBuffer, status -> {
                    if (status.intValue() == StatusCode.OK.getStatusCode()) {
                        if (this.logConfigurationResourceChanges) {
                            RequestLogger.logRequest((EventBus)this.vertx.eventBus(), (HttpServerRequest)request, (int)status, (Buffer)loggingResourceBuffer);
                        }
                        this.vertx.eventBus().publish(UPDATE_ADDRESS, (Object)true);
                    } else {
                        request.response().setStatusCode(status.intValue());
                    }
                    ResponseStatusCodeLogUtil.info((HttpServerRequest)request, (StatusCode)StatusCode.fromCode((int)status), LoggingResourceManager.class);
                    request.response().end();
                });
            });
            return true;
        }
        if (request.uri().equals(this.loggingUri) && HttpMethod.DELETE == request.method()) {
            this.getLoggingResource().reset();
            this.log.info("Reset LoggingResource");
        }
        return false;
    }

    private void extractLoggingFilterValues(Buffer loggingResourceBuffer) throws ValidationException {
        ValidationResult validationResult = Validator.validateStatic((Buffer)loggingResourceBuffer, (String)this.loggingResourceSchema, (Logger)this.log);
        if (!validationResult.isSuccess()) {
            throw new ValidationException(validationResult);
        }
        try {
            JsonArray filtersArray;
            JsonObject loggingRes = new JsonObject(loggingResourceBuffer.toString("UTF-8"));
            this.getLoggingResource().reset();
            JsonArray headersJsonArray = loggingRes.getJsonArray("headers");
            if (headersJsonArray == null) {
                this.getLoggingResource().setHeaderLogStrategy(LoggingResource.HeaderLogStrategy.LOG_ALL);
            } else {
                List headersList = headersJsonArray.getList();
                if (headersList != null && headersList.isEmpty()) {
                    this.getLoggingResource().setHeaderLogStrategy(LoggingResource.HeaderLogStrategy.LOG_NONE);
                } else {
                    this.getLoggingResource().setHeaderLogStrategy(LoggingResource.HeaderLogStrategy.LOG_LIST);
                }
                this.getLoggingResource().addHeaders(headersList);
            }
            JsonObject payload = loggingRes.getJsonObject("payload");
            JsonArray destinations = payload.getJsonArray("destinations");
            if (destinations != null) {
                HashMap<String, Map<String, String>> destinationEntries = new HashMap<String, Map<String, String>>();
                for (Object destinationObj : destinations) {
                    JsonObject destination = (JsonObject)destinationObj;
                    String name = destination.getString("name");
                    HashMap<String, String> options = new HashMap<String, String>();
                    options.put("type", destination.getString("type"));
                    String typeLocation = null;
                    if (destination.getString("type").equalsIgnoreCase("file")) {
                        typeLocation = "file";
                    } else if (destination.getString("type").equalsIgnoreCase("eventBus")) {
                        typeLocation = "address";
                        options.put("metadata", StringUtils.getStringOrEmpty((String)destination.getString("metadata")));
                        options.put("transmission", StringUtils.getStringOrDefault((String)destination.getString("transmission"), (String)"publish"));
                    }
                    if (typeLocation != null) {
                        options.put(typeLocation, destination.getString(typeLocation));
                        destinationEntries.put(name, options);
                        continue;
                    }
                    this.log.warn("Could not configure destination '" + name + "'. Missing typeLocation (file|address).");
                }
                this.getLoggingResource().addFilterDestinations(destinationEntries);
            }
            if ((filtersArray = payload.getJsonArray("filters")) != null) {
                for (Object filterEntry : filtersArray) {
                    JsonObject filterObject = (JsonObject)filterEntry;
                    HashMap<String, String> filterEntries = new HashMap<String, String>();
                    for (String filterName : filterObject.fieldNames()) {
                        filterEntries.put(filterName, filterObject.getString(filterName));
                    }
                    this.getLoggingResource().addPayloadFilter(filterEntries);
                }
            }
        }
        catch (Exception ex) {
            this.getLoggingResource().reset();
            throw new ValidationException((Throwable)ex);
        }
    }
}

