/*
 * Decompiled with CFR 0.152.
 */
package org.swisspush.gateleen.logging;

import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.HttpServerRequest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.swisspush.gateleen.core.http.RequestLoggerFactory;
import org.swisspush.gateleen.logging.FilterResult;

public class RequestPropertyFilter {
    public static final String URL = "url";
    public static final String METHOD = "method";

    public static FilterResult filterProperty(HttpServerRequest request, String filterPropertyKey, String filterPropertyValue, boolean reject) {
        CaseInsensitiveHeaders headers = new CaseInsensitiveHeaders();
        headers.setAll(request.headers());
        if (URL.equals(filterPropertyKey)) {
            boolean matches = RequestPropertyFilter.filterRequestURL(request, filterPropertyValue);
            FilterResult result = RequestPropertyFilter.rejectIfNeeded(reject, matches);
            RequestPropertyFilter.logFilterResult(request, filterPropertyKey, filterPropertyValue, result);
            return result;
        }
        if (METHOD.equals(filterPropertyKey)) {
            boolean matches = RequestPropertyFilter.filterRequestMethod(request, filterPropertyValue);
            FilterResult result = RequestPropertyFilter.rejectIfNeeded(reject, matches);
            RequestPropertyFilter.logFilterResult(request, filterPropertyKey, filterPropertyValue, result);
            return result;
        }
        if (headers.names().contains(filterPropertyKey) && headers.get(filterPropertyKey).equalsIgnoreCase(filterPropertyValue)) {
            FilterResult result = reject ? FilterResult.REJECT : FilterResult.FILTER;
            RequestPropertyFilter.logFilterResult(request, filterPropertyKey, filterPropertyValue, result);
            return result;
        }
        RequestPropertyFilter.logFilterResult(request, filterPropertyKey, filterPropertyValue, FilterResult.REJECT, true);
        return FilterResult.REJECT;
    }

    private static FilterResult rejectIfNeeded(boolean reject, boolean matches) {
        if (!matches) {
            return FilterResult.NO_MATCH;
        }
        return reject ? FilterResult.REJECT : FilterResult.FILTER;
    }

    private static boolean filterRequestURL(HttpServerRequest request, String url) {
        Pattern urlPattern = Pattern.compile(url);
        Matcher urlMatcher = urlPattern.matcher(request.uri());
        return urlMatcher.matches();
    }

    private static boolean filterRequestMethod(HttpServerRequest request, String method) {
        Pattern methodPattern = Pattern.compile(method);
        Matcher methodMatcher = methodPattern.matcher(request.method().toString());
        return methodMatcher.matches();
    }

    private static void logFilterResult(HttpServerRequest request, String filterPropertyKey, String filterPropertyValue, FilterResult filterResult) {
        RequestPropertyFilter.logFilterResult(request, filterPropertyKey, filterPropertyValue, filterResult, false);
    }

    private static void logFilterResult(HttpServerRequest request, String filterPropertyKey, String filterPropertyValue, FilterResult filterResult, boolean noMatchingProperty) {
        if (FilterResult.NO_MATCH != filterResult) {
            Logger log = RequestLoggerFactory.getLogger(RequestPropertyFilter.class, (HttpServerRequest)request);
            StringBuilder sb = new StringBuilder("Request to ").append(request.uri());
            if (noMatchingProperty) {
                sb.append(" with no matching filterProperty");
            } else {
                sb.append(" with filterProperty ").append(filterPropertyKey).append("=").append(filterPropertyValue);
            }
            sb.append(" has FilterResult ").append(filterResult.name());
            log.info(sb.toString());
        }
    }
}

